/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import org.openforis.collect.designer.util.ComponentUtil;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Label;

public class CollapsiblePanel
extends Groupbox {
    private static final long serialVersionUID = 1L;
    private static final String SCLASS = "collapsible";

    public CollapsiblePanel() {
        ComponentUtil.addClass((HtmlBasedComponent)this, SCLASS);
        this.setMold("3d");
        this.createAndAddCaption();
        this.addEventListener("onOpen", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                CollapsiblePanel.this.handleOpenChange();
            }
        });
    }

    protected void handleOpenChange() {
        ComponentUtil.toggleClass((HtmlBasedComponent)this, "open", this.isOpen());
        ComponentUtil.toggleClass((HtmlBasedComponent)this, "closed", !this.isOpen());
        this.getCaption().setSclass("open-" + this.isOpen());
    }

    public void setCaptionLabel(String captionText) {
        Label label = (Label)this.getCaption().getFirstChild().getFirstChild();
        label.setValue(captionText);
    }

    public void setOpen(boolean open) {
        super.setOpen(open);
        this.handleOpenChange();
    }

    private void createAndAddCaption() {
        Caption caption = new Caption();
        Div labelWrapper = new Div();
        labelWrapper.setStyle("text-align: left;");
        labelWrapper.getChildren().add(new Label());
        caption.getChildren().add(labelWrapper);
        this.getChildren().add(caption);
    }
}

