/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.openforis.collect.designer.form.NodeDefinitionFormObject;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;

public class EntityDefinitionFormObject<T extends EntityDefinition>
extends NodeDefinitionFormObject<T> {
    private boolean virtual;
    private String generatorExpression;
    private boolean enumerate;
    private boolean showRowNumbers;
    private boolean countInRecordSummary;
    private String direction;
    private String layoutType;

    EntityDefinitionFormObject() {
    }

    EntityDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setVirtual(this.virtual);
        dest.setGeneratorExpression(this.virtual ? this.generatorExpression : null);
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        dest.setEnumerate(survey.getTarget() == SurveyTarget.COLLECT_EARTH || this.enumerate);
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)dest);
        UIOptions.Layout layout = UIOptions.Layout.valueOf((String)this.layoutType);
        uiOptions.setLayout(dest, layout);
        uiOptions.setCountInSummaryListValue(dest, this.countInRecordSummary);
        uiOptions.setShowRowNumbersValue(dest, this.showRowNumbers);
        UIOptions.Direction directionEnum = super.isMultiple() && layout == UIOptions.Layout.TABLE && UIOptions.Direction.BY_COLUMNS.getValue().equals(this.direction) ? UIOptions.Direction.BY_COLUMNS : null;
        this.direction = directionEnum == null ? null : directionEnum.getValue();
        uiOptions.setDirection(dest, directionEnum);
    }

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.virtual = source.isVirtual();
        this.generatorExpression = source.getGeneratorExpression();
        this.enumerate = source.isEnumerate();
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)source);
        UIOptions.Layout layout = uiOptions.getLayout(source);
        this.layoutType = layout.name();
        this.countInRecordSummary = uiOptions.getCountInSumamryListValue(source);
        this.showRowNumbers = uiOptions.getShowRowNumbersValue(source);
        this.direction = uiOptions.getDirection(source).getValue();
    }

    @Override
    protected void reset() {
        super.reset();
        this.layoutType = null;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public String getGeneratorExpression() {
        return this.generatorExpression;
    }

    public void setGeneratorExpression(String generatorExpression) {
        this.generatorExpression = generatorExpression;
    }

    public boolean isEnumerate() {
        return this.enumerate;
    }

    public void setEnumerate(boolean enumerate) {
        this.enumerate = enumerate;
    }

    public String getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(String layoutType) {
        this.layoutType = layoutType;
    }

    public boolean isShowRowNumbers() {
        return this.showRowNumbers;
    }

    public void setShowRowNumbers(boolean showRowNumbers) {
        this.showRowNumbers = showRowNumbers;
    }

    public boolean isCountInRecordSummary() {
        return this.countInRecordSummary;
    }

    public void setCountInRecordSummary(boolean countInRecordSummary) {
        this.countInRecordSummary = countInRecordSummary;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }
}

