/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.metamodel.view.SurveyView;
import org.openforis.collect.metamodel.view.SurveyViewGenerator;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.persistence.RecordUnlockedException;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.controller.UserController;
import org.openforis.collect.web.session.SessionState;
import org.openforis.commons.web.HttpResponses;
import org.openforis.commons.web.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/session"})
public class SessionController
extends BasicController {
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private UserGroupManager userGroupManager;

    @RequestMapping(value={"ping"}, method={RequestMethod.GET})
    @ResponseBody
    public Response ping(@RequestParam(value="editing", required=false, defaultValue="false") Boolean editing) throws RecordUnlockedException {
        if (editing.booleanValue()) {
            this.sessionManager.checkIsActiveRecordLocked();
        }
        return new Response();
    }

    @RequestMapping(value={"survey"}, method={RequestMethod.POST})
    @ResponseBody
    public Response setActiveSurvey(@RequestParam int surveyId) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        this.sessionManager.setActiveSurvey(survey);
        return new Response();
    }

    @RequestMapping(value={"survey"}, method={RequestMethod.GET})
    @ResponseBody
    public SurveyView getActiveSurvey(HttpServletResponse response) {
        CollectSurvey survey = this.getUpdatedActiveSurvey();
        if (survey == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        SessionState sessionState = this.sessionManager.getSessionState();
        Locale locale = sessionState.getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        SurveyViewGenerator viewGenerator = new SurveyViewGenerator(locale.getLanguage());
        UserInGroup userInSurveyGroup = this.userGroupManager.findUserInGroupOrDescendants(survey.getUserGroupId().intValue(), sessionState.getUser().getId().intValue());
        UserGroup userGroup = userInSurveyGroup == null ? null : (UserGroup)this.userGroupManager.loadById((Object)userInSurveyGroup.getGroupId());
        SurveyView view = viewGenerator.generateView(survey, userGroup, userInSurveyGroup == null ? null : userInSurveyGroup.getRole());
        return view;
    }

    @RequestMapping(value={"initialize"}, method={RequestMethod.POST})
    @ResponseBody
    public UserController.UserForm initialize(HttpServletRequest request) {
        SessionState sessionState = this.sessionManager.getSessionState();
        User user = sessionState.getUser();
        sessionState.setLocale(request.getLocale());
        return new UserController.UserForm(user);
    }

    @RequestMapping(value={"user"}, method={RequestMethod.GET})
    @ResponseBody
    public UserController.UserForm getLoggedUser(HttpServletRequest request, HttpServletResponse response) {
        User user;
        SessionState sessionState = this.sessionManager.getSessionState();
        User user2 = user = sessionState == null ? null : sessionState.getUser();
        if (user == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        if (sessionState.getLocale() == null) {
            sessionState.setLocale(request.getLocale());
        }
        return new UserController.UserForm(user);
    }

    @RequestMapping(value={"record"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void clearActiveRecord() {
        try {
            this.sessionManager.releaseRecord();
        }
        catch (RecordUnlockedException recordUnlockedException) {
            // empty catch block
        }
    }

    @RequestMapping(value={"invalidate"}, method={RequestMethod.POST})
    @ResponseBody
    public Response invalidate(HttpServletRequest request) {
        this.sessionManager.invalidateSession();
        request.getSession().invalidate();
        return new Response();
    }

    private CollectSurvey getUpdatedActiveSurvey() {
        CollectSurvey sessionSurvey = this.sessionManager.getActiveSurvey();
        if (sessionSurvey == null) {
            return null;
        }
        CollectSurvey storedSurvey = sessionSurvey.isTemporary() ? this.surveyManager.loadSurvey(sessionSurvey.getId().intValue()) : this.surveyManager.getById(sessionSurvey.getId().intValue());
        if (storedSurvey == null || storedSurvey.isTemporary() != sessionSurvey.isTemporary()) {
            return null;
        }
        if (storedSurvey.getModifiedDate().compareTo(sessionSurvey.getModifiedDate()) > 0) {
            this.sessionManager.setActiveSurvey(storedSurvey);
            return storedSurvey;
        }
        return sessionSurvey;
    }
}

