/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.SurveyFileVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveyFile;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class SurveyFileFormValidator
extends FormValidator {
    protected static final String SURVEY_MANAGER_ARG = "surveyManager";
    private static final Pattern VALID_FILENAME_PATTERN = Pattern.compile("^[\\w-\\.]+\\.[\\w-]+$");
    private static final String SAIKU_QUERY_FILE_EXTENSION = "saiku";
    private static final Set<String> RESERVED_FILENAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SurveyFile.SurveyFileType.COLLECT_EARTH_AREA_PER_ATTRIBUTE.getFixedFilename(), "balloon.html", "collectEarthCubes.xml.fmt", "kml_template.fmt", "placemark.idm.xml", "project_definition.properties", "README.txt", "test_plots.ced", "earthFiles", "data", "files", "sampling_design", "species", "idml.xml", "info.properties")));

    @Override
    protected void internalValidate(ValidationContext ctx) {
        if (this.validateTypeUniqueness(ctx) && this.validateFilename(ctx)) {
            this.validateFilenameUniqueness(ctx);
        }
    }

    private boolean validateTypeUniqueness(ValidationContext ctx) {
        List<SurveyFile> otherSurveyFiles = this.loadSurveyFilesDifferentFromThis(ctx);
        String typeName = (String)this.getValue(ctx, "type");
        SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
        switch (type) {
            case SURVEY_GUIDE: 
            case COLLECT_EARTH_AREA_PER_ATTRIBUTE: 
            case COLLECT_EARTH_EE_SCRIPT: {
                if (this.containsFileWithType(otherSurveyFiles, type)) {
                    this.addInvalidMessage(ctx, "type", Labels.getLabel((String)"survey.file.error.type_already_defined"));
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean validateFilename(ValidationContext ctx) {
        if (this.validateRequired(ctx, "filename")) {
            if (this.validateFilenamePattern(ctx)) {
                return this.validateFilenameUniqueness(ctx);
            }
            return false;
        }
        return false;
    }

    private boolean validateFilenamePattern(ValidationContext ctx) {
        if (this.validateRegEx(ctx, VALID_FILENAME_PATTERN, "filename", "survey.file.error.invalid_filename")) {
            String filename = (String)this.getValue(ctx, "filename");
            String typeName = (String)this.getValue(ctx, "type");
            SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
            switch (type) {
                case COLLECT_EARTH_AREA_PER_ATTRIBUTE: {
                    String expectedFileName = SurveyFile.SurveyFileType.COLLECT_EARTH_AREA_PER_ATTRIBUTE.getFixedFilename();
                    if (expectedFileName.equals(filename)) {
                        return true;
                    }
                    String message = Labels.getLabel((String)"survey.file.error.unexpected_filename", (Object[])new String[]{expectedFileName});
                    this.addInvalidMessage(ctx, message);
                    return false;
                }
                case COLLECT_EARTH_SAIKU_QUERY: {
                    String extension = FilenameUtils.getExtension((String)filename);
                    if (SAIKU_QUERY_FILE_EXTENSION.equalsIgnoreCase(extension)) break;
                    String message = Labels.getLabel((String)"survey.file.error.invalid_extension", (Object[])new String[]{SAIKU_QUERY_FILE_EXTENSION, extension});
                    this.addInvalidMessage(ctx, "filename", message);
                    return false;
                }
            }
            if (RESERVED_FILENAMES.contains(filename)) {
                this.addInvalidMessage(ctx, "filename", Labels.getLabel((String)"survey.file.error.reserved_filename"));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validateFilenameUniqueness(ValidationContext ctx) {
        List<SurveyFile> otherSurveyFiles = this.loadSurveyFilesDifferentFromThis(ctx);
        String filename = (String)this.getValue(ctx, "filename");
        for (SurveyFile surveyFile : otherSurveyFiles) {
            if (!surveyFile.getFilename().equals(filename)) continue;
            this.addInvalidMessage(ctx, "filename", Labels.getLabel((String)"survey.file.error.duplicate_filename"));
            return false;
        }
        return true;
    }

    private List<SurveyFile> loadSurveyFilesDifferentFromThis(ValidationContext ctx) {
        ArrayList<SurveyFile> result = new ArrayList<SurveyFile>();
        SurveyFileVM vm = (SurveyFileVM)this.getVM(ctx);
        CollectSurvey survey = vm.getSurvey();
        SurveyManager surveyManager = this.getSurveyManager(ctx);
        List surveyFiles = surveyManager.loadSurveyFileSummaries(survey);
        SurveyFile editedSurveyFile = (SurveyFile)vm.getEditedItem();
        for (SurveyFile surveyFile : surveyFiles) {
            if (((Integer)surveyFile.getId()).equals(editedSurveyFile.getId())) continue;
            result.add(surveyFile);
        }
        return result;
    }

    private boolean containsFileWithType(List<SurveyFile> files, SurveyFile.SurveyFileType type) {
        for (SurveyFile surveyFile : files) {
            if (type != surveyFile.getType()) continue;
            return true;
        }
        return false;
    }

    protected SurveyManager getSurveyManager(ValidationContext ctx) {
        return (SurveyManager)ctx.getValidatorArg(SURVEY_MANAGER_ARG);
    }
}

