/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.Date;
import java.util.List;
import org.openforis.collect.Proxy;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;

public class RecordFilterProxy
implements Proxy {
    private boolean caseSensitiveKeyValues;
    private Integer offset;
    private List<String> keyValues;
    private Integer maxNumberOfRecords;
    private Date modifiedSince;
    private List<Integer> ownerIds;
    private Integer recordId;
    private Integer rootEntityId;
    private CollectRecord.Step step;
    private CollectRecord.Step stepGreaterOrEqual;
    private int surveyId;

    public RecordFilterProxy(RecordFilter filter) {
        this.caseSensitiveKeyValues = filter.isCaseSensitiveKeyValues();
        this.keyValues = filter.getKeyValues();
        this.maxNumberOfRecords = filter.getMaxNumberOfRecords();
        this.modifiedSince = filter.getModifiedSince();
        this.offset = filter.getOffset();
        this.ownerIds = filter.getOwnerIds();
        this.recordId = filter.getRecordId();
        this.rootEntityId = filter.getRootEntityId();
        this.step = filter.getStep();
        this.stepGreaterOrEqual = filter.getStepGreaterOrEqual();
        this.surveyId = filter.getSurveyId();
    }

    public RecordFilter toFilter(CollectSurvey survey) {
        RecordFilter filter = new RecordFilter(survey);
        filter.setCaseSensitiveKeyValues(this.isCaseSensitiveKeyValues());
        filter.setKeyValues(this.getKeyValues());
        filter.setMaxNumberOfRecords(this.getMaxNumberOfRecords());
        filter.setModifiedSince(this.getModifiedSince());
        filter.setOffset(this.getOffset());
        filter.setOwnerIds(this.getOwnerIds());
        filter.setRecordId(this.getRecordId());
        filter.setRootEntityId(this.getRootEntityId());
        filter.setStep(this.getStep());
        filter.setStepGreaterOrEqual(this.getStepGreaterOrEqual());
        return filter;
    }

    public boolean isCaseSensitiveKeyValues() {
        return this.caseSensitiveKeyValues;
    }

    public void setCaseSensitiveKeyValues(boolean caseSensitiveKeyValues) {
        this.caseSensitiveKeyValues = caseSensitiveKeyValues;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public List<String> getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(List<String> keyValues) {
        this.keyValues = keyValues;
    }

    public Integer getMaxNumberOfRecords() {
        return this.maxNumberOfRecords;
    }

    public void setMaxNumberOfRecords(Integer maxNumberOfRecords) {
        this.maxNumberOfRecords = maxNumberOfRecords;
    }

    public Date getModifiedSince() {
        return this.modifiedSince;
    }

    public void setModifiedSince(Date modifiedSince) {
        this.modifiedSince = modifiedSince;
    }

    public List<Integer> getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(List<Integer> ownerIds) {
        this.ownerIds = ownerIds;
    }

    public Integer getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Integer recordId) {
        this.recordId = recordId;
    }

    public Integer getRootEntityId() {
        return this.rootEntityId;
    }

    public void setRootEntityId(Integer rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public CollectRecord.Step getStep() {
        return this.step;
    }

    public void setStep(CollectRecord.Step step) {
        this.step = step;
    }

    public CollectRecord.Step getStepGreaterOrEqual() {
        return this.stepGreaterOrEqual;
    }

    public void setStepGreaterOrEqual(CollectRecord.Step stepGreaterOrEqual) {
        this.stepGreaterOrEqual = stepGreaterOrEqual;
    }

    public int getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(int surveyId) {
        this.surveyId = surveyId;
    }
}

