/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.SurveyBackupJob;
import org.openforis.collect.io.data.backup.BackupStorageManager;
import org.openforis.collect.io.proxy.SurveyBackupJobProxy;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.User;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.web.session.SessionState;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.proxy.JobProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api"})
public class BackupRestoreController {
    private static final String BACKUP_FILE_EXTENSION = "collect-backup";
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private BackupStorageManager backupStorageManager;
    @Autowired
    private CollectJobManager jobManager;
    private SurveyBackupJob backupJob;

    @RequestMapping(value={"survey/{surveyId}/backup/latest/info"}, method={RequestMethod.GET})
    @ResponseBody
    public BackupInfo getLatestBackupInfo(@PathVariable(value="surveyId") int surveyId) {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        Date date = this.backupStorageManager.getLastBackupDate(survey.getName());
        RecordFilter filter = new RecordFilter(survey);
        filter.setModifiedSince(date);
        int updatedRecordsSinceBackupDateCount = this.recordManager.countRecords(filter);
        return new BackupInfo(date, updatedRecordsSinceBackupDateCount);
    }

    @RequestMapping(value={"survey/{surveyId}/backup/start"}, method={RequestMethod.POST})
    @ResponseBody
    public JobProxy startBackup(@PathVariable(value="surveyId") int surveyId) {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        return this.startFullExport(survey, true, false, null, true);
    }

    @Transactional
    public JobProxy startFullExport(CollectSurvey survey, boolean includeRecordFiles, boolean onlyOwnedRecords, String[] rootEntityKeyValues, boolean full) {
        if (this.backupJob == null || !this.backupJob.isRunning()) {
            this.resetJobs();
            RecordFilter filter = this.createRecordFilter(survey, null, onlyOwnedRecords, rootEntityKeyValues);
            SurveyBackupJob job = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
            job.setFull(full);
            if (full) {
                job.setOutputFormat(SurveyBackupJob.OutputFormat.DESKTOP_FULL);
            } else {
                job.setOutputFormat(SurveyBackupJob.OutputFormat.ONLY_DATA);
            }
            job.setSurvey(survey);
            job.setIncludeData(true);
            job.setIncludeRecordFiles(includeRecordFiles);
            job.setRecordFilter(filter);
            this.backupJob = job;
            this.jobManager.start((Job)job);
        }
        return this.getCurrentJob();
    }

    @RequestMapping(value={"survey/{surveyId}/backup/latest.collect-backup"}, method={RequestMethod.GET})
    public void downloadLatestBackup(@PathVariable(value="surveyId") int surveyId, HttpServletResponse response) throws FileNotFoundException, IOException {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        String surveyName = survey.getName();
        File file = this.backupStorageManager.getLastBackupFile(surveyName);
        Date date = this.backupStorageManager.getLastBackupDate(surveyName);
        Controllers.writeFileToResponse(response, file, String.format("%s-%s.%s", surveyName, Dates.formatLocalDateTime((Date)date), BACKUP_FILE_EXTENSION), "application/zip");
    }

    @RequestMapping(value={"survey/{surveyId}/backup/result"}, method={RequestMethod.GET})
    public void downloadBackupExportResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        File file = this.backupJob.getOutputFile();
        CollectSurvey survey = this.backupJob.getSurvey();
        String surveyName = survey.getName();
        Controllers.writeFileToResponse(response, file, String.format("%s-%s.%s", surveyName, Dates.formatLocalDateTime((Date)new Date()), BACKUP_FILE_EXTENSION), "application/zip");
    }

    private RecordFilter createRecordFilter(CollectSurvey survey, Integer rootEntityId, boolean onlyOwnedRecords, String[] rootEntityKeyValues) {
        RecordFilter recordFilter = new RecordFilter(survey, rootEntityId);
        if (onlyOwnedRecords) {
            SessionState sessionState = this.sessionManager.getSessionState();
            User user = sessionState.getUser();
            recordFilter.setOwnerId(user.getId().intValue());
        }
        recordFilter.setKeyValues(rootEntityKeyValues);
        return recordFilter;
    }

    private void resetJobs() {
        this.backupJob = null;
    }

    public JobProxy getCurrentJob() {
        if (this.backupJob != null) {
            return new SurveyBackupJobProxy(this.backupJob);
        }
        return null;
    }

    public static class BackupInfo {
        private Date date;
        private int updatedRecordsSinceBackup;

        public BackupInfo() {
        }

        public BackupInfo(Date date, int updatedRecordsSinceBackup) {
            this.date = date;
            this.updatedRecordsSinceBackup = updatedRecordsSinceBackup;
        }

        public Date getDate() {
            return this.date;
        }

        public int getUpdatedRecordsSinceBackup() {
            return this.updatedRecordsSinceBackup;
        }
    }
}

