/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.data;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.manager.RandomValuesGenerator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.RecordUpdater;
import org.openforis.collect.model.SurveyFile;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.model.User;
import org.openforis.collect.utils.Files;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.commons.io.flat.FlatRecord;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RandomRecordsGenerationJob
extends SurveyLockingJob {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordManager recordManager;
    private User user;
    private double percentage;
    private String sourceGridSurveyFileName;
    private String oldMeasurement;
    private String newMeasurement;
    private CollectSurvey tempSurvey;
    private String outputGridSurveyFileName;
    private Boolean countOnly;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        String surveyUri = this.survey.getUri();
        SurveySummary surveySummary = this.surveyManager.loadSummaryByUri(surveyUri);
        if (!surveySummary.isTemporary()) {
            this.tempSurvey = this.surveyManager.createTemporarySurveyFromPublished(surveyUri, this.user);
        } else {
            Integer tempSurveyId = surveySummary.getId();
            this.tempSurvey = this.surveyManager.getOrLoadSurveyById(tempSurveyId.intValue());
        }
        this.outputGridSurveyFileName = this.generateOutputGridSurveyFileName();
        List surveyFileSummaries = this.surveyManager.loadSurveyFileSummaries(this.tempSurvey);
        for (SurveyFile surveyFile : surveyFileSummaries) {
            if (!surveyFile.getFilename().equals(this.outputGridSurveyFileName)) continue;
            throw new Exception("Grid file with the same name already exists: " + this.outputGridSurveyFileName);
        }
    }

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new RandomGridGenerationTask());
    }

    protected void validateInput() throws Throwable {
        super.validateInput();
        AttributeDefinition measurementKeyDef = this.survey.getFirstMeasurementKeyDef();
        if (measurementKeyDef == null) {
            throw new Exception("Expected at least one measurement attribute");
        }
    }

    protected void afterExecute() {
        super.afterExecute();
        if (this.isCompleted() && !Boolean.TRUE.equals(this.countOnly)) {
            File outputFile = ((RandomGridGenerationTask)((Object)this.getTasks().get(0))).outputFile;
            SurveyFile surveyFile = new SurveyFile(this.tempSurvey);
            surveyFile.setType(SurveyFile.SurveyFileType.COLLECT_EARTH_GRID);
            String outputGridSurveyFileName = this.generateOutputGridSurveyFileName();
            surveyFile.setFilename(outputGridSurveyFileName);
            this.surveyManager.addSurveyFile(surveyFile, outputFile);
            outputFile.delete();
        }
    }

    protected Map<String, Object> prepareResult() {
        Map result = super.prepareResult();
        RandomGridGenerationTask task = (RandomGridGenerationTask)((Object)this.getTasks().get(0));
        result.put("recordsCount", task.getTotalItems());
        return result;
    }

    private String generateOutputGridSurveyFileName() {
        AttributeDefinition measurementKeyDef = this.survey.getFirstMeasurementKeyDef();
        String inputName = FileNameUtils.getBaseName((String)this.sourceGridSurveyFileName);
        return inputName + "_" + measurementKeyDef.getName() + "_" + this.newMeasurement + ".csv";
    }

    public void setSurveyManager(SurveyManager surveyManager) {
        this.surveyManager = surveyManager;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public void setSourceGridSurveyFileName(String sourceGridSurveyFileName) {
        this.sourceGridSurveyFileName = sourceGridSurveyFileName;
    }

    public void setOldMeasurement(String oldMeasurement) {
        this.oldMeasurement = oldMeasurement;
    }

    public void setNewMeasurement(String newMeasurement) {
        this.newMeasurement = newMeasurement;
    }

    public void setCountOnly(Boolean countOnly) {
        this.countOnly = countOnly;
    }

    private static class RandomRecordKeysGenerationResult {
        Set<String> keyValues;
        Map<String, Integer> recordIdByKeyValue;

        private RandomRecordKeysGenerationResult() {
        }
    }

    private class RandomGridGenerationTask
    extends Task {
        private static final String ID_COLUMN = "id";
        private File outputFile;

        private RandomGridGenerationTask() {
        }

        protected void execute() throws Throwable {
            RandomRecordKeysGenerationResult keyValuesGenerationResult = this.generateRandomKeyValues();
            Set<String> randomPlotIds = keyValuesGenerationResult.keyValues;
            int totalItems = randomPlotIds.size();
            if (totalItems == 0) {
                throw new Error("No records to clone");
            }
            this.setTotalItems(totalItems);
            if (!Boolean.TRUE.equals(RandomRecordsGenerationJob.this.countOnly)) {
                RecordUpdater recordUpdater = new RecordUpdater();
                AttributeDefinition measurementKeyDef = RandomRecordsGenerationJob.this.survey.getFirstMeasurementKeyDef();
                for (String plotId : randomPlotIds) {
                    int recordId = keyValuesGenerationResult.recordIdByKeyValue.get(plotId);
                    CollectRecord record = RandomRecordsGenerationJob.this.recordManager.load(RandomRecordsGenerationJob.this.survey, recordId);
                    record.setId(null);
                    Entity rootEntity = record.getRootEntity();
                    Attribute measurementKeyAttr = (Attribute)rootEntity.getChild((NodeDefinition)measurementKeyDef);
                    Value newMeasurementValue = measurementKeyDef.createValue(RandomRecordsGenerationJob.this.newMeasurement);
                    recordUpdater.updateAttribute(measurementKeyAttr, newMeasurementValue);
                    RandomRecordsGenerationJob.this.recordManager.save(record);
                    this.incrementProcessedItems();
                }
                this.generateGridFile(randomPlotIds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateGridFile(Set<String> randomPlotIds) throws IOException, FileNotFoundException, UnsupportedEncodingException {
            SurveyFile sourceGridSurveyFile = this.loadSourceSurveyFile();
            byte[] sourceSurveyFileContent = RandomRecordsGenerationJob.this.surveyManager.loadSurveyFileContent(sourceGridSurveyFile);
            File sourceGridFile = Files.witeToTempFile((byte[])sourceSurveyFileContent, (String)"temp_source_grid", (String)".csv");
            this.outputFile = File.createTempFile("random_grid", ".csv");
            FileOutputStream outputStream = null;
            CsvWriter csvWriter = null;
            CsvReader csvReader = null;
            try {
                outputStream = new FileOutputStream(this.outputFile);
                csvWriter = new CsvWriter((OutputStream)outputStream);
                csvReader = new CsvReader(sourceGridFile);
                csvReader.readHeaders();
                List headers = csvReader.getColumnNames();
                csvWriter.writeHeaders(headers);
                AttributeDefinition measurementKeyDef = RandomRecordsGenerationJob.this.survey.getFirstMeasurementKeyDef();
                String measurementAttributeName = measurementKeyDef.getName();
                int measurementColumnIndex = headers.indexOf(measurementAttributeName);
                FlatRecord csvRecord = csvReader.nextRecord();
                while (csvRecord != null && this.isRunning()) {
                    String plotId = (String)csvRecord.getValue(ID_COLUMN, String.class);
                    if (randomPlotIds.contains(plotId)) {
                        Object[] values = csvRecord.toArray();
                        Object[] valuesUpdated = ArrayUtils.clone((Object[])values);
                        valuesUpdated[measurementColumnIndex] = RandomRecordsGenerationJob.this.newMeasurement;
                        csvWriter.writeNext(valuesUpdated);
                    }
                    csvRecord = csvReader.nextRecord();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                IOUtils.closeQuietly(csvWriter);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)csvReader);
            IOUtils.closeQuietly((Closeable)csvWriter);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }

        private SurveyFile loadSourceSurveyFile() {
            List surveyFileSummaries = RandomRecordsGenerationJob.this.surveyManager.loadSurveyFileSummaries(RandomRecordsGenerationJob.this.tempSurvey);
            for (SurveyFile surveyFile : surveyFileSummaries) {
                if (!surveyFile.getFilename().equals(RandomRecordsGenerationJob.this.sourceGridSurveyFileName)) continue;
                return surveyFile;
            }
            return null;
        }

        private RandomRecordKeysGenerationResult generateRandomKeyValues() throws FileNotFoundException, IOException {
            ArrayList<String> keyValues = new ArrayList<String>();
            HashMap<String, Integer> recordIdByKeyValue = new HashMap<String, Integer>();
            RecordFilter filter = new RecordFilter(RandomRecordsGenerationJob.this.survey);
            List oldRecordsSummaries = RandomRecordsGenerationJob.this.recordManager.loadSummaries(filter);
            for (CollectRecordSummary recordSummary : oldRecordsSummaries) {
                List recordKeyValues = recordSummary.getRootEntityKeyValues();
                String measurementValue = (String)recordKeyValues.get(1);
                if (!RandomRecordsGenerationJob.this.oldMeasurement.equals(measurementValue)) continue;
                String keyValue = (String)recordKeyValues.get(0);
                keyValues.add(keyValue);
                recordIdByKeyValue.put(keyValue, recordSummary.getId());
            }
            List randomKeyValues = RandomValuesGenerator.generateRandomSubset(keyValues, RandomRecordsGenerationJob.this.percentage);
            RandomRecordKeysGenerationResult result = new RandomRecordKeysGenerationResult();
            result.keyValues = new HashSet<String>(randomKeyValues);
            result.recordIdByKeyValue = recordIdByKeyValue;
            return result;
        }
    }
}

