/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.io.metadata.collectearth.CollectEarthGridTemplateGenerator;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreator;
import org.openforis.collect.io.metadata.collectearth.MondrianCubeGenerator;
import org.openforis.collect.io.metadata.collectearth.balloon.CollectEarthBalloonGenerator;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.FileWrapper;
import org.openforis.collect.model.SurveyFile;
import org.openforis.collect.persistence.xml.CollectSurveyIdmlBinder;
import org.openforis.collect.utils.Files;
import org.openforis.collect.utils.ZipFile;
import org.openforis.commons.collection.Visitor;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.PersistedCodeListItem;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.metamodel.Survey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CollectEarthProjectFileCreatorImpl
implements CollectEarthProjectFileCreator {
    private static final String README_FILE_PATH = "org/openforis/collect/designer/templates/collectearth/README.txt";
    private static final String EARTH_FILES_RESOURCE_PATH = "org/openforis/collect/designer/templates/collectearth/earthFiles/";
    private static final String EARTH_FILES_FOLDER_NAME = "earthFiles";
    private static final String KML_TEMPLATE_PATH = "org/openforis/collect/designer/templates/collectearth/kml_template.txt";
    private static final String BALLOON_FILE_NAME = "balloon.html";
    private static final String KML_TEMPLATE_FILE_NAME = "kml_template.fmt";
    private static final String TEST_PLOTS_FILE_NAME = "test_plots.ced";
    private static final String CUBE_FILE_NAME = "collectEarthCubes.xml.fmt";
    private static final String PROJECT_PROPERTIES_FILE_NAME = "project_definition.properties";
    private static final double HECTARES_TO_SQUARE_METERS_CONVERSION_FACTOR = 10000.0;
    private static final String README_FILE = "README.txt";
    private static final String GRID_FOLDER_NAME = "grid";
    private Logger logger = LoggerFactory.getLogger(CollectEarthProjectFileCreatorImpl.class);
    private CodeListManager codeListManager;
    private SurveyManager surveyManager;

    public File create(CollectSurvey survey, String language) throws Exception {
        File outputFile = File.createTempFile("openforis-collect-earth-temp", ".zip");
        outputFile.delete();
        File placemarkFile = this.createPlacemark(survey);
        File projectProperties = this.generateProjectProperties(survey, language);
        File balloon = this.generateBalloon(survey, language);
        File cube = this.generateCube(survey, language);
        File kmlTemplate = this.generateKMLTemplate(survey);
        File testPlotsCSVFile = new CollectEarthGridTemplateGenerator().generateTemplateCSVFile(survey);
        File readmeFile = this.getFileFromResouces(README_FILE_PATH);
        ZipFile zipFile = new ZipFile(outputFile);
        zipFile.add(projectProperties, PROJECT_PROPERTIES_FILE_NAME);
        zipFile.add(placemarkFile, "placemark.idm.xml");
        zipFile.add(balloon, BALLOON_FILE_NAME);
        zipFile.add(cube, CUBE_FILE_NAME);
        zipFile.add(kmlTemplate, KML_TEMPLATE_FILE_NAME);
        zipFile.add(readmeFile, README_FILE);
        zipFile.add(testPlotsCSVFile, TEST_PLOTS_FILE_NAME);
        this.addCodeListImages(zipFile, survey);
        this.includeSurveyFiles(zipFile, survey);
        this.includeEarthFiles(zipFile);
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File getFileFromResouces(String pathToResource) throws URISyntaxException {
        InputStream readmeContents = this.getClass().getClassLoader().getResourceAsStream(pathToResource);
        File tempFile = null;
        FileOutputStream fos = null;
        try {
            tempFile = File.createTempFile("readme", "txt");
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)readmeContents, (OutputStream)fos);
            readmeContents.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            this.logger.error("Error finding file " + pathToResource, (Throwable)e);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (IOException e2) {
            this.logger.error("Error copying file " + pathToResource, (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return tempFile;
    }

    private void includeEarthFiles(ZipFile zipFile) throws IOException, ZipFile.ZipException {
        Resource[] earthFileResources;
        for (Resource resource : earthFileResources = new PathMatchingResourcePatternResolver().getResources("org/openforis/collect/designer/templates/collectearth/earthFiles/**")) {
            if (!resource.exists() || !resource.isReadable() || !StringUtils.isNotBlank((CharSequence)resource.getFilename())) continue;
            String path = ((ClassPathResource)resource).getPath();
            String relativePath = StringUtils.removeStart((String)path, (String)EARTH_FILES_RESOURCE_PATH);
            zipFile.add(resource.getInputStream(), "earthFiles/" + relativePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPlacemark(CollectSurvey survey) throws IOException {
        File file = File.createTempFile("collect-earth-placemark.idm", ".xml");
        FileOutputStream os = new FileOutputStream(file);
        CollectSurveyIdmlBinder binder = new CollectSurveyIdmlBinder(survey.getContext());
        try {
            binder.marshal((Survey)survey, (OutputStream)os, true, true, false);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
        return file;
    }

    private File generateProjectProperties(CollectSurvey survey, String language) throws IOException {
        File file = File.createTempFile("collect-earth-project", ".properties");
        try (FileWriter writer = new FileWriter(file);){
            Properties p = new Properties();
            p.put("survey_name", survey.getName());
            p.put("balloon", "${project_path}/balloon.html");
            p.put("metadata_file", "${project_path}/placemark.idm.xml");
            p.put("template", "${project_path}/kml_template.fmt");
            p.put("csv", "${project_path}/" + this.determineSelectedGridFileName(survey));
            p.put("sample_shape", "SQUARE");
            p.put("distance_between_sample_points", String.valueOf(this.calculateDistanceBetweenSamplePoints(survey)));
            p.put("distance_to_plot_boundaries", String.valueOf(this.calculateFrameDistance(survey)));
            p.put("number_of_sampling_points_in_plot", String.valueOf(survey.getAnnotations().getCollectEarthSamplePoints()));
            p.put("inner_point_side", "2");
            p.put("ui_language", language);
            p.put("bing_maps_key", this.getBingMapsKey(survey));
            p.put("open_bing_maps", this.isBingMapsEnabled(survey));
            p.put("open_earth_map", this.isEarthMapEnabled(survey));
            p.put("open_planet_maps", this.isPlanetMapsEnabled(survey));
            p.put("open_yandex_maps", this.isYandexMapsEnabled(survey));
            p.put("open_earth_engine", this.isGEEExplorerEnabled(survey));
            p.put("open_gee_app", this.isGEEAppEnabled(survey));
            p.put("open_maxar_securewatch", this.isSecureWatchEnabled(survey));
            p.put("open_gee_playground", this.isGEECodeEditorEnabled(survey));
            p.put("open_street_view", this.isStreetViewEnabled(survey));
            p.put("extra_map_url", StringUtils.trimToEmpty((String)this.getExtraMapUrl(survey)));
            p.put("coordinates_reference_system", this.getSRSUsed(survey));
            p.store(writer, null);
            File file2 = file;
            return file2;
        }
    }

    private String determineSelectedGridFileName(CollectSurvey survey) {
        List surveyFiles = this.surveyManager.loadSurveyFileSummaries(survey);
        for (SurveyFile surveyFile : surveyFiles) {
            if (surveyFile.getType() != SurveyFile.SurveyFileType.COLLECT_EARTH_GRID) continue;
            return "grid/" + surveyFile.getFilename();
        }
        return TEST_PLOTS_FILE_NAME;
    }

    private String getSRSUsed(CollectSurvey survey) {
        List spatialReferenceSystems = survey.getSpatialReferenceSystems();
        if (spatialReferenceSystems == null || spatialReferenceSystems.size() != 1) {
            throw new IllegalArgumentException("Yoy must use one single Spatial Reference System in your survey");
        }
        return ((SpatialReferenceSystem)spatialReferenceSystems.get(0)).getId();
    }

    private String getBingMapsKey(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.getBingMapsKey();
    }

    private String getExtraMapUrl(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.getExtraMapUrl();
    }

    private String isBingMapsEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isBingMapsEnabled() ? "true" : "false";
    }

    private String isEarthMapEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isEarthMapEnabled() ? "true" : "false";
    }

    private String isPlanetMapsEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isPlanetMapsEnabled() ? "true" : "false";
    }

    private String isYandexMapsEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isYandexMapsEnabled() ? "true" : "false";
    }

    private String isGEEExplorerEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isGEEExplorerEnabled() ? "true" : "false";
    }

    private String isGEECodeEditorEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isGEECodeEditorEnabled() ? "true" : "false";
    }

    private String isGEEAppEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isGEEAppEnabled() ? "true" : "false";
    }

    private String isSecureWatchEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isSecureWatchEnabled() ? "true" : "false";
    }

    private String isStreetViewEnabled(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        return annotations.isStreetViewEnabled() ? "true" : "false";
    }

    private int calculateFrameDistance(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        double plotWidth = Math.sqrt(annotations.getCollectEarthPlotArea() * 10000.0);
        int samplePoints = annotations.getCollectEarthSamplePoints();
        if (samplePoints == 0) {
            return Double.valueOf(Math.floor(plotWidth / 2.0)).intValue();
        }
        double pointsPerSide = Math.sqrt(samplePoints);
        int frameDistance = Double.valueOf(Math.floor(plotWidth / pointsPerSide / 2.0)).intValue();
        return frameDistance;
    }

    private int calculateDistanceBetweenSamplePoints(CollectSurvey survey) {
        CollectAnnotations annotations = survey.getAnnotations();
        double plotWidth = Math.sqrt(annotations.getCollectEarthPlotArea() * 10000.0);
        int samplePoints = annotations.getCollectEarthSamplePoints();
        if (samplePoints <= 1) {
            return 0;
        }
        double pointsPerWidth = Math.sqrt(samplePoints);
        int frameDistance = this.calculateFrameDistance(survey);
        int distanceInMeters = Double.valueOf(Math.floor((plotWidth - (double)(frameDistance * 2)) / (pointsPerWidth - 1.0))).intValue();
        return distanceInMeters;
    }

    private File generateBalloon(CollectSurvey survey, String language) throws IOException {
        CollectEarthBalloonGenerator generator = new CollectEarthBalloonGenerator(survey, language);
        String html = generator.generateHTML();
        return Files.writeToTempFile((String)html, (String)"collect-earth-project-file-creator", (String)".html");
    }

    private File generateKMLTemplate(CollectSurvey survey) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(KML_TEMPLATE_PATH);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        String templateContent = writer.toString();
        List fromCsvAttributes = survey.getExtendedDataFields();
        String nameOfField = "extraColumns";
        StringBuffer extraHolders = this.addExtraDataHolders(fromCsvAttributes, nameOfField);
        nameOfField = "idColumns";
        List keyAttributeDefinitions = survey.getSchema().getFirstRootEntityDefinition().getKeyAttributeDefinitions();
        extraHolders.append(this.addExtraDataHolders(keyAttributeDefinitions, nameOfField));
        String content = templateContent.replace("PLACEHOLDER_FOR_EXTRA_CSV_DATA", extraHolders.toString());
        return Files.writeToTempFile((String)content, (String)"collect-earth-project-file-creator", (String)".xml");
    }

    private StringBuffer addExtraDataHolders(List<AttributeDefinition> fromCsvAttributes, String nameOfField) {
        int extraInfoIndex = 0;
        StringBuffer sb = new StringBuffer();
        for (AttributeDefinition attrDef : fromCsvAttributes) {
            String attrName = attrDef.getName();
            sb.append("<Data name=\"EXTRA_" + attrName + "\">\n");
            String value = "${placemark." + nameOfField + "[" + extraInfoIndex + "]}";
            ++extraInfoIndex;
            sb.append("<value>");
            sb.append(value);
            sb.append("</value>\n");
            sb.append("</Data>\n");
        }
        return sb;
    }

    private File generateCube(CollectSurvey survey, String language) throws IOException {
        MondrianCubeGenerator cubeGenerator = new MondrianCubeGenerator(survey, language);
        String xmlSchema = cubeGenerator.generateXMLSchema();
        xmlSchema = xmlSchema.replaceAll("REPLACE_START_UNICODE", "&");
        return Files.writeToTempFile((String)xmlSchema, (String)"collect-earth-project-file-creator", (String)".xml");
    }

    private void addCodeListImages(final ZipFile zipFile, CollectSurvey survey) {
        List codeLists = survey.getCodeLists();
        for (CodeList codeList : codeLists) {
            if (codeList.isExternal()) continue;
            this.codeListManager.visitItems(codeList, (Visitor)new Visitor<CodeListItem>(){

                public void visit(CodeListItem item) {
                    if (item.hasUploadedImage()) {
                        FileWrapper imageFileWrapper = CollectEarthProjectFileCreatorImpl.this.codeListManager.loadImageContent((PersistedCodeListItem)item);
                        byte[] content = imageFileWrapper.getContent();
                        try {
                            File imageFile = CollectEarthProjectFileCreatorImpl.this.copyToTempFile(content, item.getImageFileName());
                            String zipImageFileName = CollectEarthProjectFileCreatorImpl.getCodeListImageFilePath(item);
                            zipFile.add(imageFile, zipImageFileName);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
    }

    public static String getCodeListImageFilePath(CodeListItem item) {
        CodeList codeList = item.getCodeList();
        String zipImageFileName = StringUtils.join(Arrays.asList(EARTH_FILES_FOLDER_NAME, "img", "code_list", codeList.getId(), item.getId(), item.getImageFileName()), (String)"/");
        return zipImageFileName;
    }

    private void includeSurveyFiles(ZipFile zipFile, CollectSurvey survey) throws FileNotFoundException, IOException, ZipFile.ZipException {
        List surveyFiles = this.surveyManager.loadSurveyFileSummaries(survey);
        for (SurveyFile surveyFile : surveyFiles) {
            String namePrefix;
            byte[] content = this.surveyManager.loadSurveyFileContent(surveyFile);
            File tempSurveyFile = this.copyToTempFile(content, surveyFile.getFilename());
            switch (surveyFile.getType()) {
                case COLLECT_EARTH_GRID: {
                    namePrefix = "grid/";
                    break;
                }
                default: {
                    namePrefix = "";
                }
            }
            zipFile.add(tempSurveyFile, namePrefix + surveyFile.getFilename());
        }
    }

    private File copyToTempFile(byte[] content, String fileName) throws IOException, FileNotFoundException {
        File imageFile = File.createTempFile("collect-earth-project-file-creator", fileName);
        try (FileOutputStream fos = new FileOutputStream(imageFile);){
            fos.write(content);
            File file = imageFile;
            return file;
        }
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setSurveyManager(SurveyManager surveyManager) {
        this.surveyManager = surveyManager;
    }
}

