/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openforis.collect.earth.core.rdb.RelationalSchemaContext;
import org.openforis.collect.io.metadata.collectearth.balloon.HtmlUnicodeEscaperUtil;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.CodeValueFKColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.RelationalSchemaConfig;
import org.openforis.collect.relational.model.RelationalSchemaGenerator;
import org.openforis.collect.relational.util.CodeListTables;
import org.openforis.collect.relational.util.DataTables;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListLevel;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.KeyAttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Survey;

public class MondrianCubeGenerator {
    private static final String SAIKU_SCHEMA_PLACEHOLDER = "${saikuDbSchema}";
    private static final String[] MEASURE_AGGREGATORS = new String[]{"min", "max", "avg"};
    private static final String BOOLEAN_DATATYPE = "Boolean";
    private static final String INTEGER_DATATYPE = "Integer";
    private static final String NUMERIC_DATATYPE = "Numeric";
    private static final String STRING_DATATYPE = "String";
    private CollectSurvey survey;
    private RelationalSchemaConfig rdbConfig;
    private String language;
    private RelationalSchema rdbSchema;

    public MondrianCubeGenerator(CollectSurvey survey, String language) {
        this.survey = survey;
        this.language = language;
        this.rdbConfig = new RelationalSchemaContext().getRdbConfig();
    }

    public Schema generateSchema() {
        this.rdbSchema = new RelationalSchemaGenerator(this.rdbConfig).generateSchema((Survey)this.survey, this.survey.getName());
        Cube cube = this.generateCube();
        Schema schema = new Schema(this.survey.getName());
        schema.cube = cube;
        return schema;
    }

    public String generateXMLSchema() {
        Schema mondrianSchema = this.generateSchema();
        XStream xStream = new XStream();
        xStream.processAnnotations(Schema.class);
        String xmlSchema = xStream.toXML((Object)mondrianSchema);
        return xmlSchema;
    }

    private Cube generateCube() {
        Cube cube = new Cube("Collect Earth Plot");
        EntityDefinition rootEntityDef = this.survey.getSchema().getFirstRootEntityDefinition();
        Table table = new Table(rootEntityDef.getName());
        cube.table = table;
        List children = rootEntityDef.getChildDefinitions();
        for (NodeDefinition nodeDef : children) {
            if (!this.survey.getAnnotations().isIncludedInDataExport(nodeDef)) continue;
            String nodeName = nodeDef.getName();
            if (nodeDef instanceof AttributeDefinition) {
                Dimension dimension = this.generateDimension(nodeDef, rootEntityDef);
                if (nodeDef instanceof KeyAttributeDefinition && ((KeyAttributeDefinition)nodeDef).isKey()) {
                    Measure measure = new Measure(rootEntityDef.getName() + "_count");
                    measure.column = "_" + rootEntityDef.getName() + "_" + nodeName;
                    measure.caption = StringEscapeUtils.escapeHtml4((String)(this.extractFailsafeLabel((NodeDefinition)rootEntityDef) + " Count"));
                    measure.aggregator = "distinct count";
                    measure.datatype = INTEGER_DATATYPE;
                    cube.measures.add(measure);
                } else if (nodeDef instanceof NumberAttributeDefinition) {
                    for (String aggregator : MEASURE_AGGREGATORS) {
                        Measure measure = new Measure(nodeName + "_" + aggregator);
                        measure.column = nodeName;
                        measure.caption = StringEscapeUtils.escapeHtml4((String)(this.extractFailsafeLabel(nodeDef) + " " + aggregator));
                        measure.aggregator = aggregator;
                        measure.datatype = NUMERIC_DATATYPE;
                        measure.formatString = "#.##";
                        cube.measures.add(measure);
                    }
                }
                cube.dimensions.add(dimension);
                continue;
            }
            EntityDefinition entityDef = (EntityDefinition)nodeDef;
            String string = nodeName;
            String entityLabel = this.extractFailsafeLabel((NodeDefinition)entityDef);
            String rootEntityIdColumnName = this.getRootEntityIdColumnName(rootEntityDef);
            for (NodeDefinition childDef : entityDef.getChildDefinitions()) {
                String childLabel = this.extractReportingLabel(childDef);
                if (childLabel == null && !(childLabel = this.extractFailsafeLabel(childDef)).startsWith(entityLabel)) {
                    childLabel = entityLabel + " " + childLabel;
                }
                Dimension dimension = new Dimension(childLabel);
                Hierarchy hierarchy = new Hierarchy(childLabel);
                if (entityDef.isMultiple()) {
                    dimension.foreignKey = rootEntityIdColumnName;
                    hierarchy.primaryKey = rootEntityIdColumnName;
                    hierarchy.primaryKeyTable = string;
                    if (childDef instanceof CodeAttributeDefinition && !childDef.isMultiple()) {
                        CodeAttributeDefinition codeAttr = (CodeAttributeDefinition)childDef;
                        DataTable dataTable = this.rdbSchema.getDataTable((NodeDefinition)entityDef);
                        CodeValueFKColumn foreignKeyCodeColumn = dataTable.getForeignKeyCodeColumn(codeAttr);
                        if (foreignKeyCodeColumn != null) {
                            Join join = new Join(null);
                            join.leftKey = foreignKeyCodeColumn.getName();
                            CodeTable codeListTable = this.rdbSchema.getCodeListTable(codeAttr);
                            join.rightKey = CodeListTables.getIdColumnName((RelationalSchemaConfig)this.rdbConfig, (String)codeListTable.getName());
                            join.tables = Arrays.asList(new Table(string), new Table(codeListTable.getName()));
                            hierarchy.join = join;
                        }
                    } else {
                        hierarchy.table = new Table(string);
                    }
                    hierarchy.levels.addAll(this.generateLevel(childDef));
                    dimension.hierarchy = hierarchy;
                } else {
                    dimension = this.generateDimension(childDef, rootEntityDef);
                }
                cube.dimensions.add(dimension);
            }
        }
        cube.measures.addAll(1, this.generatePredefinedMeasures());
        return cube;
    }

    public String getRootEntityIdColumnName(EntityDefinition rootEntityDef) {
        return this.rdbConfig.getIdColumnPrefix() + rootEntityDef.getName() + this.rdbConfig.getIdColumnSuffix();
    }

    private List<Measure> generatePredefinedMeasures() {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        Measure measure = new Measure("area");
        measure.column = "expansion_factor";
        measure.caption = "Area (HA)";
        measure.aggregator = "sum";
        measure.datatype = NUMERIC_DATATYPE;
        measure.formatString = "###,###.00";
        measures.add(measure);
        measure = new Measure("plot_weight");
        measure.column = "plot_weight";
        measure.caption = "Plot Weight";
        measure.aggregator = "sum";
        measure.datatype = NUMERIC_DATATYPE;
        measure.formatString = "#,###.##";
        measures.add(measure);
        return measures;
    }

    private Dimension generateDimension(NodeDefinition nodeDef, EntityDefinition rootEntityDef) {
        String attrLabel = this.extractFailsafeLabel(nodeDef);
        Dimension dimension = new Dimension(attrLabel);
        Hierarchy hierarchy = dimension.hierarchy;
        if (nodeDef instanceof CodeAttributeDefinition) {
            CodeAttributeDefinition codeDef = (CodeAttributeDefinition)nodeDef;
            String[] dataTable = nodeDef.isMultiple() ? this.rdbSchema.getDataTable(nodeDef) : this.rdbSchema.getDataTable(nodeDef.getParentDefinition());
            CodeTable codeListTable = this.rdbSchema.getCodeListTable(codeDef);
            String codeListTableName = codeListTable.getName();
            String codeFKColumnName = DataTables.getCodeFKColumnName((RelationalSchemaConfig)this.rdbConfig, (DataTable)dataTable, (CodeAttributeDefinition)codeDef);
            String rootEntityIdColumnName = this.getRootEntityIdColumnName(rootEntityDef);
            if (nodeDef.isMultiple()) {
                dimension.foreignKey = rootEntityIdColumnName;
                hierarchy.primaryKey = rootEntityIdColumnName;
                hierarchy.primaryKeyTable = dataTable.getName();
                Join join = new Join(null);
                join.leftKey = codeFKColumnName;
                join.rightKey = CodeListTables.getIdColumnName((RelationalSchemaConfig)this.rdbConfig, (String)codeListTableName);
                join.tables = Arrays.asList(new Table(dataTable.getName()), new Table(codeListTableName));
                hierarchy.join = join;
            } else {
                dimension.foreignKey = codeFKColumnName;
                hierarchy.table = new Table(codeListTableName);
            }
        }
        if (nodeDef instanceof DateAttributeDefinition) {
            String[] levelNames;
            dimension.type = "";
            hierarchy.type = "TimeDimension";
            hierarchy.allMemberName = "attrLabel";
            for (String levelName : levelNames = new String[]{"Year", "Month", "Day"}) {
                Level level = new Level(attrLabel + " - " + levelName);
                level.column = nodeDef.getName() + "_" + levelName.toLowerCase(Locale.ENGLISH);
                level.levelType = String.format("Time%ss", levelName);
                level.type = NUMERIC_DATATYPE;
                level.uniqueMembers = "false";
                hierarchy.levels.add(level);
            }
        } else if (nodeDef instanceof CoordinateAttributeDefinition) {
            dimension.type = "";
            hierarchy.type = "StandardDimension";
            Level level = new Level(attrLabel + " - Latitude");
            level.column = nodeDef.getName() + "_y";
            hierarchy.levels.add(level);
            Level level2 = new Level(attrLabel + " - Longitude");
            level2.column = nodeDef.getName() + "_x";
            hierarchy.levels.add(level2);
        } else {
            List<Level> levels = this.generateLevel(nodeDef);
            hierarchy.levels.addAll(levels);
        }
        return dimension;
    }

    private String extractCodeListName(CodeAttributeDefinition codeAttrDef) {
        CodeList codeList;
        List codeHierarchy;
        StringBuffer codeListName = new StringBuffer(codeAttrDef.getList().getName());
        int levelIdx = codeAttrDef.getLevelIndex();
        if (levelIdx != -1 && !(codeHierarchy = (codeList = codeAttrDef.getList()).getHierarchy()).isEmpty()) {
            CodeListLevel currentLevel = (CodeListLevel)codeHierarchy.get(levelIdx);
            codeListName.append("_");
            codeListName.append(currentLevel.getName());
        }
        return codeListName.toString();
    }

    private String extractCodeListTableName(CodeAttributeDefinition codeAttrDef) {
        return this.extractCodeListName(codeAttrDef) + this.rdbConfig.getCodeListTableSuffix();
    }

    private List<Level> generateLevel(NodeDefinition nodeDef) {
        ArrayList<Level> levels = new ArrayList<Level>();
        String attrLabel = this.extractFailsafeLabel(nodeDef);
        Level level = new Level(attrLabel);
        levels.add(level);
        if (nodeDef instanceof NumericAttributeDefinition) {
            level.type = ((NumericAttributeDefinition)nodeDef).getType() == NumericAttributeDefinition.Type.INTEGER ? INTEGER_DATATYPE : NUMERIC_DATATYPE;
        } else if (nodeDef instanceof CodeAttributeDefinition) {
            level.type = ((CodeAttributeDefinition)nodeDef).getList().isExternal() ? STRING_DATATYPE : INTEGER_DATATYPE;
        } else {
            level.type = STRING_DATATYPE;
        }
        level.levelType = "Regular";
        if (nodeDef instanceof CodeAttributeDefinition) {
            CodeAttributeDefinition codeDef = (CodeAttributeDefinition)nodeDef;
            String codeTableName = this.extractCodeListTableName(codeDef);
            level.table = codeTableName;
            level.column = codeTableName + this.rdbConfig.getIdColumnSuffix();
            level.nameColumn = codeTableName.substring(0, codeTableName.length() - this.rdbConfig.getCodeListTableSuffix().length()) + "_label_" + this.language;
            Level levelId = new Level(attrLabel + " -  ID");
            levelId.type = STRING_DATATYPE;
            levelId.table = codeTableName;
            levelId.column = codeTableName + this.rdbConfig.getIdColumnSuffix();
            levelId.nameColumn = this.extractCodeListName(codeDef);
            levels.add(levelId);
        } else {
            level.column = nodeDef.getName();
        }
        return levels;
    }

    private String extractFailsafeLabel(NodeDefinition nodeDef) {
        String label = this.extractReportingLabel(nodeDef);
        if (label == null && (label = nodeDef.getLabel(NodeLabel.Type.INSTANCE, this.language)) == null) {
            label = nodeDef.getName();
        }
        return HtmlUnicodeEscaperUtil.escapeMondrianUnicode(label);
    }

    private String extractReportingLabel(NodeDefinition nodeDef) {
        return nodeDef.getLabel(NodeLabel.Type.REPORTING, this.language);
    }

    @XStreamAlias(value="Join")
    private static class Join
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private String leftKey;
        @XStreamAsAttribute
        private String rightKey;
        @XStreamImplicit
        private List<Table> tables;

        public Join(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Measure")
    private static class Measure
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private String column;
        @XStreamAsAttribute
        private String datatype;
        @XStreamAsAttribute
        private String aggregator;
        @XStreamAsAttribute
        private String caption;
        @XStreamAsAttribute
        private String formatString;

        public Measure(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Level")
    private static class Level
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private String table;
        @XStreamAsAttribute
        private String column;
        @XStreamAsAttribute
        private String nameColumn;
        @XStreamAsAttribute
        private String uniqueMembers = "false";
        @XStreamAsAttribute
        private String levelType;
        @XStreamAsAttribute
        private String type;
        @XStreamAsAttribute
        public String hideMemberIf;

        public Level(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Hierarchy")
    private static class Hierarchy
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        public String type;
        @XStreamAsAttribute
        public String allMemberName;
        @XStreamAsAttribute
        private String primaryKey;
        @XStreamAsAttribute
        private String primaryKeyTable;
        @XStreamAlias(value="Table")
        private Table table;
        @XStreamAlias(value="Join")
        private Join join;
        @XStreamAsAttribute
        private String visible = "true";
        @XStreamAsAttribute
        private String hasAll = "true";
        @XStreamImplicit
        private List<Level> levels = new ArrayList<Level>();

        public Hierarchy(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Dimension")
    private static class Dimension
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private String foreignKey;
        @XStreamAsAttribute
        public String type = "StandardDimension";
        @XStreamAsAttribute
        public String visible = "true";
        @XStreamAsAttribute
        public String highCardinality;
        @XStreamAlias(value="Hierarchy")
        private Hierarchy hierarchy = new Hierarchy(null);

        public Dimension(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Table")
    private static class Table
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private final String schema = "${saikuDbSchema}";

        public Table(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Cube")
    private static class Cube
    extends MondrianSchemaObject {
        @XStreamAsAttribute
        private String cache = "true";
        @XStreamAsAttribute
        private String enabled = "true";
        @XStreamAlias(value="Table")
        private Table table;
        @XStreamImplicit
        private List<Dimension> dimensions = new ArrayList<Dimension>();
        @XStreamImplicit
        private List<Measure> measures = new ArrayList<Measure>();

        public Cube(String name) {
            super(name);
        }
    }

    @XStreamAlias(value="Schema")
    private static class Schema
    extends MondrianSchemaObject {
        @XStreamAlias(value="Cube")
        private Cube cube;

        public Schema(String name) {
            super(name);
        }
    }

    private static class MondrianSchemaObject {
        @XStreamAsAttribute
        private String name;

        public MondrianSchemaObject(String name) {
            this.name = StringEscapeUtils.escapeHtml4((String)name);
        }
    }
}

