/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openforis.collect.manager.RandomValuesGenerator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveyFile;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.commons.io.flat.FlatRecord;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RandomGridGenerationJob
extends Job {
    private SurveyManager surveyManager;
    private CollectSurvey survey;
    private File file;
    private double percentage;
    private String surveyFileName;
    private String newMeasurement;

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new RandomGridGenerationTask());
    }

    protected void validateInput() throws Throwable {
        super.validateInput();
        AttributeDefinition measurementKeyDef = this.survey.getFirstMeasurementKeyDef();
        if (measurementKeyDef == null) {
            throw new Exception("Expected at least one measurement attribute");
        }
    }

    protected void afterExecute() {
        super.afterExecute();
        if (this.isCompleted()) {
            File outputFile = ((RandomGridGenerationTask)((Object)this.getTasks().get(0))).outputFile;
            SurveyFile surveyFile = new SurveyFile(this.survey);
            surveyFile.setType(SurveyFile.SurveyFileType.COLLECT_EARTH_GRID);
            surveyFile.setFilename(this.surveyFileName);
            this.surveyManager.addSurveyFile(surveyFile, outputFile);
            outputFile.delete();
        }
    }

    public void setSurveyManager(SurveyManager surveyManager) {
        this.surveyManager = surveyManager;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public void setSurveyFileName(String surveyFileName) {
        this.surveyFileName = surveyFileName;
    }

    public void setNewMeasurement(String newMeasurement) {
        this.newMeasurement = newMeasurement;
    }

    private class RandomGridGenerationTask
    extends Task {
        private static final String ID_COLUMN = "id";
        private File outputFile;

        private RandomGridGenerationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() throws Throwable {
            Set<String> randomPlotIds = this.generateRandomPlotIds();
            int totalRandomPlotIds = randomPlotIds.size();
            if (totalRandomPlotIds == 0) {
                throw new Error("Random grid cannot be generated: no records found (check the percentage value)");
            }
            this.setTotalItems(totalRandomPlotIds);
            this.outputFile = File.createTempFile("random_grid", ".csv");
            FileOutputStream outputStream = null;
            CsvWriter csvWriter = null;
            CsvReader csvReader = null;
            try {
                outputStream = new FileOutputStream(this.outputFile);
                csvWriter = new CsvWriter((OutputStream)outputStream);
                csvReader = new CsvReader(RandomGridGenerationJob.this.file);
                csvReader.readHeaders();
                List headers = csvReader.getColumnNames();
                csvWriter.writeHeaders(headers);
                AttributeDefinition measurementKeyDef = RandomGridGenerationJob.this.survey.getFirstMeasurementKeyDef();
                String measurementAttributeName = measurementKeyDef.getName();
                int measurementColumnIndex = headers.indexOf(measurementAttributeName);
                FlatRecord csvRecord = csvReader.nextRecord();
                while (csvRecord != null && this.isRunning()) {
                    String plotId = (String)csvRecord.getValue(ID_COLUMN, String.class);
                    if (randomPlotIds.contains(plotId)) {
                        Object[] values = csvRecord.toArray();
                        Object[] valuesUpdated = ArrayUtils.clone((Object[])values);
                        valuesUpdated[measurementColumnIndex] = RandomGridGenerationJob.this.newMeasurement;
                        csvWriter.writeNext(valuesUpdated);
                        this.incrementProcessedItems();
                    }
                    csvRecord = csvReader.nextRecord();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                IOUtils.closeQuietly(csvWriter);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)csvReader);
            IOUtils.closeQuietly((Closeable)csvWriter);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }

        private Set<String> generateRandomPlotIds() throws FileNotFoundException, IOException {
            ArrayList<String> plotIds = new ArrayList<String>();
            try (CsvReader csvReader = new CsvReader(RandomGridGenerationJob.this.file);){
                csvReader.readHeaders();
                CsvLine csvLine = csvReader.readNextLine();
                while (csvLine != null) {
                    String plotId = (String)csvLine.getValue(ID_COLUMN, String.class);
                    plotIds.add(plotId);
                    csvLine = csvReader.readNextLine();
                }
            }
            List randomPlotIds = RandomValuesGenerator.generateRandomSubset(plotIds, RandomGridGenerationJob.this.percentage);
            return new HashSet<String>(randomPlotIds);
        }
    }
}

