/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openforis.collect.manager.RandomValuesGenerator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.commons.collection.Predicate;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.springframework.beans.factory.annotation.Autowired;

public class RandomRecordKeysGenerator {
    @Autowired
    private transient RecordManager recordManager;

    private static <T> List<T> transformList(List<T> list, Transformer<T> transformer) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : list) {
            T itemTransformed = transformer.transform(item);
            result.add(itemTransformed);
        }
        return result;
    }

    public List<List<String>> generate(CollectSurvey survey, final String currentMeasurementValue, final String nextMeasurementValue, float percentageOverTotal) {
        AttributeDefinition measurementKeyDef = survey.getFirstMeasurementKeyDef();
        if (measurementKeyDef == null) {
            return Collections.emptyList();
        }
        List keyDefs = survey.getSchema().getFirstRootEntityDefinition().getKeyAttributeDefinitions();
        final int measurementKeyDefIndex = keyDefs.indexOf(measurementKeyDef);
        List recordSummaries = this.recordManager.loadSummaries(new RecordFilter(survey));
        CollectionUtils.filter((Collection)recordSummaries, (Predicate)new Predicate<CollectRecordSummary>(){

            public boolean evaluate(CollectRecordSummary recordSummary) {
                List keyValues = recordSummary.getRootEntityKeyValues();
                String measurementKeyValue = keyValues.size() > measurementKeyDefIndex ? (String)keyValues.get(measurementKeyDefIndex) : null;
                return currentMeasurementValue.equals(measurementKeyValue);
            }
        });
        ArrayList<List> recordsKeys = new ArrayList<List>();
        for (CollectRecordSummary recordSummary : recordSummaries) {
            recordsKeys.add(recordSummary.getRootEntityKeyValues());
        }
        List randomRecordsKeys = RandomValuesGenerator.generateRandomSubset(recordsKeys, percentageOverTotal);
        List<List<String>> transformedRandomRecordsKeys = RandomRecordKeysGenerator.transformList(randomRecordsKeys, new Transformer<List<String>>(){

            @Override
            public List<String> transform(List<String> keyValues) {
                ArrayList<String> newKeyValues = new ArrayList<String>(keyValues);
                newKeyValues.set(measurementKeyDefIndex, nextMeasurementValue);
                return newKeyValues;
            }
        });
        return transformedRandomRecordsKeys;
    }

    private static interface Transformer<T> {
        public T transform(T var1);
    }
}

