/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.TreeNode;

public abstract class BasicTreeModel<T extends SimpleNodeData>
extends DefaultTreeModel<T> {
    private static final long serialVersionUID = 1L;

    BasicTreeModel(AbstractNode<T> root) {
        super(root);
    }

    public void deselect() {
        List emptySelection = Collections.emptyList();
        this.setSelection(emptySelection);
    }

    public Collection<TreeNode<T>> getAllItems() {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        stack.push((TreeNode)this.getRoot());
        while (!stack.isEmpty()) {
            TreeNode treeNode = (TreeNode)stack.pop();
            result.add(treeNode);
            List children = treeNode.getChildren();
            if (children == null || children.isEmpty()) continue;
            stack.addAll(children);
        }
        return result;
    }

    public void openAllItems() {
        Collection<TreeNode<T>> allItems = this.getAllItems();
        this.setOpenObjects(allItems);
    }

    public void removeSelectedNode() {
        int[] selectionPath = this.getSelectionPath();
        if (selectionPath != null) {
            AbstractNode treeNode = (AbstractNode)((Object)this.getChild(selectionPath));
            AbstractNode parentTreeNode = (AbstractNode)treeNode.getParent();
            Set openObjects = this.getOpenObjects();
            parentTreeNode.remove((TreeNode)treeNode);
            this.setOpenObjects(openObjects);
        }
    }

    public void appendNodeToSelected(T data) {
        AbstractNode<T> parentNode = this.getSelectedNode();
        if (parentNode == null) {
            parentNode = (AbstractNode<T>)((Object)this.getRoot());
        } else if (parentNode.isLeaf()) {
            parentNode = this.recreateNode(parentNode);
        }
        AbstractNode<T> node = this.getNode(data);
        if (node == null) {
            node = this.createNode(data);
            parentNode.add((TreeNode)node);
        }
        this.addOpenObject(parentNode);
        this.setSelection(Arrays.asList(node));
    }

    protected AbstractNode<T> getSelectedNode() {
        int[] selectionPath = this.getSelectionPath();
        return selectionPath != null ? (AbstractNode)((Object)this.getChild(selectionPath)) : null;
    }

    protected AbstractNode<T> getParentNode(T item) {
        AbstractNode<T> node = this.getNode(item);
        AbstractNode parent = (AbstractNode)node.getParent();
        return parent;
    }

    protected int[] toArray(List<Integer> temp) {
        int[] result = new int[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            int value;
            result[i] = value = temp.get(i).intValue();
        }
        return result;
    }

    public void select(T data) {
        List<Object> selection;
        if (data == null) {
            selection = Collections.emptyList();
        } else {
            AbstractNode<T> treeNode = this.getNode(data);
            selection = Arrays.asList(treeNode);
        }
        this.setSelection(selection);
    }

    protected AbstractNode<T> getNode(T data) {
        if (data == null) {
            return null;
        }
        int[] path = this.getNodePath(data);
        if (path == null) {
            return null;
        }
        return (AbstractNode)((Object)this.getChild(path));
    }

    protected int[] getNodePath(T data) {
        TreeNode<T> treeNode = this.getTreeNode(data);
        if (treeNode == null) {
            return null;
        }
        int[] result = this.getPath(treeNode);
        return result;
    }

    protected TreeNode<T> getTreeNode(T data) {
        TreeNode root = (TreeNode)this.getRoot();
        Stack<TreeNode> treeNodesStack = new Stack<TreeNode>();
        treeNodesStack.push(root);
        while (!treeNodesStack.isEmpty()) {
            TreeNode treeNode = (TreeNode)treeNodesStack.pop();
            SimpleNodeData treeNodeData = (SimpleNodeData)treeNode.getData();
            if (treeNodeData != null && treeNodeData.equals(data)) {
                return treeNode;
            }
            List children = treeNode.getChildren();
            if (children == null || children.size() <= 0) continue;
            treeNodesStack.addAll(children);
        }
        return null;
    }

    protected AbstractNode<T> recreateNode(AbstractNode<T> node) {
        AbstractNode parent = (AbstractNode)node.getParent();
        SimpleNodeData data = (SimpleNodeData)node.getData();
        AbstractNode<SimpleNodeData> newNode = this.createNode(data, true);
        parent.replace(node, newNode);
        return newNode;
    }

    protected AbstractNode<T> createNode(T data) {
        return this.createNode(data, false);
    }

    protected abstract AbstractNode<T> createNode(T var1, boolean var2);

    public void moveSelectedNode(int toIndex) {
        int[] selectionPath = this.getSelectionPath();
        AbstractNode treeNode = (AbstractNode)((Object)this.getChild(selectionPath));
        AbstractNode parentTreeNode = (AbstractNode)treeNode.getParent();
        Set openObjects = this.getOpenObjects();
        parentTreeNode.insert((TreeNode)treeNode, toIndex);
        this.setOpenObjects(openObjects);
        List<AbstractNode> selection = Arrays.asList(treeNode);
        this.setSelection(selection);
    }

    public static abstract class AbstractNode<T>
    extends DefaultTreeNode<T> {
        private static final long serialVersionUID = 1L;

        AbstractNode(T data) {
            super(data);
        }

        AbstractNode(T data, Collection<? extends AbstractNode<T>> children) {
            super(data, children);
        }

        void replace(TreeNode<T> oldNode, TreeNode<T> newNode) {
            int index = this.getIndex(oldNode);
            this.remove(index);
            this.insert(newNode, index);
        }

        public String getIcon() {
            return null;
        }
    }

    public static abstract class SimpleNodeData {
        protected boolean detached;
        protected boolean root;
        protected String label;
        protected String icon;

        public SimpleNodeData(String label, boolean root, boolean detached) {
            this.detached = detached;
            this.root = root;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isDetached() {
            return this.detached;
        }

        public void setDetached(boolean detached) {
            this.detached = detached;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.detached ? 1231 : 1237);
            result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.root ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleNodeData other = (SimpleNodeData)obj;
            if (this.detached != other.detached) {
                return false;
            }
            if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return this.root == other.root;
        }
    }
}

