/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.openforis.collect.designer.component.BasicTreeModel;
import org.openforis.collect.designer.component.SurveyObjectTreeModelCreator;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.designer.viewmodel.SchemaVM;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveySummary;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.BindUtils;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.TreeNode;

public class SchemaTreeModel
extends BasicTreeModel<SchemaNodeData> {
    private static final long serialVersionUID = 1L;
    protected SurveyObjectTreeModelCreator modelCreator;
    protected EntityDefinition rootEntity;
    protected String labelLanguage;

    public SchemaTreeModel(SurveyObjectTreeModelCreator modelCreator, SchemaTreeNode root, EntityDefinition rootEntity, String labelLanguage) {
        super(root);
        this.modelCreator = modelCreator;
        this.rootEntity = rootEntity;
        this.labelLanguage = labelLanguage;
    }

    protected SchemaTreeNode createNode(SchemaNodeData data, boolean defineEmptyChildrenForLeaves) {
        return (SchemaTreeNode)this.modelCreator.createNode(data, defineEmptyChildrenForLeaves);
    }

    public int getChildCount(TreeNode<SchemaNodeData> parent) {
        int count = super.getChildCount(parent);
        SchemaNodeData data = (SchemaNodeData)parent.getData();
        if (data != null && data.getSurveyObject() == null) {
            return 1;
        }
        return count;
    }

    public boolean isLeaf(TreeNode<SchemaNodeData> node) {
        if (node.getData() != null && ((SchemaNodeData)node.getData()).getSurveyObject() == null) {
            return false;
        }
        return super.isLeaf(node);
    }

    public TreeNode<SchemaNodeData> getChild(TreeNode<SchemaNodeData> parent, int index) {
        SchemaNodeData data = (SchemaNodeData)parent.getData();
        if (data != null && data.getSurveyObject() == null && parent.getChildCount() == 0) {
            BasicTreeModel.AbstractNode<SchemaNodeData> rootEntityNode = this.modelCreator.createSurveyRootEntityNode(data.getSurvey().getId());
            parent.add(rootEntityNode);
        }
        return super.getChild(parent, index);
    }

    public SchemaNodeData getNodeData(SurveyObject surveyObject) {
        int[] path = this.getNodePath(surveyObject);
        return this.getNodeData(path);
    }

    public EntityDefinition getNearestParentEntityDefinition(SurveyObject surveyObject) {
        SchemaTreeNode treeNode = this.getTreeNode(surveyObject);
        for (TreeNode parentNode = treeNode.getParent(); parentNode != null && parentNode.getData() != null; parentNode = parentNode.getParent()) {
            SchemaNodeData data = (SchemaNodeData)parentNode.getData();
            SurveyObject currentSurveyObject = data.getSurveyObject();
            if (!(currentSurveyObject instanceof EntityDefinition)) continue;
            return (EntityDefinition)currentSurveyObject;
        }
        return this.rootEntity;
    }

    private SchemaNodeData getNodeData(int[] path) {
        if (path == null) {
            return null;
        }
        SchemaTreeNode node = (SchemaTreeNode)((Object)this.getChild(path));
        SchemaNodeData data = (SchemaNodeData)node.getData();
        return data;
    }

    @Override
    protected int[] getNodePath(SurveyObject surveyObject) {
        SchemaTreeNode treeNode = this.getTreeNode(surveyObject);
        if (treeNode == null) {
            return null;
        }
        int[] result = super.getPath((TreeNode)treeNode);
        return result;
    }

    public SchemaTreeNode getTreeNode(SurveyObject surveyObject) {
        SchemaTreeNode root = (SchemaTreeNode)((Object)this.getRoot());
        Stack<SchemaTreeNode> stack = new Stack<SchemaTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            TreeNode treeNode = (TreeNode)stack.pop();
            SchemaNodeData treeNodeData = (SchemaNodeData)treeNode.getData();
            if (treeNodeData != null && treeNodeData.getSurveyObject() == surveyObject) {
                return (SchemaTreeNode)treeNode;
            }
            List children = treeNode.getChildren();
            if (children == null || children.size() <= 0) continue;
            for (TreeNode child : children) {
                stack.push((SchemaTreeNode)child);
            }
        }
        return null;
    }

    public SchemaNodeData select(SurveyObject surveyObject) {
        SchemaNodeData data = this.getNodeData(surveyObject);
        super.select(data);
        return data;
    }

    public void showSelectedNode() {
        BasicTreeModel.AbstractNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            for (TreeNode parent = selectedNode.getParent(); parent != null; parent = parent.getParent()) {
                this.addOpenObject(parent);
            }
        }
    }

    public void updateNodeLabel(SurveyObject surveyObject, String label) {
        SchemaNodeData data = this.getNodeData(surveyObject);
        data.setLabel(label);
        BindUtils.postNotifyChange(null, null, (Object)data, (String)"label");
    }

    @Override
    public void appendNodeToSelected(SurveyObject surveyObject) {
        this.appendNodeToSelected(surveyObject, false);
    }

    public void appendNodeToSelected(SurveyObject surveyObject, boolean detached) {
        BasicTreeModel.AbstractNode selectedNode = this.getSelectedNode();
        boolean root = selectedNode == null;
        SchemaNodeData data = new SchemaNodeData(surveyObject, root, detached, this.labelLanguage);
        super.appendNodeToSelected(data);
    }

    public void setSelectedNodeLabel(String label) {
        BasicTreeModel.AbstractNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            SchemaNodeData data = (SchemaNodeData)selectedNode.getData();
            data.setLabel(label);
            BindUtils.postNotifyChange(null, null, (Object)data, (String)"label");
        }
    }

    public void markSelectedNodeAsDetached() {
        BasicTreeModel.AbstractNode selectedNode = this.getSelectedNode();
        SchemaNodeData data = (SchemaNodeData)selectedNode.getData();
        data.setDetached(true);
    }

    public List<SurveyObject> getSiblingsAndSelf(SurveyObject obj, boolean sameType) {
        ArrayList<SurveyObject> result = new ArrayList<SurveyObject>();
        SchemaTreeNode treeNode = this.getTreeNode(obj);
        TreeNode parent = treeNode.getParent();
        List children = parent.getChildren();
        for (TreeNode child : children) {
            SurveyObject surveyObject = ((SchemaNodeData)child.getData()).getSurveyObject();
            if (!sameType || (!(obj instanceof UITab) || !(surveyObject instanceof UITab)) && (!(obj instanceof NodeDefinition) || !(surveyObject instanceof NodeDefinition))) continue;
            result.add(surveyObject);
        }
        return result;
    }

    public Set<SurveyObject> getOpenSchemaNodes() {
        HashSet<SurveyObject> result = new HashSet<SurveyObject>();
        Set openObjects = this.getOpenObjects();
        for (TreeNode treeNode : openObjects) {
            if (treeNode == null) continue;
            SchemaNodeData data = (SchemaNodeData)treeNode.getData();
            SurveyObject node = data.getSurveyObject();
            result.add(node);
        }
        return result;
    }

    public void setOpenSchemaNodes(Collection<SurveyObject> nodes) {
        HashSet<SchemaTreeNode> opened = new HashSet<SchemaTreeNode>();
        for (SurveyObject node : nodes) {
            SchemaTreeNode treeNode = this.getTreeNode(node);
            if (treeNode == null) continue;
            opened.add(treeNode);
        }
        this.setOpenObjects(opened);
    }

    public static class SchemaNodeData
    extends BasicTreeModel.SimpleNodeData {
        private SurveySummary survey;
        private SurveyObject surveyObject;

        protected SchemaNodeData(SurveyObject surveyObject, boolean root, boolean detached, String labelLanguage) {
            this(SurveySummary.createFromSurvey((CollectSurvey)((CollectSurvey)surveyObject.getSurvey())), surveyObject, root, detached, labelLanguage);
        }

        protected SchemaNodeData(SurveySummary survey, SurveyObject surveyObject, boolean root, boolean detached, String labelLanguage) {
            this(survey, surveyObject, SchemaNodeData.getLabel(surveyObject, root, detached, labelLanguage), root, detached);
        }

        protected SchemaNodeData(SurveyObject surveyObject, String label, boolean root, boolean detached) {
            this(SurveySummary.createFromSurvey((CollectSurvey)((CollectSurvey)surveyObject.getSurvey())), surveyObject, label, root, detached);
        }

        protected SchemaNodeData(SurveySummary survey, SurveyObject surveyObject, String label, boolean root, boolean detached) {
            super(label, root, detached);
            this.survey = survey;
            this.surveyObject = surveyObject;
        }

        protected static String getLabel(SurveyObject surveyObject, boolean root, boolean detached, String labelLanguage) {
            String label = detached ? SchemaNodeData.getDetachedLabel(surveyObject, root) : (surveyObject instanceof NodeDefinition ? ((NodeDefinition)surveyObject).getName() : ((UITab)surveyObject).getLabel(labelLanguage));
            return label;
        }

        protected static String getDetachedLabel(SurveyObject surveyObject, boolean root) {
            String result;
            if (surveyObject instanceof NodeDefinition) {
                String nodeTypeLabel = NodeType.getHeaderLabel((NodeDefinition)surveyObject, root, true);
                Object[] args = new String[]{nodeTypeLabel};
                result = Labels.getLabel((String)"survey.schema.tree.new_node_label", (Object[])args);
            } else {
                result = "NEW TAB";
            }
            return result;
        }

        public SurveySummary getSurvey() {
            return this.survey;
        }

        public SurveyObject getSurveyObject() {
            return this.surveyObject;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.surveyObject == null ? 0 : this.surveyObject.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaNodeData other = (SchemaNodeData)obj;
            return !(this.surveyObject == null ? other.surveyObject != null : !this.surveyObject.equals(other.surveyObject));
        }
    }

    public static class SchemaTreeNode
    extends BasicTreeModel.AbstractNode<SchemaNodeData> {
        private static final long serialVersionUID = 1L;
        private boolean disabled = false;

        SchemaTreeNode(SchemaNodeData data) {
            super(data);
        }

        SchemaTreeNode(SchemaNodeData data, Collection<SchemaTreeNode> children) {
            super(data, children);
        }

        public void markAsDetached() {
            SchemaNodeData data = (SchemaNodeData)this.getData();
            data.setDetached(true);
        }

        @Override
        public String getIcon() {
            SchemaNodeData data = (SchemaNodeData)this.getData();
            SurveyObject surveyObject = data.getSurveyObject();
            return surveyObject == null ? null : SchemaVM.getIcon(surveyObject);
        }

        public String getTooltiptext() {
            SchemaNodeData data = (SchemaNodeData)this.getData();
            SurveyObject surveyObject = data.getSurveyObject();
            return surveyObject == null ? null : SchemaVM.getNodeTooltiptext(surveyObject);
        }

        public int getIndexInModel() {
            int result;
            SchemaNodeData data = (SchemaNodeData)this.getData();
            SurveyObject surveyObject = data.getSurveyObject();
            if (surveyObject instanceof NodeDefinition) {
                EntityDefinition parentEntity = ((NodeDefinition)surveyObject).getParentEntityDefinition();
                result = parentEntity.getChildDefinitionIndex((NodeDefinition)surveyObject);
            } else {
                result = ((UITab)surveyObject).getIndex();
            }
            return result;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }
    }
}

