/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openforis.idm.metamodel.AttributeType;
import org.openforis.idm.metamodel.validation.Check;
import org.openforis.idm.metamodel.validation.ComparisonCheck;
import org.openforis.idm.metamodel.validation.CustomCheck;
import org.openforis.idm.metamodel.validation.DistanceCheck;
import org.openforis.idm.metamodel.validation.PatternCheck;
import org.openforis.idm.metamodel.validation.UniquenessCheck;
import org.zkoss.util.resource.Labels;

public enum CheckType {
    COMPARISON,
    CUSTOM,
    DISTANCE,
    PATTERN,
    UNIQUENESS;


    public static CheckType valueOf(Check<?> check) {
        if (check instanceof ComparisonCheck) {
            return COMPARISON;
        }
        if (check instanceof CustomCheck) {
            return CUSTOM;
        }
        if (check instanceof DistanceCheck) {
            return DISTANCE;
        }
        if (check instanceof PatternCheck) {
            return PATTERN;
        }
        if (check instanceof UniquenessCheck) {
            return UNIQUENESS;
        }
        throw new IllegalArgumentException("Check type not supported: " + check.getClass().getName());
    }

    public static Check<?> createCheck(CheckType type) {
        switch (type.ordinal()) {
            case 0: {
                return new ComparisonCheck();
            }
            case 1: {
                return new CustomCheck();
            }
            case 2: {
                return new DistanceCheck();
            }
            case 3: {
                return new PatternCheck();
            }
            case 4: {
                return new UniquenessCheck();
            }
        }
        throw new IllegalArgumentException("Check type not supported: " + (Object)((Object)type));
    }

    public static List<CheckType> compatibleValues(AttributeType attributeType) {
        ArrayList<CheckType> list = new ArrayList<CheckType>(Arrays.asList(CheckType.values()));
        if (attributeType != AttributeType.COORDINATE) {
            list.remove((Object)DISTANCE);
        }
        if (attributeType != AttributeType.TEXT) {
            list.remove((Object)PATTERN);
        }
        return list;
    }

    public String getLabel() {
        String labelKey = null;
        switch (this.ordinal()) {
            case 0: {
                labelKey = "survey.schema.node.check.type.comparison";
                break;
            }
            case 1: {
                labelKey = "survey.schema.node.check.type.custom";
                break;
            }
            case 2: {
                labelKey = "survey.schema.node.check.type.distance";
                break;
            }
            case 3: {
                labelKey = "survey.schema.node.check.type.pattern";
                break;
            }
            case 4: {
                labelKey = "survey.schema.node.check.type.uniqueness";
            }
        }
        return Labels.getLabel((String)labelKey);
    }

    public String getDefaultMessage() {
        String labelKey = null;
        switch (this.ordinal()) {
            case 0: {
                labelKey = "survey.schema.node.check.type.comparison.default_message";
                break;
            }
            case 1: {
                labelKey = "survey.schema.node.check.type.custom.default_message";
                break;
            }
            case 2: {
                labelKey = "survey.schema.node.check.type.distance.default_message";
                break;
            }
            case 3: {
                labelKey = "survey.schema.node.check.type.pattern.default_message";
                break;
            }
            case 4: {
                labelKey = "survey.schema.node.check.type.uniqueness.default_message";
            }
        }
        return Labels.getLabel((String)labelKey);
    }
}

