/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.UnitFormObject;
import org.openforis.collect.designer.metamodel.SchemaUpdater;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectTaxonomy;
import org.openforis.collect.model.SurveySummary;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.commons.lang.Strings;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NamedObject;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Precision;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Unit;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public abstract class SurveyBaseVM
extends BaseVM {
    public static final String VERSIONS_UPDATED_GLOBAL_COMMAND = "versionsUpdated";
    public static final String UNDO_LAST_CHANGES_GLOBAL_COMMAND = "undoLastChanges";
    public static final String SURVEY_CHANGED_GLOBAL_COMMAND = "surveyChanged";
    public static final String SCHEMA_CHANGED_GLOBAL_COMMAND = "schemaChanged";
    public static final String NODE_CONVERTED_GLOBAL_COMMAND = "nodeConverted";
    public static final String SURVEY_SAVED_GLOBAL_COMMAND = "surveySaved";
    public static final String VALIDATE_ALL_GLOBAL_COMMAND = "validateAll";
    public static final String DATE_FORMAT = Labels.getLabel((String)"global.date_format");
    private static final String TAXONOMIES_UPDATED_COMMAND = "taxonomiesUpdated";
    @WireVariable
    protected CollectSurvey survey;
    @WireVariable
    private ExpressionValidator expressionValidator;
    @WireVariable
    private SpeciesManager speciesManager;
    protected String currentLanguageCode;
    private boolean currentFormBlocking = false;
    private boolean currentFormValid = true;
    private Map<String, List<String>> currentFormValidationMessages;
    protected List<String> fieldLabelKeyPrefixes = new ArrayList<String>();
    protected SchemaUpdater schemaUpdater;

    @Override
    public void init() {
        super.init();
        this.initSurvey();
        this.initCurrentLanguageCode();
        this.schemaUpdater = new SchemaUpdater(this.survey);
    }

    private void initCurrentLanguageCode() {
        SessionStatus sessionStatus = this.getSessionStatus();
        this.currentLanguageCode = sessionStatus.getCurrentLanguageCode();
        this.notifyChange("currentLanguageCode");
    }

    @GlobalCommand
    public void versionsUpdated() {
        this.notifyChange("formVersions", "formVersionsWithEmptyOption", "formVersionIdsWithEmptyOption");
    }

    @GlobalCommand
    public void codeListsUpdated() {
        this.notifyChange("codeLists");
    }

    @GlobalCommand
    public void unitsUpdated() {
        this.notifyChange("units");
    }

    @GlobalCommand
    public void tabSetsUpdated() {
        this.notifyChange("tabSets");
    }

    @GlobalCommand
    public void taxonomiesUpdated() {
        this.notifyChange("taxonomyNames");
    }

    @GlobalCommand
    public void currentFormValidated(@BindingParam(value="valid") boolean valid, @BindingParam(value="blocking") Boolean blocking, @BindingParam(value="validationMessagesByField") Map<String, List<String>> validationMessagesByField) {
        this.currentFormValid = valid;
        this.currentFormBlocking = blocking != null && blocking != false;
        this.currentFormValidationMessages = validationMessagesByField;
        this.notifyChange("currentFormValid", "currentFormBlocking");
    }

    @GlobalCommand
    public void undoLastChanges(@ContextParam(value=ContextType.VIEW) Component view) {
        this.undoLastChanges();
    }

    public void undoLastChanges() {
        this.dispatchCurrentFormValidatedCommand();
    }

    public void dispatchCurrentFormValidatedCommand() {
        this.dispatchCurrentFormValidatedCommand(true);
    }

    public void dispatchCurrentFormValidatedCommand(boolean valid) {
        this.dispatchCurrentFormValidatedCommand(valid, false);
    }

    public void dispatchCurrentFormValidatedCommand(boolean valid, boolean blocking) {
        this.dispatchCurrentFormValidatedCommand(valid, blocking, null);
    }

    public void dispatchCurrentFormValidatedCommand(boolean valid, boolean blocking, Map<String, List<String>> validationMessagesByField) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("valid", valid);
        args.put("blocking", blocking);
        args.put("validationMessagesByField", validationMessagesByField);
        BindUtils.postGlobalCommand(null, null, (String)"currentFormValidated", args);
    }

    public void dispatchSurveyChangedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)SURVEY_CHANGED_GLOBAL_COMMAND, null);
    }

    public void dispatchSchemaChangedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)SCHEMA_CHANGED_GLOBAL_COMMAND, null);
        this.dispatchSurveyChangedCommand();
    }

    public void dispatchTaxonomiesUpdatedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)TAXONOMIES_UPDATED_COMMAND, null);
    }

    public void dispatchNodeConvertedCommand(final NodeDefinition nodeDef) {
        HashMap<String, Object> args = new HashMap<String, Object>(){
            {
                this.put("node", nodeDef);
            }
        };
        BindUtils.postGlobalCommand(null, null, (String)NODE_CONVERTED_GLOBAL_COMMAND, (Map)args);
        this.dispatchSurveyChangedCommand();
    }

    protected void dispatchValidateAllCommand() {
        BindUtils.postGlobalCommand(null, null, (String)VALIDATE_ALL_GLOBAL_COMMAND, null);
    }

    public boolean checkCanLeaveForm() {
        return this.checkCanLeaveForm(null);
    }

    public boolean checkCanLeaveForm(CanLeaveFormConfirmHandler confirmHandler) {
        return this.checkCanLeaveForm(confirmHandler, "global.confirm.leave_page_with_errors");
    }

    public boolean checkCanLeaveForm(final CanLeaveFormConfirmHandler confirmHandler, String messageKey) {
        if (this.currentFormValid) {
            if (confirmHandler != null) {
                confirmHandler.onOk(false);
            }
        } else if (confirmHandler == null || this.currentFormBlocking) {
            MessageUtil.showWarning("global.message.errors_in_page", new Object[0]);
        } else {
            MessageUtil.showConfirm(new MessageUtil.CompleteConfirmHandler(){

                @Override
                public void onOk() {
                    confirmHandler.onOk(true);
                }

                @Override
                public void onCancel() {
                    if (confirmHandler instanceof CanLeaveFormCompleteConfirmHandler) {
                        ((CanLeaveFormCompleteConfirmHandler)confirmHandler).onCancel();
                    }
                }
            }, messageKey, new String[]{this.getValidationMessageSummary()}, "global.unsaved_changes", null, "global.continue_and_loose_changes", "global.stay_on_this_page");
        }
        return this.currentFormValid;
    }

    private String getValidationMessageSummary() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, List<String>>> entrySet = this.currentFormValidationMessages.entrySet();
        int count = 0;
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String key = entry.getKey();
            String fieldLabel = this.getFieldLabel(key);
            List<String> messages = entry.getValue();
            sb.append(++count + ") ");
            sb.append(fieldLabel);
            sb.append(": ");
            sb.append(Strings.htmlToText((String)StringUtils.join(messages, (String)"; ")));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getFieldLabel(String key) {
        for (String prefix : this.fieldLabelKeyPrefixes) {
            String labelKey = prefix + "." + key;
            String label = Labels.getLabel((String)labelKey);
            if (label == null) continue;
            return label;
        }
        return key;
    }

    protected void initSurvey() {
        if (this.survey == null) {
            SessionStatus sessionStatus = this.getSessionStatus();
            this.survey = sessionStatus.getSurvey();
        }
    }

    public CollectSurvey getSurvey() {
        if (this.survey == null) {
            this.initSurvey();
        }
        return this.survey;
    }

    public Integer getSurveyId() {
        if (this.survey == null) {
            return null;
        }
        return this.survey.getId();
    }

    public boolean isCollectEarthSurvey() {
        return this.survey != null && this.survey.getTarget() == SurveyTarget.COLLECT_EARTH;
    }

    public boolean isSurveyStored() {
        return this.getSurveyId() != null;
    }

    public boolean isSurveyPublished() {
        if (this.survey == null) {
            return false;
        }
        return this.survey.isPublished();
    }

    public boolean isSurveyChanged() {
        SurveyEditVM rootVM = this.getRootVM();
        return rootVM == null ? false : rootVM.isSurveyChanged();
    }

    protected SurveyEditVM getRootVM() {
        return ComponentUtil.getAncestorViewModel(SurveyEditVM.class);
    }

    @GlobalCommand
    public void currentLanguageChanged() {
        this.initCurrentLanguageCode();
    }

    @GlobalCommand
    public void surveyChanged() {
        this.notifyChange(SURVEY_CHANGED_GLOBAL_COMMAND);
        this.notifyChange("rootEntities");
    }

    @GlobalCommand
    public void surveySaved() {
        this.notifyChange(SURVEY_CHANGED_GLOBAL_COMMAND);
    }

    public String getDateFormat() {
        return DATE_FORMAT;
    }

    public List<ModelVersion> getFormVersions() {
        List<ModelVersion> versions = this.getSurveyFormVersions();
        return versions;
    }

    public List<Object> getFormVersionsWithEmptyOption() {
        List<ModelVersion> versions = this.getSurveyFormVersions();
        ArrayList<ModelVersion> result = new ArrayList<ModelVersion>(versions);
        result.add(0, (ModelVersion)FormObject.VERSION_EMPTY_SELECTION);
        return result;
    }

    public List<Integer> getFormVersionIdsWithEmptyOption() {
        List<ModelVersion> versions = this.getSurveyFormVersions();
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(0, -1);
        for (ModelVersion modelVersion : versions) {
            result.add(modelVersion.getId());
        }
        return result;
    }

    public String getVersionLabel(int id) {
        if (id > 0) {
            CollectSurvey survey = this.getSurvey();
            ModelVersion version = survey.getVersionById(id);
            String result = null;
            if (version != null && (result = version.getLabel(this.currentLanguageCode)) == null) {
                result = version.getName();
            }
            return result;
        }
        return Labels.getLabel((String)"global.empty_option");
    }

    public List<EntityDefinition> getRootEntities() {
        CollectSurvey survey = this.getSurvey();
        if (survey == null) {
            return Collections.emptyList();
        }
        Schema schema = survey.getSchema();
        List result = schema.getRootEntityDefinitions();
        return result;
    }

    @DependsOn(value={"rootEntities"})
    public boolean isSingleRootEntityDefined() {
        List<EntityDefinition> rootEntities = this.getRootEntities();
        return rootEntities != null && rootEntities.size() == 1;
    }

    public List<CodeList> getCodeLists() {
        CollectSurvey survey = this.getSurvey();
        boolean includeSamplingDesignList = survey.getTarget() != SurveyTarget.COLLECT_EARTH;
        ArrayList<CodeList> result = new ArrayList(survey.getCodeLists(includeSamplingDesignList));
        result = this.sortByName(result);
        return result;
    }

    @DependsOn(value={"surveyId"})
    public List<String> getTaxonomyNames() {
        List taxonomies = this.speciesManager.loadTaxonomiesBySurvey(this.survey);
        ArrayList<String> result = new ArrayList<String>();
        for (CollectTaxonomy taxonomy : taxonomies) {
            result.add(taxonomy.getName());
        }
        return result;
    }

    public List<Unit> getUnits() {
        ArrayList<Unit> result = new ArrayList<Unit>(this.survey.getUnits());
        return result;
    }

    public List<String> getUnitNames() {
        return CollectionUtils.project((Collection)this.survey.getUnits(), (String)"name");
    }

    public String getUnitLabelFromPrecision(Precision precision) {
        Unit unit = precision.getUnit();
        return this.getUnitLabel(unit);
    }

    public String getUnitLabelFromName(String name) {
        Unit unit = this.survey.getUnit(name);
        return this.getUnitLabel(unit);
    }

    public String getUnitLabel(Unit unit) {
        if (unit == null) {
            return null;
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)unit.getLabel(this.currentLanguageCode), (CharSequence)unit.getName());
    }

    public String getUnitLabel(UnitFormObject unitFormObject) {
        if (unitFormObject == null) {
            return null;
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)unitFormObject.getLabel(), (CharSequence)unitFormObject.getName());
    }

    public boolean isDefaultLanguage() {
        CollectSurvey survey = this.getSurvey();
        return survey == null ? false : survey.isDefaultLanguage(this.currentLanguageCode);
    }

    public String getDefaultLanguageCode() {
        return this.survey == null ? null : this.survey.getDefaultLanguage();
    }

    @Override
    public String getCurrentLanguageCode() {
        return this.currentLanguageCode;
    }

    public boolean isCurrentFormValid() {
        return this.currentFormValid;
    }

    public boolean isCurrentFormBlocking() {
        return this.currentFormBlocking;
    }

    public ExpressionValidator getExpressionValidator() {
        return this.expressionValidator;
    }

    protected <T extends NamedObject> List<T> sortByName(List<T> items) {
        ArrayList<T> result = new ArrayList<T>(items);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T item2, T item1) {
                return item2.getName().compareTo(item1.getName());
            }
        });
        return result;
    }

    protected Map<String, String> createBasicModuleParameters() {
        Integer surveyId = this.getSurveyId();
        SessionStatus sessionStatus = this.getSessionStatus();
        Integer publishedSurveyId = sessionStatus.getPublishedSurveyId();
        boolean work = surveyId != null;
        Integer usedSurveyId = surveyId != null ? surveyId : publishedSurveyId;
        String surveyIdStr = usedSurveyId == null ? "" : usedSurveyId.toString();
        String localeStr = sessionStatus.getCurrentLanguageCode();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("locale", localeStr);
        result.put("work", Boolean.toString(work));
        result.put("surveyId", surveyIdStr);
        return result;
    }

    public boolean isCurrentEditedSurvey(SurveySummary surveySummary) {
        SessionStatus sessionStatus = this.getSessionStatus();
        Integer editedPublishedSurveyId = sessionStatus.getPublishedSurveyId();
        Integer editedSurveyId = this.getSurveyId();
        if (editedSurveyId == null) {
            return editedPublishedSurveyId != null && surveySummary.isPublished() && editedPublishedSurveyId.equals(surveySummary.getId());
        }
        return surveySummary.getId().equals(editedSurveyId);
    }

    public List<String> getEditableRecordStepNames() {
        return Arrays.asList(CollectRecord.Step.CLEANSING.name(), CollectRecord.Step.ENTRY.name());
    }

    private List<ModelVersion> getSurveyFormVersions() {
        CollectSurvey survey = this.getSurvey();
        if (survey == null) {
            return Collections.emptyList();
        }
        return survey.getSortedVersions();
    }

    protected boolean isSurveyRelatedToPublishedSurvey() {
        return this.survey.isTemporary() && this.survey.getPublishedId() != null;
    }

    public static interface CanLeaveFormConfirmHandler {
        public void onOk(boolean var1);
    }

    public static interface CanLeaveFormCompleteConfirmHandler
    extends CanLeaveFormConfirmHandler {
        public void onCancel();
    }

    public static enum SurveyType {
        TEMPORARY,
        PUBLISHED;

    }
}

