/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.util.SuccessHandler;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.DataExportErrorsPopUpVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyValidationResultsVM;
import org.openforis.collect.io.SurveyBackupJob;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreator;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreatorImpl;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.manager.validation.CollectMobileSurveyValidator;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.relational.print.RDBPrintJob;
import org.openforis.collect.utils.Dates;
import org.openforis.concurrency.Job;
import org.zkoss.bind.Form;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class SurveyExportParametersVM
extends BaseVM {
    private static Log LOG = Log.lookup(SurveyExportParametersVM.class);
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SURVEY_EXPORT_FILE_NAME_PATTERN = "%s_%s.%s";
    private static final String SURVEY_EXPORT_MOBILE_FILE_NAME_PATTERN = "%s_%s_%s.%s";
    private static final String COLLECT_EARTH_PROJECT_FILE_EXTENSION = "cep";
    private static final CollectEarthProjectFileCreator COLLECT_EARTH_PROJECT_FILE_CREATOR;
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private RecordManager recordManager;
    @WireVariable
    private CodeListManager codeListManager;
    @WireVariable
    private SurveyValidator surveyValidator;
    @WireVariable
    private CollectEarthSurveyValidator collectEarthSurveyValidator;
    @WireVariable
    private CollectMobileSurveyValidator collectMobileSurveyValidator;
    private SurveySummary surveySummary;
    private SurveyExportParametersFormObject formObject;
    private SimpleForm tempForm;
    private Window jobStatusPopUp;

    public static void openPopUp(SurveySummary surveySummary) throws IOException {
        HashMap<String, SurveySummary> args = new HashMap<String, SurveySummary>();
        args.put("survey", surveySummary);
        SurveyExportParametersVM.openPopUp(Resources.Component.SURVEY_EXPORT_PARAMETERS_POPUP.getLocation(), true, args);
    }

    @Init
    public void init(@ExecutionArgParam(value="survey") SurveySummary survey) {
        this.surveySummary = survey;
        this.formObject = new SurveyExportParametersFormObject();
        String outputFormat = (survey.getTarget() == SurveyTarget.COLLECT_EARTH ? SurveyExportParametersFormObject.OutputFormat.EARTH : SurveyExportParametersFormObject.OutputFormat.DESKTOP).name();
        this.formObject.setOutputFormat(outputFormat);
        this.formObject.setType((survey.isNotLinkedToPublishedSurvey() ? SurveyBaseVM.SurveyType.TEMPORARY : SurveyBaseVM.SurveyType.PUBLISHED).name());
        this.formObject.setRdbDialect(RDBPrintJob.RdbDialect.STANDARD.name());
        this.formObject.setRdbDateTimeFormat(DEFAULT_DATE_TIME_FORMAT);
        this.formObject.setRdbTargetSchemaName(survey.getName());
        this.formObject.setLanguageCode(survey.getDefaultLanguage());
        this.tempForm = new SimpleForm();
    }

    @Command
    public void typeChanged() {
        this.checkEnabledFields();
    }

    @Command
    public void outputFormatChanged() {
        this.checkEnabledFields();
    }

    @Command
    public void includeDataChanged() {
        this.checkEnabledFields();
    }

    @Command
    public void export() {
        String uri = this.surveySummary.getUri();
        final CollectSurvey loadedSurvey = this.surveySummary.isTemporary() && SurveyBaseVM.SurveyType.valueOf(this.formObject.getType()) == SurveyBaseVM.SurveyType.TEMPORARY ? this.surveyManager.loadSurvey(this.surveySummary.getId().intValue()) : this.surveyManager.getByUri(uri);
        switch (this.formObject.getOutputFormatEnum().ordinal()) {
            case 3: {
                this.validateSurvey(loadedSurvey, this.collectEarthSurveyValidator, new SuccessHandler(){

                    @Override
                    public void onSuccess() {
                        SurveyExportParametersVM.this.exportCollectEarthSurvey(loadedSurvey, SurveyExportParametersVM.this.formObject);
                    }
                }, true);
                return;
            }
            case 2: {
                this.startRDBSurveyExportJob(loadedSurvey, this.formObject);
                break;
            }
            case 0: {
                this.validateSurvey(loadedSurvey, this.collectMobileSurveyValidator, new SuccessHandler(){

                    @Override
                    public void onSuccess() {
                        SurveyExportParametersVM.this.startCollectSurveyExportJob(loadedSurvey, SurveyExportParametersVM.this.formObject);
                    }
                }, true);
                break;
            }
            default: {
                this.startCollectSurveyExportJob(loadedSurvey, this.formObject);
            }
        }
    }

    private void downloadFile(File file, String extension, String contentType, CollectSurvey survey, String defaultLanguageCode) {
        String surveyName = survey.getName();
        String dateStr = Dates.formatLocalDateTime((Date)survey.getModifiedDate());
        String fileName = SurveyBackupJob.OutputFormat.MOBILE.getOutputFileExtension().equals(extension) ? String.format(SURVEY_EXPORT_MOBILE_FILE_NAME_PATTERN, surveyName, defaultLanguageCode, dateStr, extension) : String.format(SURVEY_EXPORT_FILE_NAME_PATTERN, surveyName, dateStr, extension);
        try {
            Filedownload.save((InputStream)new FileInputStream(file), (String)contentType, (String)fileName);
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            MessageUtil.showError("survey.export_survey.error", e.getMessage());
        }
    }

    private void startRDBSurveyExportJob(CollectSurvey survey, SurveyExportParametersFormObject parameters) {
        final RDBPrintJob job = new RDBPrintJob();
        job.setSurvey(survey);
        job.setTargetSchemaName(survey.getName());
        job.setRecordManager(this.recordManager);
        RecordFilter recordFilter = new RecordFilter(survey);
        job.setRecordFilter(recordFilter);
        job.setIncludeData(parameters.isIncludeData());
        job.setDialect(parameters.getRdbDialectEnum());
        job.setDateTimeFormat(parameters.getRdbDateTimeFormat());
        job.setTargetSchemaName(parameters.getRdbTargetSchemaName());
        this.jobManager.start((Job)job, String.valueOf(survey.getId()));
        this.openJobStatusPopUp(survey.getName(), job, new ExportJobEndHandler<RDBPrintJob>(){

            @Override
            protected void onJobCompleted() {
                File file = job.getOutputFile();
                CollectSurvey survey = job.getSurvey();
                SurveyExportParametersVM.this.downloadFile(file, "zip", "text/plain", survey, survey.getDefaultLanguage());
                super.onJobCompleted();
            }
        });
    }

    private <J extends Job> void openJobStatusPopUp(String surveyName, J job, JobStatusPopUpVM.JobEndHandler<J> jobEndHandler) {
        String title = Labels.getLabel((String)"survey.export_survey.process_status_popup.message", (Object[])new String[]{surveyName});
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp(title, job, true, jobEndHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCollectEarthSurvey(CollectSurvey survey, SurveyExportParametersFormObject parameters) {
        FileInputStream is = null;
        try {
            CollectEarthProjectFileCreatorImpl creatorImpl = (CollectEarthProjectFileCreatorImpl)COLLECT_EARTH_PROJECT_FILE_CREATOR;
            creatorImpl.setCodeListManager(this.codeListManager);
            creatorImpl.setSurveyManager(this.surveyManager);
            String languageCode = parameters.getLanguageCode();
            File file = COLLECT_EARTH_PROJECT_FILE_CREATOR.create(survey, languageCode);
            String contentType = URLConnection.guessContentTypeFromName(file.getName());
            is = new FileInputStream(file);
            String outputFileName = String.format(SURVEY_EXPORT_MOBILE_FILE_NAME_PATTERN, survey.getName(), languageCode, Dates.formatLocalDateTime((Date)survey.getModifiedDate()), COLLECT_EARTH_PROJECT_FILE_EXTENSION);
            Filedownload.save((InputStream)is, (String)contentType, (String)outputFileName);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            MessageUtil.showError("survey.export.error_generating_collect_earth_project_file", e.getMessage());
            IOUtils.closeQuietly(is);
        }
    }

    protected void startCollectSurveyExportJob(CollectSurvey survey, SurveyExportParametersFormObject parameters) {
        final SurveyBackupJob job = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
        job.setSurvey(survey);
        job.setIncludeData(parameters.isIncludeData());
        job.setIncludeRecordFiles(parameters.isIncludeUploadedFiles());
        job.setOutputFormat(SurveyBackupJob.OutputFormat.valueOf((String)parameters.getOutputFormat()));
        job.setOutputSurveyDefaultLanguage((String)ObjectUtils.defaultIfNull((Object)parameters.getLanguageCode(), (Object)survey.getDefaultLanguage()));
        this.jobManager.start((Job)job, String.valueOf(survey.getId()));
        this.openJobStatusPopUp(survey.getName(), job, new ExportJobEndHandler<SurveyBackupJob>(){

            @Override
            protected void onJobCompleted() {
                File file = job.getOutputFile();
                SurveyExportParametersVM.this.downloadFile(file, job.getOutputFormat().getOutputFileExtension(), "application/octet-stream", job.getSurvey(), job.getOutputSurveyDefaultLanguage());
                List dataBackupErrors = job.getDataBackupErrors();
                if (!dataBackupErrors.isEmpty()) {
                    DataExportErrorsPopUpVM.showPopUp(dataBackupErrors);
                }
                super.onJobCompleted();
            }
        });
    }

    private void validateSurvey(CollectSurvey survey, SurveyValidator validator, final SuccessHandler successHandler, boolean showWarningConfirm) {
        SurveyValidator.SurveyValidationResults validationResults = validator.validate(survey);
        if (validationResults.isOk()) {
            successHandler.onSuccess();
        } else {
            final Window validationResultsPopUp = SurveyValidationResultsVM.showPopUp(validationResults, showWarningConfirm && !validationResults.hasErrors());
            validationResultsPopUp.addEventListener("onConfirm", (EventListener)new EventListener<SurveyValidationResultsVM.ConfirmEvent>(){

                public void onEvent(SurveyValidationResultsVM.ConfirmEvent event) throws Exception {
                    successHandler.onSuccess();
                    BaseVM.closePopUp(validationResultsPopUp);
                }
            });
        }
    }

    protected void closeJobStatusPopUp() {
        SurveyExportParametersVM.closePopUp(this.jobStatusPopUp);
        this.jobStatusPopUp = null;
    }

    @DependsOn(value={"tempForm.type", "tempForm.outputFormat"})
    public boolean isIncludeDataVisible() {
        SurveyBaseVM.SurveyType type = SurveyBaseVM.SurveyType.valueOf(this.getTypeFormField());
        SurveyExportParametersFormObject.OutputFormat outputFormat = SurveyExportParametersFormObject.OutputFormat.valueOf(this.getOutputFormatFormField());
        return type == SurveyBaseVM.SurveyType.PUBLISHED && outputFormat == SurveyExportParametersFormObject.OutputFormat.RDB;
    }

    public boolean isCollectEarthSurvey() {
        return this.surveySummary != null && this.surveySummary.getTarget() == SurveyTarget.COLLECT_EARTH;
    }

    public SurveyExportParametersFormObject getFormObject() {
        return this.formObject;
    }

    public void setFormObject(SurveyExportParametersFormObject formObject) {
        this.formObject = formObject;
    }

    public SurveySummary getSurvey() {
        return this.surveySummary;
    }

    public Form getTempForm() {
        return this.tempForm;
    }

    public void setTempForm(SimpleForm tempForm) {
        this.tempForm = tempForm;
    }

    private void checkEnabledFields() {
        if (this.isIncludeDataVisible()) {
            boolean includeData = (Boolean)this.getFormFieldValue(this.tempForm, "includeData");
            if (!includeData) {
                this.setFormFieldValue(this.tempForm, "includeUploadedFiles", (Object)false);
            }
        } else {
            this.setFormFieldValue(this.tempForm, "includeData", (Object)false);
        }
    }

    private String getOutputFormatFormField() {
        return (String)this.getFormFieldValue(this.tempForm, "outputFormat");
    }

    private String getTypeFormField() {
        return (String)this.getFormFieldValue(this.tempForm, "type");
    }

    public List<String> getSurveyLanguages() {
        return this.surveySummary.getLanguages();
    }

    static {
        Iterator it = COLLECT_EARTH_PROJECT_FILE_CREATOR_LOADER.iterator();
        COLLECT_EARTH_PROJECT_FILE_CREATOR = it.hasNext() ? (CollectEarthProjectFileCreator)it.next() : null;
    }

    public static class SurveyExportParametersFormObject {
        private String type;
        private boolean includeData;
        private boolean includeUploadedFiles;
        private String outputFormat;
        private String rdbDialect;
        private String rdbDateTimeFormat;
        private String rdbTargetSchemaName;
        private String languageCode;

        public String getType() {
            return this.type;
        }

        public SurveyBaseVM.SurveyType getTypeEnum() {
            return SurveyBaseVM.SurveyType.valueOf(this.type);
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isIncludeData() {
            return this.includeData;
        }

        public void setIncludeData(boolean includeData) {
            this.includeData = includeData;
        }

        public boolean isIncludeUploadedFiles() {
            return this.includeUploadedFiles;
        }

        public void setIncludeUploadedFiles(boolean includeUploadedFiles) {
            this.includeUploadedFiles = includeUploadedFiles;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public OutputFormat getOutputFormatEnum() {
            return OutputFormat.valueOf(this.outputFormat);
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public String getRdbDialect() {
            return this.rdbDialect;
        }

        public RDBPrintJob.RdbDialect getRdbDialectEnum() {
            return RDBPrintJob.RdbDialect.valueOf((String)this.rdbDialect);
        }

        public void setRdbDialect(String rdbDialect) {
            this.rdbDialect = rdbDialect;
        }

        public String getRdbDateTimeFormat() {
            return this.rdbDateTimeFormat;
        }

        public void setRdbDateTimeFormat(String rdbDateTimeFormat) {
            this.rdbDateTimeFormat = rdbDateTimeFormat;
        }

        public String getRdbTargetSchemaName() {
            return this.rdbTargetSchemaName;
        }

        public void setRdbTargetSchemaName(String rdbTargetSchemaName) {
            this.rdbTargetSchemaName = rdbTargetSchemaName;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public static enum OutputFormat {
            MOBILE,
            DESKTOP,
            RDB,
            EARTH;

        }
    }

    private class ExportJobEndHandler<J extends Job>
    implements JobStatusPopUpVM.JobEndHandler<J> {
        private ExportJobEndHandler() {
        }

        @Override
        public void onJobEnd(J job) {
            switch (job.getStatus()) {
                case COMPLETED: {
                    this.onJobCompleted();
                    break;
                }
                case FAILED: {
                    MessageUtil.showError("survey.export.error", Labels.getLabel((String)job.getErrorMessage(), (Object[])job.getErrorMessageArgs()));
                    break;
                }
            }
            SurveyExportParametersVM.this.closeJobStatusPopUp();
        }

        protected void onJobCompleted() {
            MessageUtil.showInfo("survey.export.completed", new Object[0]);
        }
    }
}

