/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.openforis.collect.io.metadata.codelist.CodeListImportTask;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;

public class CodeListBatchImportJob
extends Job {
    private static final String ZIP = "zip";
    private static final String CSV = "csv";
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final String MACOSX_HIDDEN_ENTRY_PREFIX = "__MACOSX/";
    private static final List<String> VALID_EXTENSIONS = Arrays.asList("csv", "xls", "xlsx");
    private CodeListManager codeListManager;
    private CollectSurvey survey;
    private File file;
    private boolean overwriteData;
    private ZipFile zipFile;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.zipFile = new ZipFile(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateInput() throws Throwable {
        super.validateInput();
        if (!this.hasExtension(this.file.getName(), ZIP)) {
            throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_extension");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.file);
            Enumeration entries = zipFile.getEntries();
            if (!entries.hasMoreElements()) {
                throw new IllegalArgumentException("survey.code_list.import_data.error.empty_file");
            }
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String entryName = entry.getName();
                if (this.canSkipEntry(entryName)) continue;
                if (!this.hasValidCodeListExtension(entryName)) {
                    throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_extension");
                }
                if (FilenameUtils.getBaseName((String)entryName).matches("[a-z][a-z0-9_]*")) continue;
                throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_filename");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zipFile);
    }

    private boolean canSkipEntry(String entryName) {
        return entryName.startsWith(MACOSX_HIDDEN_ENTRY_PREFIX);
    }

    private boolean hasExtension(String fileName, String expectedExtension) {
        return expectedExtension.equalsIgnoreCase(FilenameUtils.getExtension((String)fileName));
    }

    private boolean hasValidCodeListExtension(String fileName) {
        for (String validExtension : VALID_EXTENSIONS) {
            if (!this.hasExtension(fileName, validExtension)) continue;
            return true;
        }
        return false;
    }

    protected void buildTasks() throws Throwable {
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            String entryName = entry.getName();
            if (this.canSkipEntry(entryName) || !this.hasValidCodeListExtension(entryName)) continue;
            this.addCodeListImportTask(entryName);
        }
    }

    protected void initializeTask(Worker task) {
        try {
            CodeListImportTask importTask = (CodeListImportTask)task;
            String entryName = importTask.getEntryName();
            ZipArchiveEntry zipEntry = this.zipFile.getEntry(entryName);
            InputStream is = this.zipFile.getInputStream(zipEntry);
            importTask.setInputStream(is);
            super.initializeTask(task);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addCodeListImportTask(String entryName) {
        String codeListName = FilenameUtils.getBaseName((String)entryName);
        CodeList codeList = this.getOrCreateCodeList(codeListName);
        CodeListImportTask task = new CodeListImportTask();
        task.setCodeListManager(this.codeListManager);
        task.setCodeList(codeList);
        task.setOverwriteData(this.overwriteData);
        task.setEntryName(entryName);
        this.addTask((Worker)task);
    }

    private CodeList getOrCreateCodeList(String codeListName) {
        CodeList codeList = this.survey.getCodeList(codeListName);
        if (codeList == null) {
            codeList = this.survey.createCodeList();
            codeList.setName(codeListName);
            this.survey.addCodeList(codeList);
        }
        return codeList;
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOverwriteData(boolean overwriteData) {
        this.overwriteData = overwriteData;
    }
}

