/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openforis.collect.manager.RecordGenerator;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.User;
import org.openforis.commons.collection.Visitor;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RandomRecordGenerator
extends RecordGenerator {
    @Transactional
    public CollectRecord generate(int surveyId, RecordGenerator.NewRecordParameters parameters) {
        User user;
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        RecordGenerator.RecordKey recordKey = this.provideRandomRecordKey(survey, user = this.loadUser(parameters.getUserId(), parameters.getUsername()), parameters.isOnlyUnanalyzedSamplingPoints());
        if (recordKey == null) {
            return null;
        }
        return this.generate(survey, parameters, recordKey);
    }

    private RecordGenerator.RecordKey provideRandomRecordKey(CollectSurvey survey, User user, boolean onlyUnanalyzed) {
        Map<RecordGenerator.RecordKey, Integer> recordMeasurementsByKey = this.calculateRecordMeasurementsByKey(survey, user);
        if (recordMeasurementsByKey.isEmpty()) {
            throw new IllegalStateException(String.format("Sampling design data not defined for survey %s", survey.getName()));
        }
        int minMeasurements = onlyUnanalyzed ? 0 : Collections.min(recordMeasurementsByKey.values());
        return this.provideRandomRecordKey(survey, recordMeasurementsByKey, minMeasurements);
    }

    private RecordGenerator.RecordKey provideRandomRecordKey(CollectSurvey survey, Map<RecordGenerator.RecordKey, Integer> recordMeasurementsByKey, int measurements) {
        HashMap<RecordGenerator.RecordKey, Integer> filteredRecordMeasurementsByKey = new HashMap<RecordGenerator.RecordKey, Integer>(recordMeasurementsByKey);
        Iterator iterator = filteredRecordMeasurementsByKey.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if ((Integer)entry.getValue() == measurements) continue;
            iterator.remove();
        }
        if (filteredRecordMeasurementsByKey.isEmpty()) {
            return null;
        }
        ArrayList recordKeys = new ArrayList(filteredRecordMeasurementsByKey.keySet());
        int recordKeyIdx = Double.valueOf(Math.floor(Math.random() * (double)recordKeys.size())).intValue();
        RecordGenerator.RecordKey randomRecordKey = (RecordGenerator.RecordKey)recordKeys.get(recordKeyIdx);
        List<AttributeDefinition> measurementKeyDefs = this.getMeasurementKeyDefs(survey);
        String measurementAttrPath = measurementKeyDefs.get(0).getPath();
        randomRecordKey.putValue(measurementAttrPath, String.valueOf(measurements + 1));
        return randomRecordKey;
    }

    private Map<RecordGenerator.RecordKey, Integer> calculateRecordMeasurementsByKey(CollectSurvey survey, final User user) {
        final List<AttributeDefinition> nonMeasurementKeyDefs = this.getNonMeasurementKeyDefs(survey);
        final HashMap<RecordGenerator.RecordKey, Integer> measurementsByRecordKey = new HashMap<RecordGenerator.RecordKey, Integer>();
        this.recordManager.visitSummaries(new RecordFilter(survey), null, (Visitor)new Visitor<CollectRecordSummary>(){

            public void visit(CollectRecordSummary summary) {
                if (summary.getCreatedBy().getId() != user.getId()) {
                    List keys = summary.getCurrentStepSummary().getRootEntityKeyValues();
                    RecordGenerator.RecordKey nonMeasurementKey = new RecordGenerator.RecordKey(nonMeasurementKeyDefs, keys);
                    Integer measurements = (Integer)measurementsByRecordKey.get(nonMeasurementKey);
                    measurements = measurements == null ? Integer.valueOf(1) : Integer.valueOf(measurements + 1);
                    measurementsByRecordKey.put(nonMeasurementKey, measurements);
                }
            }
        });
        this.samplingDesignManager.visitItems(survey.getId().intValue(), Integer.valueOf(1), (Visitor)new Visitor<SamplingDesignItem>(){

            public void visit(SamplingDesignItem item) {
                RecordGenerator.RecordKey key = new RecordGenerator.RecordKey(nonMeasurementKeyDefs, item.getLevelCodes());
                Integer measurements = (Integer)measurementsByRecordKey.get(key);
                if (measurements == null) {
                    measurementsByRecordKey.put(key, 0);
                }
            }
        });
        return measurementsByRecordKey;
    }
}

