/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.process.AbstractProcess;
import org.openforis.collect.manager.process.ProcessStatus;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.RecordValidationReportGenerator;
import org.openforis.collect.model.RecordValidationReportItem;
import org.openforis.collect.model.User;
import org.openforis.collect.model.validation.ValidationMessageBuilder;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.validation.ValidationResultFlag;
import org.openforis.idm.path.Path;

public class ValidationReportProcess
extends AbstractProcess<Void, ProcessStatus> {
    private static final String[] VALIDATION_REPORT_HEADERS = new String[]{"Record", "Phase", "Attribute Schema Path", "Field path", "Field path (labels)", "Error message"};
    private static final Logger LOG = LogManager.getLogger(ValidationReportProcess.class);
    private OutputStream outputStream;
    private RecordManager recordManager;
    private ReportType reportType;
    private RecordFilter recordFilter;
    private boolean includeConfirmedErrors;
    private Locale locale;
    private ValidationMessageBuilder validationMessageBuilder;
    private CsvWriter csvWriter;

    public ValidationReportProcess(OutputStream outputStream, RecordManager recordManager, MessageSource messageSource, ReportType reportType, User user, String sessionId, RecordFilter recordFilter, boolean includeConfirmedErrors) {
        this(outputStream, recordManager, messageSource, reportType, user, sessionId, recordFilter, includeConfirmedErrors, Locale.ENGLISH);
    }

    public ValidationReportProcess(OutputStream outputStream, RecordManager recordManager, MessageSource messageSource, ReportType reportType, User user, String sessionId, RecordFilter recordFilter, boolean includeConfirmedErrors, Locale locale) {
        this.outputStream = outputStream;
        this.recordManager = recordManager;
        this.reportType = reportType;
        this.recordFilter = recordFilter;
        this.includeConfirmedErrors = includeConfirmedErrors;
        this.validationMessageBuilder = ValidationMessageBuilder.createInstance((MessageSource)messageSource);
        this.locale = locale;
    }

    protected void initStatus() {
        this.status = new ProcessStatus();
    }

    public void startProcessing() throws Exception {
        super.startProcessing();
        List summaries = this.recordManager.loadSummaries(this.recordFilter);
        if (summaries != null) {
            this.status.setTotal((long)summaries.size());
            try {
                this.initWriter();
                this.writeHeader();
                for (CollectRecordSummary summary : summaries) {
                    if (!this.status.isRunning()) continue;
                    CollectRecord.Step step = summary.getStep();
                    Integer recordId = summary.getId();
                    CollectRecord record = this.recordManager.load(this.recordFilter.getSurvey(), recordId.intValue(), step);
                    this.writeValidationReport(record);
                    this.status.incrementProcessed();
                }
                this.closeWriter();
                if (this.status.isRunning()) {
                    this.status.complete();
                }
            }
            catch (IOException e) {
                this.status.error();
                String message = e.getMessage();
                this.status.setErrorMessage(message);
                LOG.error(message, (Throwable)e);
            }
        }
    }

    protected void initWriter() throws UnsupportedEncodingException {
        switch (this.reportType.ordinal()) {
            case 0: {
                this.csvWriter = new CsvWriter(this.outputStream, "UTF-8", ',', '\"');
            }
        }
    }

    private void closeWriter() throws IOException {
        switch (this.reportType.ordinal()) {
            case 0: {
                this.csvWriter.close();
            }
        }
    }

    protected void writeValidationReport(CollectRecord record) throws IOException {
        RecordValidationReportGenerator reportGenerator = new RecordValidationReportGenerator(record);
        List validationItems = reportGenerator.generateValidationItems(this.locale, ValidationResultFlag.ERROR, this.includeConfirmedErrors);
        for (RecordValidationReportItem item : validationItems) {
            this.writeValidationReportLine(record, item);
        }
    }

    protected void writeHeader() throws IOException {
        switch (this.reportType.ordinal()) {
            case 0: {
                this.csvWriter.writeHeaders(VALIDATION_REPORT_HEADERS);
            }
        }
    }

    protected void writeValidationReportLine(CollectRecord record, RecordValidationReportItem item) {
        String recordKey = this.validationMessageBuilder.getRecordKey(record);
        String phase = record.getStep().name();
        String absolutePath = Path.getAbsolutePath((String)item.getPath());
        NodeDefinition nodeDef = record.getSurvey().getSchema().getDefinitionByPath(absolutePath);
        Object[] line = new String[]{recordKey, phase, nodeDef.getPath(), item.getPath(), item.getPrettyFormatPath(), item.getMessage()};
        switch (this.reportType.ordinal()) {
            case 0: {
                this.csvWriter.writeNext(line);
            }
        }
    }

    public static enum ReportType {
        CSV;

    }
}

