/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.io.data.backup.BackupStorageManager;
import org.openforis.collect.manager.ConfigurationManager;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.web.controller.DataRestoreController;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RemoteCollectCloneDataRestoreJob
extends Job {
    private static final Logger LOG = LogManager.getLogger(RemoteCollectCloneDataRestoreJob.class);
    @Autowired
    private BackupStorageManager backupStorageManager;
    @Autowired
    private ConfigurationManager configurationManager;
    private String surveyName;
    private String remoteJobId;

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new BackupSendTask());
        this.addTask((Worker)new RestoreStatusUpdateTask());
    }

    public String getSurveyName() {
        return this.surveyName;
    }

    public void setSurveyName(String surveyName) {
        this.surveyName = surveyName;
    }

    private DataRestoreController.RemoteDataRestoreResponse extractRestoreResponse(InputStream is) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DataRestoreController.RemoteDataRestoreResponse response = (DataRestoreController.RemoteDataRestoreResponse)((Object)mapper.readValue(is, DataRestoreController.RemoteDataRestoreResponse.class));
        return response;
    }

    private class BackupSendTask
    extends Task {
        private static final int BACKUP_SEND_TIMEOUT_MINS = 30;
        private static final int BACKUP_SEND_TIMEOUT_MILLIS = 1800000;
        private HttpUriRequest request;

        private BackupSendTask() {
        }

        protected void createInternalVariables() throws Throwable {
            super.createInternalVariables();
            this.request = this.createRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() throws Throwable {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            CloseableHttpClient httpClient = null;
            try {
                httpClient = clientBuilder.build();
                CloseableHttpResponse response = httpClient.execute(this.request);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    this.changeStatus(Worker.Status.FAILED);
                    this.setErrorMessage("Invalid response");
                } else {
                    InputStream is = entity.getContent();
                    DataRestoreController.RemoteDataRestoreResponse restoreResponse = RemoteCollectCloneDataRestoreJob.this.extractRestoreResponse(is);
                    if (restoreResponse.isStatusOk()) {
                        RemoteCollectCloneDataRestoreJob.this.remoteJobId = restoreResponse.getJobId();
                    } else {
                        this.changeStatus(Worker.Status.FAILED);
                        this.setErrorMessage(restoreResponse.getErrorMessage());
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)httpClient);
            }
        }

        private HttpPost createRequest() {
            String remoteCollectCloneUrl = RemoteCollectCloneDataRestoreJob.this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.REMOTE_CLONE_URL);
            String restoreKey = RemoteCollectCloneDataRestoreJob.this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.REMOTE_RESTORE_KEY);
            File lastBackupFile = RemoteCollectCloneDataRestoreJob.this.backupStorageManager.getLastBackupFile(RemoteCollectCloneDataRestoreJob.this.surveyName);
            String postUrl = remoteCollectCloneUrl + String.format("/surveys/%s/data/restore-remotely.json", RemoteCollectCloneDataRestoreJob.this.surveyName);
            HttpPost post = new HttpPost(postUrl);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(1800000).build();
            post.setConfig(config);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addBinaryBody("fileData", lastBackupFile);
            multipartEntityBuilder.addPart("name", (ContentBody)new StringBody(lastBackupFile.getName(), ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("surveyName", (ContentBody)new StringBody(RemoteCollectCloneDataRestoreJob.this.surveyName, ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("restoreKey", (ContentBody)new StringBody(restoreKey, ContentType.TEXT_PLAIN));
            post.setEntity(multipartEntityBuilder.build());
            return post;
        }

        public void abort() {
            super.abort();
            if (this.request != null) {
                this.request.abort();
            }
        }
    }

    private class RestoreStatusUpdateTask
    extends Task {
        private static final long UPDATE_PERIOD = 5000L;
        private static final int REQUEST_TIMEOUT_MINS = 2;
        private static final int REQUEST_TIMEOUT_MILLIS = 120000;
        private HttpRequestBase jobStatusRequest;

        private RestoreStatusUpdateTask() {
        }

        protected long countTotalItems() {
            return 100L;
        }

        protected void createInternalVariables() throws Throwable {
            super.createInternalVariables();
            this.jobStatusRequest = this.createRequest();
        }

        private HttpRequestBase createRequest() {
            String remoteCollectCloneUrl = RemoteCollectCloneDataRestoreJob.this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.REMOTE_CLONE_URL);
            String url = remoteCollectCloneUrl + String.format("/surveys/data/restore/jobs/%s/status.json", RemoteCollectCloneDataRestoreJob.this.remoteJobId);
            HttpGet request = new HttpGet(url);
            request.setConfig(RequestConfig.custom().setConnectTimeout(120000).build());
            return request;
        }

        private HttpRequestBase createRemoteJobAbortRequest() {
            String remoteCollectCloneUrl = RemoteCollectCloneDataRestoreJob.this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.REMOTE_CLONE_URL);
            String url = remoteCollectCloneUrl + String.format("/surveys/data/restore/jobs/%s/abort.json", RemoteCollectCloneDataRestoreJob.this.remoteJobId);
            HttpGet request = new HttpGet(url);
            request.setConfig(RequestConfig.custom().setConnectTimeout(120000).build());
            return request;
        }

        protected void execute() throws Throwable {
            while (this.isRunning()) {
                this.updateRemoteJobStatus();
                if (!this.isRunning()) continue;
                Thread.sleep(5000L);
            }
        }

        private void updateRemoteJobStatus() {
            DataRestoreController.RemoteDataRestoreResponse response = this.fetchDataRestoreStatus();
            this.handleResponse(response);
        }

        private void handleResponse(DataRestoreController.RemoteDataRestoreResponse response) {
            if (response == null || response.isStatusError()) {
                String errorMessage = response == null ? "Error fetching data restore status" : response.getErrorMessage();
                this.errorOccurred(errorMessage);
            } else {
                switch (response.getJobStatus()) {
                    case PENDING: {
                        break;
                    }
                    case RUNNING: {
                        this.setProcessedItems(response.getJobProgress());
                        break;
                    }
                    case FAILED: {
                        this.setErrorMessage(response.getJobErrorMessage());
                        break;
                    }
                    case ABORTED: {
                        this.changeStatus(Worker.Status.ABORTED);
                        break;
                    }
                    case COMPLETED: {
                        this.setProcessedItems(100L);
                        this.changeStatus(Worker.Status.COMPLETED);
                    }
                }
            }
        }

        public void abort() {
            super.abort();
            if (this.jobStatusRequest != null) {
                this.jobStatusRequest.abort();
            }
            this.abortRemoteJob();
        }

        private DataRestoreController.RemoteDataRestoreResponse fetchDataRestoreStatus() {
            return this.executeRequest(this.jobStatusRequest);
        }

        private DataRestoreController.RemoteDataRestoreResponse executeRequest(HttpRequestBase request) {
            try {
                HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                CloseableHttpClient httpClient = clientBuilder.build();
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    this.errorOccurred("Invalid response");
                    return null;
                }
                InputStream is = entity.getContent();
                DataRestoreController.RemoteDataRestoreResponse restoreResponse = RemoteCollectCloneDataRestoreJob.this.extractRestoreResponse(is);
                return restoreResponse;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                return null;
            }
        }

        private void abortRemoteJob() {
            HttpRequestBase request = this.createRemoteJobAbortRequest();
            DataRestoreController.RemoteDataRestoreResponse response = this.executeRequest(request);
            this.handleResponse(response);
        }

        private void errorOccurred(String errorMessage) {
            this.changeStatus(Worker.Status.FAILED);
            this.setErrorMessage(errorMessage);
        }
    }
}

