/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.commons.collection.Visitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordStatsGenerator {
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private SurveyManager surveyManager;

    public RecordsStats generate(int surveyId, Date[] period) {
        final RecordsStats stats = new RecordsStats(period);
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        this.recordManager.visitSummaries(new RecordFilter(survey), null, (Visitor)new Visitor<CollectRecordSummary>(){

            public void visit(CollectRecordSummary s) {
                for (Map.Entry entry : s.getStepSummaries().entrySet()) {
                    CollectRecord.Step step = (CollectRecord.Step)entry.getKey();
                    CollectRecordSummary.StepSummary stepSummary = (CollectRecordSummary.StepSummary)entry.getValue();
                    if (stepSummary.getCreationDate() == null) continue;
                    PointStats pointStats = stats.getOrCreateDailyStats(stepSummary.getCreationDate());
                    switch (step) {
                        case ENTRY: {
                            pointStats.incrementCreated();
                            break;
                        }
                        case CLEANSING: {
                            pointStats.incrementEntered();
                            break;
                        }
                        case ANALYSIS: {
                            pointStats.incrementCleansed();
                        }
                    }
                }
                if (s.getModifiedDate() != null) {
                    PointStats pointStats = stats.getOrCreateDailyStats(s.getModifiedDate());
                    pointStats.incrementModified();
                }
            }
        }, true);
        stats.finalize();
        return stats;
    }

    public static class RecordsStats {
        public static final RecordsStats EMPTY = new RecordsStats(null);
        private Map<Integer, PointStats> dailyStats = new HashMap<Integer, PointStats>();
        private Map<Integer, PointStats> monthlyStats = new HashMap<Integer, PointStats>();
        private Map<Integer, PointStats> yearlyStats = new HashMap<Integer, PointStats>();
        private Date[] period;

        public RecordsStats(Date[] period) {
            this.period = period;
        }

        public void finalize() {
            this.monthlyStats = this.aggregateDailyStats(RecordsStatsParameters.TimeUnit.MONTH);
            this.yearlyStats = this.aggregateDailyStats(RecordsStatsParameters.TimeUnit.YEAR);
        }

        public PointStats getOrCreateDailyStats(Date date) {
            return this.getOrCreateStats(date, RecordsStatsParameters.TimeUnit.DAY, this.dailyStats);
        }

        private PointStats getOrCreateStats(Date date, RecordsStatsParameters.TimeUnit timeUnit, Map<Integer, PointStats> stats) {
            int key = this.generateKey(date, timeUnit);
            PointStats pointStats = stats.get(key);
            if (pointStats == null) {
                pointStats = new PointStats();
                stats.put(key, pointStats);
            }
            return pointStats;
        }

        private Map<Integer, PointStats> aggregateDailyStats(RecordsStatsParameters.TimeUnit unit) {
            HashMap<Integer, PointStats> result = new HashMap<Integer, PointStats>();
            Date periodStart = this.period[0];
            Date periodEnd = this.period[1];
            Date currentDate = periodStart;
            while (DateUtils.truncatedCompareTo((Date)currentDate, (Date)periodEnd, (int)5) <= 0) {
                PointStats dailyPointStats = this.getOrCreateStats(currentDate, RecordsStatsParameters.TimeUnit.DAY, this.dailyStats);
                PointStats unitPointStats = this.getOrCreateStats(currentDate, unit, result);
                unitPointStats.incrementAll(dailyPointStats);
                currentDate = DateUtils.addDays((Date)currentDate, (int)1);
            }
            return result;
        }

        private int generateKey(Date date, RecordsStatsParameters.TimeUnit unit) {
            Calendar cal = DateUtils.toCalendar((Date)date);
            switch (unit.ordinal()) {
                case 2: {
                    return cal.get(1);
                }
                case 1: {
                    return cal.get(1) * 100 + (cal.get(2) + 1);
                }
                case 0: {
                    return cal.get(1) * 100 * 100 + (cal.get(2) + 1) * 100 + cal.get(5);
                }
            }
            return 0;
        }

        public Date[] getPeriod() {
            return this.period;
        }

        public Map<Integer, PointStats> getDailyStats() {
            return this.dailyStats;
        }

        public Map<Integer, PointStats> getMonthlyStats() {
            return this.monthlyStats;
        }

        public Map<Integer, PointStats> getYearlyStats() {
            return this.yearlyStats;
        }
    }

    public static class PointStats {
        private int created;
        private int entered;
        private int cleansed;
        private int modified;

        public void incrementAll(PointStats currentDayStats) {
            this.entered += currentDayStats.entered;
            this.cleansed += currentDayStats.cleansed;
            this.created += currentDayStats.created;
            this.modified += currentDayStats.modified;
        }

        public void incrementCreated() {
            ++this.created;
        }

        public void incrementEntered() {
            ++this.entered;
        }

        public void incrementCleansed() {
            ++this.cleansed;
        }

        public void incrementModified() {
            ++this.modified;
        }

        public int getCreated() {
            return this.created;
        }

        public void setCreated(int created) {
            this.created = created;
        }

        public int getEntered() {
            return this.entered;
        }

        public void setEntered(int entered) {
            this.entered = entered;
        }

        public int getCleansed() {
            return this.cleansed;
        }

        public void setCleansed(int cleansed) {
            this.cleansed = cleansed;
        }

        public int getModified() {
            return this.modified;
        }

        public void setModified(int modified) {
            this.modified = modified;
        }
    }

    public static class RecordsStatsParameters {
        private TimeUnit timeUnit = TimeUnit.DAY;
        private Date from;
        private Date to;

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit unit) {
            this.timeUnit = unit;
        }

        public Date getFrom() {
            return this.from;
        }

        public void setFrom(Date from) {
            this.from = from;
        }

        public Date getTo() {
            return this.to;
        }

        public void setTo(Date to) {
            this.to = to;
        }

        public static enum TimeUnit {
            DAY,
            MONTH,
            YEAR;

        }
    }
}

