/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.geojson.GeoJsonObject;
import org.geojson.LngLatAlt;
import org.geojson.MultiPoint;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.dataexport.samplingdesign.SamplingDesignExportProcess;
import org.openforis.collect.metamodel.SamplingPointDataKmlGenerator;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectSurveyContext;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.model.Coordinate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SamplingPointsController
extends BasicController {
    private static final String SAMPLING_DESIGN_CSV_FILE_NAME = "sampling_points.csv";
    @Autowired
    private SamplingDesignManager samplingDesignManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CoordinateOperations coordinateOperations;

    @RequestMapping(value={"api/survey/{surveyId}/sampling_point_data"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SamplingDesignItem> loadSamplingPoints(@PathVariable int surveyId, @RequestParam(value="parent_keys", required=false) List<String> parentKeys, @RequestParam(value="only_parent_item", required=false, defaultValue="false") boolean onlyParentItem, @RequestParam(value="srs", required=false, defaultValue="EPSG:4326") String targetSrsId) {
        List<SamplingDesignItem> items;
        if (parentKeys == null || parentKeys.isEmpty()) {
            items = this.samplingDesignManager.loadChildItems(surveyId, new String[0]);
        } else if (onlyParentItem) {
            SamplingDesignItem item = this.samplingDesignManager.loadItem(surveyId, parentKeys);
            items = Arrays.asList(item);
        } else {
            items = this.samplingDesignManager.loadChildItems(surveyId, parentKeys);
        }
        return this.convertTo(items, targetSrsId);
    }

    @RequestMapping(value={"api/survey/{surveyId}/sampling_point_data.csv"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportWorkSamplingDesign(HttpServletResponse response, @PathVariable(value="surveyId") Integer surveyId) throws IOException {
        SamplingDesignExportProcess process = new SamplingDesignExportProcess(this.samplingDesignManager);
        ServletOutputStream out = response.getOutputStream();
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId.intValue());
        Controllers.setOutputContent(response, SAMPLING_DESIGN_CSV_FILE_NAME, "text/csv");
        process.exportToCSV((OutputStream)out, survey);
        return "ok";
    }

    @RequestMapping(value={"api/survey/{surveyId}/sampling_point_data"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public SamplingDesignItem updateSamplingPointItem(@PathVariable int surveyId, @RequestBody SamplingDesignItem item) {
        this.samplingDesignManager.save(item);
        return item;
    }

    @RequestMapping(value={"api/survey/{surveyId}/sampling_point_data.kml"}, method={RequestMethod.GET}, produces={"application/vnd.google-earth.kml+xml"})
    public void loadSamplingPointKmlData(@PathVariable int surveyId, HttpServletResponse response) throws Exception {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        SamplingPointDataKmlGenerator samplingPointDataKmlGenerator = new SamplingPointDataKmlGenerator(this.samplingDesignManager, survey);
        samplingPointDataKmlGenerator.generate();
        samplingPointDataKmlGenerator.write((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"api/survey/{surveyId}/sampling_point_data_features.json"}, method={RequestMethod.GET})
    @ResponseBody
    public FeatureCollection loadSamplingPointData(@PathVariable int surveyId) {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        return this.loadSamplingPointDataFeatures(survey);
    }

    private FeatureCollection loadSamplingPointDataFeatures(CollectSurvey survey) {
        FeatureCollection featureCollection = new FeatureCollection();
        Feature feature = new Feature();
        feature.setProperty("letter", (Object)"o");
        feature.setProperty("color", (Object)"blue");
        feature.setProperty("rank", (Object)"15");
        MultiPoint multiPoint = new MultiPoint();
        CoordinateOperations coordinateOperations = this.getCoordinateOperations(survey);
        List<SamplingDesignItem> samplingDesignItems = this.loadSamplingDesignItems(survey);
        for (SamplingDesignItem item : samplingDesignItems) {
            Coordinate coordinate = new Coordinate(item.getX(), item.getY(), item.getSrsId());
            multiPoint.add((Object)this.createLngLatAlt(coordinateOperations, coordinate));
        }
        feature.setGeometry((GeoJsonObject)multiPoint);
        featureCollection.add(feature);
        return featureCollection;
    }

    private List<SamplingDesignItem> loadSamplingDesignItems(CollectSurvey survey) {
        SamplingDesignSummaries samplingDesignSummaries = this.samplingDesignManager.loadBySurvey(survey.getId().intValue());
        List samplingDesignItems = samplingDesignSummaries.getRecords();
        ArrayList<SamplingDesignItem> result = new ArrayList<SamplingDesignItem>();
        for (SamplingDesignItem item : samplingDesignItems) {
            result.add(item);
        }
        return result;
    }

    private CoordinateOperations getCoordinateOperations(CollectSurvey survey) {
        CollectSurveyContext surveyContext = (CollectSurveyContext)survey.getContext();
        return surveyContext.getCoordinateOperations();
    }

    @RequestMapping(value={"survey/{surveyId}/sampling_point_bounds.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Bounds loadSamplingPointBounds(@PathVariable int surveyId) {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        CollectSurveyContext surveyContext = (CollectSurveyContext)survey.getContext();
        CoordinateOperations coordinateOperations = surveyContext.getCoordinateOperations();
        SamplingDesignSummaries samplingDesignSummaries = this.samplingDesignManager.loadBySurvey(survey.getId().intValue());
        List samplingDesignItems = samplingDesignSummaries.getRecords();
        Bounds bounds = new Bounds();
        for (SamplingDesignItem item : samplingDesignItems) {
            Coordinate coordinate = new Coordinate(item.getX(), item.getY(), item.getSrsId());
            LngLatAlt lngLatAlt = this.createLngLatAlt(coordinateOperations, coordinate);
            if (lngLatAlt == null) continue;
            if (bounds.topLeft == null) {
                bounds.topLeft = (bounds.topRight = (bounds.bottomLeft = (bounds.bottomRight = lngLatAlt)));
                continue;
            }
            if (lngLatAlt.getLatitude() < bounds.topLeft.getLatitude() && lngLatAlt.getLongitude() < bounds.topLeft.getLongitude()) {
                bounds.topLeft = lngLatAlt;
                continue;
            }
            if (lngLatAlt.getLatitude() < bounds.topRight.getLatitude() && lngLatAlt.getLongitude() > bounds.topRight.getLongitude()) {
                bounds.topRight = lngLatAlt;
                continue;
            }
            if (lngLatAlt.getLatitude() > bounds.bottomRight.getLatitude() && lngLatAlt.getLongitude() > bounds.bottomRight.getLongitude()) {
                bounds.bottomRight = lngLatAlt;
                continue;
            }
            if (!(lngLatAlt.getLatitude() > bounds.bottomLeft.getLatitude()) || !(lngLatAlt.getLongitude() > bounds.bottomLeft.getLongitude())) continue;
            bounds.bottomLeft = lngLatAlt;
        }
        return bounds;
    }

    private LngLatAlt createLngLatAlt(CoordinateOperations coordOpts, Coordinate coord) {
        try {
            Coordinate wgs84Coord = coordOpts.convertToWgs84(coord);
            LngLatAlt lngLatAlt = new LngLatAlt(wgs84Coord.getX().doubleValue(), wgs84Coord.getY().doubleValue());
            return lngLatAlt;
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<SamplingDesignItem> convertTo(List<SamplingDesignItem> items, String targetSrsId) {
        return items.stream().map(item -> {
            if (targetSrsId.equals(item.getSrsId())) {
                return item;
            }
            return this.convertTo((SamplingDesignItem)item, targetSrsId);
        }).collect(Collectors.toList());
    }

    private SamplingDesignItem convertTo(SamplingDesignItem item, String targetSrsId) {
        try {
            SamplingDesignItem newItem = new SamplingDesignItem();
            BeanUtils.copyProperties((Object)newItem, (Object)item);
            Coordinate newCoordinate = this.coordinateOperations.convertTo(item.getCoordinate(), targetSrsId);
            newItem.setCoordinate(newCoordinate);
            return newItem;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Bounds {
        private LngLatAlt topRight;
        private LngLatAlt topLeft;
        private LngLatAlt bottomRight;
        private LngLatAlt bottomLeft;

        private Bounds() {
        }
    }

    public static class SamplingPointSearchParameters {
        private List<String> parentKeys;
        private boolean onlyParentItem;

        public List<String> getParentKeys() {
            return this.parentKeys;
        }

        public void setParentKeys(List<String> parentKeys) {
            this.parentKeys = parentKeys;
        }

        public boolean isOnlyParentItem() {
            return this.onlyParentItem;
        }

        public void setOnlyParentItem(boolean onlyParentItem) {
            this.onlyParentItem = onlyParentItem;
        }
    }
}

