/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.List;
import java.util.UUID;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.json.JSONValueParser;
import org.openforis.collect.model.CollectRecord;
import org.openforis.idm.metamodel.AbstractPersistedObject;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Value;

public class DataQueryResultItem
extends AbstractPersistedObject<Integer> {
    private UUID uuid;
    private DataQuery query;
    private CollectRecord record;
    private int recordId;
    private int parentEntityId;
    private int nodeIndex;
    private String value;
    private Node<?> node;

    public DataQueryResultItem(DataQuery query) {
        this(query, UUID.randomUUID());
    }

    public DataQueryResultItem(DataQuery query, UUID uuid) {
        this.query = query;
        this.uuid = uuid;
    }

    public AttributeDefinition getAttributeDefinition() {
        Schema schema = this.query.getSchema();
        AttributeDefinition def = (AttributeDefinition)schema.getDefinitionById(this.query.getAttributeDefinitionId());
        return def;
    }

    public Value extractAttributeValue() {
        AttributeDefinition def = this.getAttributeDefinition();
        Value val = new JSONValueParser().parseValue(def, this.value);
        return val;
    }

    public List<String> getRecordKeyValues() {
        return this.record == null ? null : this.record.getRootEntityKeyValues();
    }

    public String extractNodePath() {
        Survey survey = this.record.getSurvey();
        NodeDefinition attrDefn = survey.getSchema().getDefinitionById(this.query.getAttributeDefinitionId());
        Entity parentEntity = (Entity)this.record.getNodeByInternalId(this.parentEntityId);
        String path = attrDefn.isMultiple() ? String.format("%s/%s[%d]", parentEntity.getPath(), attrDefn.getName(), this.nodeIndex + 1) : String.format("%s/%s", parentEntity.getPath(), attrDefn.getName());
        return path;
    }

    public DataQuery getQuery() {
        return this.query;
    }

    public CollectRecord getRecord() {
        return this.record;
    }

    public void setRecord(CollectRecord record) {
        this.record = record;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    public int getParentEntityId() {
        return this.parentEntityId;
    }

    public void setParentEntityId(int parentEntityId) {
        this.parentEntityId = parentEntityId;
    }

    public Node<?> getNode() {
        return this.node;
    }

    public void setNode(Node<?> node) {
        this.node = node;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

