/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Insert;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.DataReportItem;
import org.openforis.collect.datacleansing.persistence.DataReportDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.persistence.jooq.MappingJooqDaoSupport;
import org.openforis.collect.persistence.jooq.PersistedObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.tables.OfcDataReportItem;
import org.openforis.collect.persistence.jooq.tables.records.OfcDataReportItemRecord;
import org.openforis.idm.metamodel.PersistedObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataReportItemDao")
@Transactional
public class DataReportItemDao
extends MappingJooqDaoSupport<Integer, DataReportItem, JooqDSLContext> {
    private static Field<?>[] FIELDS = new Field[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.ID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.NODE_INDEX, OfcDataReportItem.OFC_DATA_REPORT_ITEM.PARENT_ENTITY_ID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.QUERY_ID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.STATUS, OfcDataReportItem.OFC_DATA_REPORT_ITEM.UUID, OfcDataReportItem.OFC_DATA_REPORT_ITEM.VALUE};

    public DataReportItemDao() {
        super(JooqDSLContext.class);
    }

    public List<DataReportItem> loadByReport(DataReport report) {
        return this.loadByReport(report, null, null);
    }

    public void deleteByReport(DataReport report) {
        this.dsl().delete((Table)OfcDataReportItem.OFC_DATA_REPORT_ITEM).where(new Condition[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID.eq((Object)report.getId())}).execute();
    }

    public void deleteBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = this.dsl();
        dsl.delete((Table)OfcDataReportItem.OFC_DATA_REPORT_ITEM).where(new Condition[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID.in(DataReportDao.createDataReportIdsBySurveyQuery((CollectDSLContext)dsl, survey))}).execute();
    }

    public int countItems(DataReport report) {
        JooqDSLContext dsl = this.dsl(report);
        SelectQuery q = dsl.selectCountQuery();
        q.addConditions(new Condition[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID.eq((Object)report.getId())});
        Record record = q.fetchOne();
        return (Integer)record.getValue(0);
    }

    public int countAffectedRecords(DataReport report) {
        JooqDSLContext dsl = this.dsl(report);
        SelectQuery subSelect = dsl.selectQuery();
        subSelect.addSelect(new SelectField[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID});
        subSelect.addFrom((TableLike)OfcDataReportItem.OFC_DATA_REPORT_ITEM);
        subSelect.addConditions(new Condition[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID.eq((Object)report.getId())});
        subSelect.addGroupBy(new GroupField[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID});
        subSelect.asTable("report_record");
        SelectQuery select = dsl.selectQuery();
        select.addSelect(new SelectField[]{DSL.count()});
        select.addFrom((TableLike)subSelect);
        Record record = select.fetchOne();
        return (Integer)record.getValue(0);
    }

    public List<DataReportItem> loadByReport(DataReport report, Integer offset, Integer limit) {
        JooqDSLContext dsl = this.dsl(report);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataReportItem.OFC_DATA_REPORT_ITEM).where(new Condition[]{OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID.eq((Object)report.getId())}).orderBy((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID);
        if (offset != null && limit != null) {
            select.limit(offset.intValue(), limit.intValue());
        }
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void insert(DataReport report, List<DataReportItem> items) {
        int nextId;
        JooqDSLContext dsl = this.dsl(report);
        int maxId = nextId = ((Integer)dsl.nextId()).intValue();
        Insert<OfcDataReportItemRecord> insert = dsl.createInsertStatement();
        BatchBindStep batch = dsl.batch((Query)insert);
        for (DataReportItem item : items) {
            Integer id = (Integer)item.getId();
            if (id == null) {
                id = nextId++;
                item.setId(id);
            }
            Object[] values = dsl.extractValues(item);
            batch.bind(values);
            maxId = Math.max(maxId, id);
        }
        batch.execute();
        dsl.restartSequence(maxId + 1);
    }

    protected JooqDSLContext dsl() {
        return this.dsl(null);
    }

    protected JooqDSLContext dsl(DataReport report) {
        return new JooqDSLContext(this.getConfiguration(), report);
    }

    protected static class JooqDSLContext
    extends PersistedObjectMappingDSLContext<Integer, DataReportItem> {
        private static final long serialVersionUID = 1L;
        private DataReport report;

        public JooqDSLContext(Configuration config, DataReport report) {
            super(config, OfcDataReportItem.OFC_DATA_REPORT_ITEM.ID, Sequences.OFC_DATA_REPORT_ITEM_ID_SEQ, DataReportItem.class);
            this.report = report;
        }

        protected DataReportItem newEntity() {
            throw new UnsupportedOperationException();
        }

        public DataReportItem fromRecord(Record r) {
            Integer queryId = (Integer)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.QUERY_ID);
            DataQueryGroup queryGroup = this.report.getQueryGroup();
            DataQuery dataQuery = queryGroup.getQuery(queryId);
            DataReportItem o = new DataReportItem(this.report, dataQuery);
            o.setId((Number)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.ID));
            o.setNodeIndex((Integer)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.NODE_INDEX));
            o.setParentEntityId((Integer)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.PARENT_ENTITY_ID));
            o.setRecordId((Integer)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID));
            o.setStatus(DataReportItem.Status.fromCode(((String)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.STATUS)).charAt(0)));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.UUID)));
            o.setValue((String)r.getValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.VALUE));
            return o;
        }

        protected void fromObject(DataReportItem o, StoreQuery<?> q) {
            super.fromObject((PersistedObject)o, q);
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.NODE_INDEX, (Object)o.getNodeIndex());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.PARENT_ENTITY_ID, (Object)o.getParentEntityId());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.QUERY_ID, (Object)o.getQuery().getId());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.RECORD_ID, (Object)o.getRecordId());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.REPORT_ID, (Object)o.getReport().getId());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.STATUS, (Object)String.valueOf(o.getStatus().getCode()));
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.UUID, (Object)o.getUuid().toString());
            q.addValue((Field)OfcDataReportItem.OFC_DATA_REPORT_ITEM.VALUE, (Object)o.getValue());
        }

        public Insert<OfcDataReportItemRecord> createInsertStatement() {
            Object[] valuesPlaceholders = new String[FIELDS.length];
            Arrays.fill(valuesPlaceholders, "?");
            return this.insertInto((Table)OfcDataReportItem.OFC_DATA_REPORT_ITEM, FIELDS).values(valuesPlaceholders);
        }

        public Object[] extractValues(DataReportItem item) {
            return new Object[]{item.getId(), item.getNodeIndex(), item.getParentEntityId(), item.getQuery().getId(), item.getRecordId(), item.getReport().getId(), Character.valueOf(item.getStatus().getCode()), item.getUuid(), item.getValue()};
        }
    }
}

