/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.flat.FlatRecord;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;

public class SchemaLabelsImportVM
extends BaseSurveyFileImportVM {
    private static final List<NodeLabel.Type> LABEL_TYPES = Arrays.asList(NodeLabel.Type.INSTANCE, NodeLabel.Type.REPORTING);
    private static final String CLOSE_POP_UP_GLOBAL_COMMAND = "closeSchemaLabelsImportPopUp";
    private static final String IMPORT_IMPORT_COMPLETE_MESSAGE_KEY = "survey.schema.labels_import.import_complete";
    private static final String MISSING_COLUMN_MESSAGE_KEY = "survey.schema.labels_import.error.missing_column";
    private static final String MISSING_NODE_DEF_ID_MESSAGE_KEY = "survey.schema.labels_import.error.missing_node_def_id";
    private static final String MISSING_NODE_DEF_MESSAGE_KEY = "survey.schema.labels_import.error.missing_node_def";
    private static final String MISSING_LABEL_DEFAULT_LANG_MESSAGE_KEY = "survey.schema.labels_import.error.missing_label_default_lang";

    public SchemaLabelsImportVM() {
        super(new String[]{"csv", "xlsx"}, null);
        this.reset();
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Command
    public void startImport(@ContextParam(value=ContextType.BIND_CONTEXT) BindContext ctx) {
        Map<Integer, List<NodeLabel>> labelsByNodeDefId;
        if (this.validateForm(ctx) && (labelsByNodeDefId = new LabelsExtractor(this.uploadedFile, (Survey)this.survey).extractLabelsByNodeDefId()) != null) {
            new LabelsImporter(labelsByNodeDefId, (Survey)this.survey).importLabels();
            MessageUtil.showInfo(IMPORT_IMPORT_COMPLETE_MESSAGE_KEY, labelsByNodeDefId.size());
            this.dispatchSchemaChangedCommand();
            this.close();
        }
    }

    @Command
    public void close() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_POP_UP_GLOBAL_COMMAND, null);
    }

    private static class LabelsExtractor {
        private File file;
        private Survey survey;

        public LabelsExtractor(File file, Survey survey) {
            this.file = file;
            this.survey = survey;
        }

        public Map<Integer, List<NodeLabel>> extractLabelsByNodeDefId() {
            HashMap<Integer, List<NodeLabel>> hashMap;
            HashMap<Integer, List<NodeLabel>> result = new HashMap<Integer, List<NodeLabel>>();
            CsvReader reader = null;
            try {
                reader = new CsvReader(this.file);
                reader.readHeaders();
                List columnNames = reader.getColumnNames();
                this.validateColumnNames(columnNames);
                boolean errorFound = false;
                FlatRecord row = reader.nextRecord();
                while (row != null) {
                    if (!this.validateRow(reader.getLinesRead() + 1L, row, this.survey.getDefaultLanguage())) {
                        errorFound = true;
                        break;
                    }
                    ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
                    List languages = this.survey.getLanguages();
                    Integer nodeDefId = (Integer)row.getValue("id", Integer.class);
                    for (NodeLabel.Type type : LABEL_TYPES) {
                        for (String lang : languages) {
                            String labelColName = LabelsExtractor.getColumnPrefix(type) + "_" + lang;
                            if (!columnNames.contains(labelColName)) continue;
                            String text = (String)row.getValue(labelColName, String.class);
                            labels.add(new NodeLabel(type, lang, text));
                        }
                    }
                    result.put(nodeDefId, labels);
                    row = reader.nextRecord();
                }
                hashMap = errorFound ? null : result;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            return hashMap;
        }

        private boolean validateRow(long rowNumber, FlatRecord row, String defaultLanguage) {
            Integer nodeDefId = (Integer)row.getValue("id", Integer.class);
            if (nodeDefId == null) {
                this.handleError(SchemaLabelsImportVM.MISSING_NODE_DEF_ID_MESSAGE_KEY, new Long[]{rowNumber});
                return false;
            }
            if (!this.survey.getSchema().containsDefinitionWithId(nodeDefId.intValue())) {
                this.handleError(SchemaLabelsImportVM.MISSING_NODE_DEF_MESSAGE_KEY, new Integer[]{nodeDefId});
                return false;
            }
            String defaultLangLabelColName = LabelsExtractor.getColumnPrefix(NodeLabel.Type.INSTANCE) + "_" + defaultLanguage;
            String defaultLangLabel = (String)row.getValue(defaultLangLabelColName, String.class);
            if (StringUtils.isBlank((CharSequence)defaultLangLabel)) {
                this.handleError(SchemaLabelsImportVM.MISSING_LABEL_DEFAULT_LANG_MESSAGE_KEY, new Object[]{rowNumber, defaultLangLabelColName});
                return false;
            }
            return true;
        }

        private void validateColumnNames(List<String> columnNames) {
            ArrayList<String> requiredColumnNames = new ArrayList<String>();
            requiredColumnNames.add("id");
            requiredColumnNames.add(LabelsExtractor.getColumnPrefix(NodeLabel.Type.INSTANCE) + "_" + this.survey.getDefaultLanguage());
            for (String colName : requiredColumnNames) {
                if (columnNames.contains(colName)) continue;
                this.handleError(SchemaLabelsImportVM.MISSING_COLUMN_MESSAGE_KEY, new String[]{colName, ((Object)requiredColumnNames).toString()});
                return;
            }
        }

        private static String getColumnPrefix(NodeLabel.Type type) {
            switch (type) {
                case INSTANCE: {
                    return "label";
                }
            }
            return "label_" + type.name().toLowerCase(Locale.ENGLISH);
        }

        private void handleError(String messageKey, Object[] args) {
            MessageUtil.showError(messageKey, args);
        }
    }

    private static class LabelsImporter {
        private Map<Integer, List<NodeLabel>> labelsByNodeDefId = new HashMap<Integer, List<NodeLabel>>();
        private Survey survey;

        public LabelsImporter(Map<Integer, List<NodeLabel>> labelsByNodeDefId, Survey survey) {
            this.labelsByNodeDefId = labelsByNodeDefId;
            this.survey = survey;
        }

        public void importLabels() {
            Schema schema = this.survey.getSchema();
            for (Map.Entry<Integer, List<NodeLabel>> entry : this.labelsByNodeDefId.entrySet()) {
                int nodeDefId = entry.getKey();
                NodeDefinition nodeDef = schema.getDefinitionById(nodeDefId);
                List<NodeLabel> labels = entry.getValue();
                for (NodeLabel nodeLabel : labels) {
                    String text = StringUtils.trimToNull((String)nodeLabel.getText());
                    NodeLabel.Type type = (NodeLabel.Type)nodeLabel.getType();
                    String language = nodeLabel.getLanguage();
                    if (text == null) {
                        nodeDef.removeLabel(type, language);
                        continue;
                    }
                    nodeDef.setLabel(type, language, text);
                }
            }
        }
    }
}

