/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.PageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyExportParametersVM;
import org.openforis.collect.designer.viewmodel.SurveyValidationResultsVM;
import org.openforis.collect.io.data.CSVDataExportJob;
import org.openforis.collect.io.data.csv.CSVDataExportParameters;
import org.openforis.collect.io.metadata.SchemaSummaryCSVExportJob;
import org.openforis.collect.io.metadata.collectearth.CollectEarthGridTemplateGenerator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zkplus.databind.BindingListModelList;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class SurveyEditVM
extends SurveyBaseVM {
    private static final Log log = Log.lookup(SurveyEditVM.class);
    public static final String SHOW_PREVIEW_POP_UP_GLOBAL_COMMAND = "showPreview";
    public static final String BACKGROUD_SAVE_GLOBAL_COMMAND = "backgroundSurveySave";
    private static final String CODE_LISTS_POP_UP_CLOSED_COMMAND = "codeListsPopUpClosed";
    private static final String SCHEMA_SUMMARY_FILE_NAME_PATTERN = "%s_schema_summary_%s.%s";
    private static final String DATA_IMPORT_TEMPLATE_FILE_NAME_PATTERN = "%s_data_import_template_%s.%s";
    private Window selectLanguagePopUp;
    private Window previewPreferencesPopUp;
    private Window srsPopUp;
    private Window codeListsPopUp;
    private Window unitsPopUp;
    private Window versioningPopUp;
    private Window schemaLabelsImportPopUp;
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private SurveyValidator surveyValidator;
    @WireVariable
    private CollectEarthSurveyValidator collectEarthSurveyValidator;
    @WireVariable
    private AppWS appWS;
    private boolean changed;
    private Window jobStatusPopUp;
    private CollectRecord.Step previewStep;

    public static void redirectToSurveyEditPage(int surveyId) {
        Executions.sendRedirect((String)(Resources.Page.SURVEY_EDIT.getLocation() + "?id=" + surveyId));
    }

    public static void dispatchSurveySaveCommand() {
        BindUtils.postGlobalCommand(null, null, (String)BACKGROUD_SAVE_GLOBAL_COMMAND, null);
    }

    @Init(superclass=false)
    public void init(@QueryParam(value="id") Integer surveyId) {
        super.init();
        this.survey = this.surveyManager.loadSurvey(surveyId.intValue());
        if (this.survey == null || !this.survey.isTemporary()) {
            this.backToSurveysList();
        } else {
            SessionStatus sessionStatus = this.getSessionStatus();
            Integer publishedSurveyId = null;
            if (this.survey.isPublished()) {
                publishedSurveyId = this.survey.isTemporary() ? this.survey.getPublishedId() : this.survey.getId();
            }
            sessionStatus.setPublishedSurveyId(publishedSurveyId);
            sessionStatus.setSurvey(this.survey);
            this.changed = false;
            this.currentLanguageCode = this.survey.getDefaultLanguage();
            if (this.currentLanguageCode == null) {
                this.openLanguageManagerPopUp();
            } else {
                sessionStatus.setCurrentLanguageCode(this.currentLanguageCode);
            }
            String confirmCloseMessage = Labels.getLabel((String)"survey.edit.leave_page");
            PageUtil.confirmClose(confirmCloseMessage);
        }
    }

    @Command
    public void openLanguageManagerPopUp() {
        if (this.checkCanLeaveForm()) {
            this.selectLanguagePopUp = SurveyEditVM.openPopUp(Resources.Component.SELECT_LANGUAGE_POP_UP.getLocation(), true);
        }
    }

    @Command
    public void openSchemaLabelsImportPopUp() {
        if (this.checkCanLeaveForm()) {
            this.schemaLabelsImportPopUp = SurveyEditVM.openPopUp(Resources.Component.SCHEMA_LABELS_IMPORT_POP_UP.getLocation(), true);
        }
    }

    @GlobalCommand
    public void closeSchemaLabelsImportPopUp() {
        SurveyEditVM.closePopUp(this.schemaLabelsImportPopUp);
        this.schemaLabelsImportPopUp = null;
    }

    @Command
    public void openSchemaAttributesImportPopUp() {
        if (this.checkCanLeaveForm()) {
            SurveyEditVM.openPopUp(Resources.Component.SCHEMA_ATTRIBUTES_IMPORT_POP_UP.getLocation(), true);
        }
    }

    @GlobalCommand
    public void openSRSManagerPopUp() {
        if (this.checkCanLeaveForm()) {
            this.srsPopUp = SurveyEditVM.openPopUp(Resources.Component.SRS_MANAGER_POP_UP.getLocation(), true);
        }
    }

    @GlobalCommand
    public void closeSRSManagerPopUp() {
        SurveyEditVM.closePopUp(this.srsPopUp);
        this.srsPopUp = null;
        this.dispatchCurrentFormValidatedCommand(true);
    }

    @GlobalCommand
    public void openCodeListsManagerPopUp(@BindingParam(value="editingAttribute") Boolean editingAttribute, @BindingParam(value="selectedCodeList") CodeList selectedCodeList) {
        if (this.codeListsPopUp == null) {
            this.dispatchCurrentFormValidatedCommand(true);
            HashMap<String, Boolean> args = new HashMap<String, Boolean>();
            args.put("editingAttribute", editingAttribute);
            CodeList selectedCodeListInPopUp = selectedCodeList == this.survey.getSamplingDesignCodeList() ? null : selectedCodeList;
            args.put("selectedCodeList", (Boolean)selectedCodeListInPopUp);
            this.codeListsPopUp = SurveyEditVM.openPopUp(Resources.Component.CODE_LISTS_POPUP.getLocation(), true, args);
        }
    }

    @GlobalCommand
    public void closeCodeListsManagerPopUp(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="editingAttribute") Boolean editingAttribute, @BindingParam(value="selectedCodeList") CodeList selectedCodeList) {
        if (this.codeListsPopUp != null) {
            SurveyEditVM.closePopUp(this.codeListsPopUp);
            this.codeListsPopUp = null;
            this.dispatchCurrentFormValidatedCommand(true);
            this.dispatchCodeListsPopUpClosedCommand(editingAttribute, selectedCodeList);
        }
    }

    public void dispatchCodeListsPopUpClosedCommand(Boolean editingAttribute, CodeList selectedCodeList) {
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("editingAttribute", editingAttribute);
        args.put("selectedCodeList", (Boolean)selectedCodeList);
        BindUtils.postGlobalCommand(null, null, (String)CODE_LISTS_POP_UP_CLOSED_COMMAND, args);
    }

    @GlobalCommand
    public void openUnitsManagerPopUp() {
        if (this.unitsPopUp == null) {
            this.dispatchCurrentFormValidatedCommand(true);
            this.unitsPopUp = SurveyEditVM.openPopUp(Resources.Component.UNITS_MANAGER_POP_UP.getLocation(), true);
        }
    }

    @GlobalCommand
    public void closeUnitsManagerPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.unitsPopUp != null) {
            SurveyEditVM.closePopUp(this.unitsPopUp);
            this.unitsPopUp = null;
            this.dispatchCurrentFormValidatedCommand(true);
        }
    }

    @GlobalCommand
    public void openVersioningManagerPopUp() {
        if (this.versioningPopUp == null) {
            this.dispatchCurrentFormValidatedCommand(true);
            this.versioningPopUp = SurveyEditVM.openPopUp(Resources.Component.VERSIONING_POPUP.getLocation(), true);
        }
    }

    @GlobalCommand
    public void closeVersioningManagerPopUp() {
        if (this.versioningPopUp != null) {
            SurveyEditVM.closePopUp(this.versioningPopUp);
            this.versioningPopUp = null;
            this.dispatchCurrentFormValidatedCommand(true);
        }
    }

    @Command
    public void backToSurveysList() {
        if (this.changed) {
            MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    SurveyEditVM.this.performBackToSurveysList();
                }
            }, "survey.edit.leave_page_with_unsaved_changes");
            params.setTitleKey("global.unsaved_changes");
            params.setOkLabelKey("global.continue_and_loose_changes");
            params.setCancelLabelKey("global.stay_on_this_page");
            MessageUtil.showConfirm(params);
        } else {
            this.performBackToSurveysList();
        }
    }

    protected void performBackToSurveysList() {
        PageUtil.clearConfirmClose();
        this.resetSessionStatus();
        this.showMainPage();
    }

    protected void showMainPage() {
        Executions.sendRedirect((String)Resources.Page.DESIGNER.getLocation());
    }

    protected void resetSessionStatus() {
        SessionStatus sessionStatus = this.getSessionStatus();
        sessionStatus.reset();
    }

    public List<String> getAvailableLanguages() {
        CollectSurvey survey = this.getSurvey();
        if (survey == null) {
            return null;
        }
        List languages = survey.getLanguages();
        return new BindingListModelList(languages, false);
    }

    @Command
    @NotifyChange(value={"currentLanguageCode"})
    public void languageCodeSelected(final @BindingParam(value="code") String selectedLanguageCode) {
        final SessionStatus sessionStatus = this.getSessionStatus();
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                sessionStatus.setCurrentLanguageCode(selectedLanguageCode);
                BindUtils.postGlobalCommand(null, null, (String)"currentLanguageChanged", null);
                SurveyEditVM.this.currentLanguageCode = sessionStatus.getCurrentLanguageCode();
            }
        });
    }

    @Command
    public boolean save(@ContextParam(value=ContextType.BINDER) Binder binder, Runnable runAfterSave) throws SurveyStoreException {
        this.dispatchValidateAllCommand();
        if (this.checkCanSave()) {
            return this.checkValidity(true, () -> {
                try {
                    this.backgroundSurveySave();
                    if (runAfterSave != null) {
                        runAfterSave.run();
                    }
                }
                catch (SurveyStoreException e) {
                    throw new RuntimeException(e);
                }
            }, Labels.getLabel((String)"survey.save.confirm_save_with_errors"), true);
        }
        return false;
    }

    @GlobalCommand
    public void backgroundSurveySave() throws SurveyStoreException {
        this.surveyManager.save(this.survey);
        BindUtils.postNotifyChange(null, null, (Object)this.survey, (String)"id");
        BindUtils.postNotifyChange(null, null, (Object)this.survey, (String)"published");
        this.changed = false;
        this.notifyChange("surveyStored", "surveyId", "surveyPublished", "surveyChanged");
        this.dispatchSurveySavedCommand();
        this.appWS.sendMessage(AppWS.MessageType.SURVEYS_UPDATED);
    }

    private void dispatchSurveySavedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)"surveySaved", null);
    }

    protected boolean checkCanSave() {
        if (this.checkCanLeaveForm()) {
            if (!this.checkSurveyNameUniqueness()) {
                return false;
            }
            return this.checkSurveyUriUniqueness();
        }
        return false;
    }

    private boolean checkSurveyNameUniqueness() {
        SurveySummary existingSurveySummary = this.surveyManager.loadSummaryByName(this.survey.getName());
        if (existingSurveySummary != null && !this.isCurrentEditedSurvey(existingSurveySummary)) {
            String messageKey = "survey.save.error.duplicate_name";
            MessageUtil.showWarning(messageKey, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkSurveyUriUniqueness() {
        SurveySummary existingSurveySummary = this.surveyManager.loadSummaryByUri(this.survey.getUri());
        if (existingSurveySummary != null && !this.isCurrentEditedSurvey(existingSurveySummary)) {
            String messageKey = "survey.save.error.duplicate_uri";
            MessageUtil.showWarning(messageKey, new Object[0]);
            return false;
        }
        return true;
    }

    @Command
    public void validate() {
        this.checkValidity(false, () -> MessageUtil.showInfo("survey.successfully_validated", new Object[0]), null, false);
    }

    private boolean checkValidity(boolean showConfirm, final Runnable runIfValid, String confirmButtonLabel, boolean ignoreWarnings) {
        SurveyValidator surveyValidator = this.getSurveyValidator(this.survey);
        SurveyValidator.ValidationParameters validationParameters = new SurveyValidator.ValidationParameters();
        validationParameters.setWarningsIgnored(ignoreWarnings);
        SurveyValidator.SurveyValidationResults results = surveyValidator.validate(this.survey, validationParameters);
        if (results.hasErrors() || results.hasWarnings()) {
            final Window validationResultsPopUp = SurveyValidationResultsVM.showPopUp(results, showConfirm, confirmButtonLabel);
            validationResultsPopUp.addEventListener("onConfirm", (EventListener)new EventListener<SurveyValidationResultsVM.ConfirmEvent>(){

                public void onEvent(SurveyValidationResultsVM.ConfirmEvent event) throws Exception {
                    runIfValid.run();
                    BaseVM.closePopUp(validationResultsPopUp);
                }
            });
            return false;
        }
        runIfValid.run();
        return true;
    }

    @Command
    public void exportSchemaSummary() {
        SchemaSummaryCSVExportJob job = new SchemaSummaryCSVExportJob();
        job.setJobManager((JobManager)this.jobManager);
        job.setSurvey(this.survey);
        this.jobManager.start((Job)job, this.survey.getId().toString());
        String statusPopUpTitle = Labels.getLabel((String)"survey.schema.export_summary.process_status_popup.message", (Object[])new String[]{this.survey.getName()});
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp(statusPopUpTitle, job, true);
    }

    @Command
    public void exportCsvDataImportTemplate() throws IOException {
        CSVDataExportJob job = (CSVDataExportJob)this.jobManager.createJob(CSVDataExportJob.class);
        job.setOutputFile(File.createTempFile("data-import-template", ".zip"));
        CSVDataExportParameters parameters = new CSVDataExportParameters();
        EntityDefinition rootEntityDef = this.survey.getSchema().getFirstRootEntityDefinition();
        RecordFilter recordFilter = new RecordFilter(this.survey, Integer.valueOf(rootEntityDef.getId()));
        parameters.setRecordFilter(recordFilter);
        parameters.setAlwaysGenerateZipFile(true);
        parameters.setIncludeEnumeratedEntities(false);
        job.setParameters(parameters);
        this.jobManager.start((Job)job, false);
        if (!job.isCompleted()) {
            throw new RuntimeException("Error generating the CSV data export template: " + job.getErrorMessage(), job.getLastException());
        }
        File outputFile = job.getOutputFile();
        String dateStr = Dates.formatLocalDateTime((Date)new Date());
        String fileName = String.format(DATA_IMPORT_TEMPLATE_FILE_NAME_PATTERN, this.survey.getName(), dateStr, "zip");
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        FileInputStream is = new FileInputStream(outputFile);
        Filedownload.save((InputStream)is, (String)contentType, (String)fileName);
    }

    @Command
    public void exportCeCsvDataImportTemplate() throws IOException {
        CSVDataExportJob job = (CSVDataExportJob)this.jobManager.createJob(CSVDataExportJob.class);
        job.setOutputFile(File.createTempFile("ce-data-import-template-" + this.survey.getName(), ".csv"));
        RecordFilter recordFilter = new RecordFilter(this.survey);
        EntityDefinition rootEntityDef = this.survey.getSchema().getFirstRootEntityDefinition();
        recordFilter.setRootEntityId(Integer.valueOf(rootEntityDef.getId()));
        CSVDataExportParameters parameters = new CSVDataExportParameters();
        parameters.setRecordFilter(recordFilter);
        parameters.setEntityId(Integer.valueOf(rootEntityDef.getId()));
        parameters.setAlwaysGenerateZipFile(false);
        parameters.setIncludeEnumeratedEntities(true);
        job.setParameters(parameters);
        this.jobManager.start((Job)job, false);
        if (!job.isCompleted()) {
            throw new RuntimeException("Error generating the CSV data export template: " + job.getErrorMessage(), job.getLastException());
        }
        File outputFile = job.getOutputFile();
        String dateStr = Dates.formatLocalDateTime((Date)new Date());
        String fileName = String.format(DATA_IMPORT_TEMPLATE_FILE_NAME_PATTERN, this.survey.getName(), dateStr, "csv");
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        FileInputStream is = new FileInputStream(outputFile);
        Filedownload.save((InputStream)is, (String)contentType, (String)fileName);
    }

    @Command
    public void exportSurvey() throws IOException {
        SurveyExportParametersVM.openPopUp(SurveySummary.createFromSurvey((CollectSurvey)this.survey));
    }

    @Command
    public void exportCEGridTemplate() throws IOException {
        File templateFile = new CollectEarthGridTemplateGenerator().generateTemplateCSVFile(this.survey);
        String fileName = String.format("%s_grid_template_%s.csv", this.survey.getName(), Dates.formatDateTime((Date)new Date()));
        Filedownload.save((InputStream)new FileInputStream(templateFile), (String)"text/csv", (String)fileName);
    }

    @GlobalCommand
    public void jobCompleted(@BindingParam(value="job") Job job) {
        this.closeJobStatusPopUp();
        if (job instanceof SchemaSummaryCSVExportJob) {
            File file = ((SchemaSummaryCSVExportJob)job).getOutputFile();
            String surveyName = this.survey.getName();
            String dateStr = Dates.formatLocalDateTime((Date)new Date());
            String fileName = String.format(SCHEMA_SUMMARY_FILE_NAME_PATTERN, surveyName, dateStr, "xlsx");
            String contentType = URLConnection.guessContentTypeFromName(fileName);
            try {
                FileInputStream is = new FileInputStream(file);
                Filedownload.save((InputStream)is, (String)contentType, (String)fileName);
            }
            catch (FileNotFoundException e) {
                log.error((Throwable)e);
                MessageUtil.showError("survey.schema.export_summary.error", e.getMessage());
            }
        }
    }

    private void closeJobStatusPopUp() {
        SurveyEditVM.closePopUp(this.jobStatusPopUp);
        this.jobStatusPopUp = null;
    }

    private void openPreviewPopUp() {
        if (this.isSingleRootEntityDefined() && this.survey.getVersions().size() <= 1) {
            ModelVersion version = this.survey.getVersions().isEmpty() ? null : (ModelVersion)this.survey.getVersions().get(0);
            this.openPreviewPopUp(version, this.survey.getSchema().getFirstRootEntityDefinition());
        } else {
            this.openPreviewPreferencesPopUp();
        }
    }

    @GlobalCommand
    public void openPreviewPopUp(@BindingParam(value="formVersion") ModelVersion formVersion, @BindingParam(value="rootEntity") EntityDefinition rootEntity) {
        if (this.validateShowPreview(rootEntity, formVersion)) {
            if (rootEntity == null) {
                rootEntity = this.survey.getSchema().getFirstRootEntityDefinition();
            }
            this.survey.refreshSurveyDependencies();
            if (this.survey.getTarget() == SurveyTarget.COLLECT_EARTH) {
                SurveyEditVM.openPopUp(Resources.Component.COLLECT_EARTH_PREVIEW_POPUP.getLocation(), true);
            } else {
                Map<String, String> params = this.createBasicModuleParameters();
                params.put("preview", "true");
                params.put("surveyId", Integer.toString(this.survey.getId()));
                params.put("work", "true");
                params.put("rootEntityId", Integer.toString(rootEntity.getId()));
                if (formVersion != null) {
                    params.put("versionId", Integer.toString(formVersion.getId()));
                }
                params.put("recordStep", this.previewStep.name());
                SurveyEditVM.openPopUp(Resources.Component.PREVIEW_POP_UP.getLocation(), true, params);
                this.closePreviewPreferencesPopUp();
            }
        }
    }

    protected boolean validateShowPreview(EntityDefinition rootEntityDefn, ModelVersion version) {
        if (rootEntityDefn == null && !this.isSingleRootEntityDefined()) {
            MessageUtil.showWarning("survey.preview.preferences.error.root_entity_not_specified", new Object[0]);
            return false;
        }
        if (version == null && this.survey.getVersions() != null && !this.survey.getVersions().isEmpty()) {
            MessageUtil.showWarning("survey.preview.preferences.error.version_not_specified", new Object[0]);
            return false;
        }
        return true;
    }

    @Command
    public void showDataEntryPreview() throws SurveyStoreException {
        this.showPreview(CollectRecord.Step.ENTRY);
    }

    @Command
    public void showDataCleansingPreview() throws SurveyStoreException {
        this.showPreview(CollectRecord.Step.CLEANSING);
    }

    public void showPreview(CollectRecord.Step recordStep) throws SurveyStoreException {
        if (!this.checkCanLeaveForm()) {
            return;
        }
        this.previewStep = recordStep;
        if (this.survey.getId() == null || this.changed) {
            this.save(null, this::openPreviewPopUp);
        } else {
            this.checkValidity(true, this::openPreviewPopUp, Labels.getLabel((String)"survey.preview.show_preview"), true);
        }
    }

    protected void openPreviewPreferencesPopUp() {
        this.previewPreferencesPopUp = SurveyEditVM.openPopUp(Resources.Component.PREVIEW_PREFERENCES_POP_UP.getLocation(), true);
    }

    @GlobalCommand
    public void closePreviewPreferencesPopUp() {
        SurveyEditVM.closePopUp(this.previewPreferencesPopUp);
        this.previewPreferencesPopUp = null;
    }

    @Override
    @GlobalCommand
    public void surveyChanged() {
        this.changed = true;
        this.notifyChange("surveyChanged");
    }

    @GlobalCommand
    @NotifyChange(value={"availableLanguages"})
    public void surveyLanguagesChanged() {
        this.closeSurveyLanguageSelectPopUp();
    }

    @GlobalCommand
    public void closeSurveyLanguageSelectPopUp() {
        SurveyEditVM.closePopUp(this.selectLanguagePopUp);
        this.selectLanguagePopUp = null;
    }

    @Override
    public boolean isSurveyChanged() {
        return this.changed;
    }

    @DependsOn(value={"surveyId", "surveyPublished"})
    public String getSamplingDesignImportModuleUrl() {
        Map<String, String> queryParams = this.createBasicModuleParameters();
        queryParams.put("sampling_design_import", "true");
        String url = ComponentUtil.createUrl(Resources.Page.COLLECT_SWF.getLocation(), queryParams);
        return url;
    }

    @DependsOn(value={"surveyId", "surveyPublished"})
    public String getSpeciesImportModuleUrl() {
        Map<String, String> queryParams = this.createBasicModuleParameters();
        queryParams.put("species_import", "true");
        String url = ComponentUtil.createUrl(Resources.Page.COLLECT_SWF.getLocation(), queryParams);
        return url;
    }

    private SurveyValidator getSurveyValidator(CollectSurvey survey) {
        return survey.getTarget() == SurveyTarget.COLLECT_EARTH ? this.collectEarthSurveyValidator : this.surveyValidator;
    }
}

