/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.ws;

import java.util.Timer;
import java.util.TimerTask;
import org.openforis.collect.web.ws.WebSocketMessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppWS {
    @Autowired
    private WebSocketMessageSender messageSender;

    public void sendMessage(MessageType type) {
        this.sendMessage(type, 0);
    }

    public void sendMessage(MessageType type, int delay) {
        this.sendMessage(new WebSocketMessageSender.Message(type.name()), delay);
    }

    public void sendMessage(WebSocketMessageSender.Message message) {
        this.sendMessage(message, 0);
    }

    public void sendMessage(final WebSocketMessageSender.Message message, int delay) {
        if (delay > 0) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    AppWS.this.messageSender.send(message);
                }
            }, delay);
        } else {
            this.messageSender.send(message);
        }
    }

    public static class RecordUpdateErrorMessage
    extends WebSocketMessageSender.Message {
        private String message;
        private String stackTrace;

        public RecordUpdateErrorMessage(String message, String stackTrace) {
            super(MessageType.RECORD_UPDATE_ERROR.name());
            this.message = message;
            this.stackTrace = stackTrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }
    }

    public static class RecordEventMessage
    extends WebSocketMessageSender.Message {
        private Object event;

        public RecordEventMessage(Object event) {
            super(MessageType.RECORD_UPDATED.name());
            this.event = event;
        }

        public Object getEvent() {
            return this.event;
        }
    }

    public static class RecordUnlockedMessage
    extends RecordMessage {
        public RecordUnlockedMessage(int recordId) {
            super(MessageType.RECORD_UNLOCKED, recordId);
        }
    }

    public static class RecordLockedMessage
    extends RecordMessage {
        private String lockedBy;

        public RecordLockedMessage(int recordId, String lockedBy) {
            super(MessageType.RECORD_LOCKED, recordId);
            this.lockedBy = lockedBy;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }
    }

    private static abstract class RecordMessage
    extends WebSocketMessageSender.Message {
        private Integer recordId;

        public RecordMessage(MessageType type, int recordId) {
            super(type.name());
            this.recordId = recordId;
        }

        public Integer getRecordId() {
            return this.recordId;
        }
    }

    public static class SurveyMessage
    extends WebSocketMessageSender.Message {
        private int surveyId;

        public SurveyMessage(MessageType messageType, int surveyId) {
            super(messageType.name());
            this.surveyId = surveyId;
        }

        public int getSurveyId() {
            return this.surveyId;
        }
    }

    public static enum MessageType {
        SURVEYS_UPDATED,
        SURVEY_UPDATED,
        SURVEY_PUBLISHED,
        SURVEY_UNPUBLISHED,
        SURVEY_DELETED,
        RECORD_LOCKED,
        RECORD_UNLOCKED,
        RECORD_UPDATED,
        RECORD_UPDATE_ERROR;

    }
}

