/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.io.metadata.SchemaSummaryCSVExportJob;
import org.openforis.collect.utils.Dates;
import org.openforis.commons.io.flat.FlatRecord;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class SchemaLabelsImportVM
extends BaseSurveyFileImportVM {
    private static final List<NodeLabel.Type> LABEL_TYPES = Arrays.asList(NodeLabel.Type.INSTANCE, NodeLabel.Type.REPORTING);
    private static final String CLOSE_POP_UP_GLOBAL_COMMAND = "closeSchemaLabelsImportPopUp";
    private static final String EXPORT_JOB_STATUS_POPUP_MESSAGE = "survey.schema.labels_export.job_status_popup.message";
    private static final String LABELS_EXPORT_ERROR = "survey.schema.labels_export.error";
    private static final String IMPORT_COMPLETE_MESSAGE_KEY = "survey.schema.labels_import.import_complete";
    private static final String INVALID_COLUMN_NAME_MESSAGE_KEY = "survey.schema.labels_import.error.invalid_column_name";
    private static final String MISSING_COLUMN_MESSAGE_KEY = "survey.schema.labels_import.error.missing_column";
    private static final String MISSING_NODE_DEF_ID_MESSAGE_KEY = "survey.schema.labels_import.error.missing_node_def_id";
    private static final String MISSING_NODE_DEF_MESSAGE_KEY = "survey.schema.labels_import.error.missing_node_def";
    private static final String MISSING_LABEL_DEFAULT_LANG_MESSAGE_KEY = "survey.schema.labels_import.error.missing_label_default_lang";
    private static final String SCHEMA_LABELS_FILE_NAME_PATTERN = "%s_schema_labels_%s.%s";
    private Window labelsExportJobStatusPopUp;

    public SchemaLabelsImportVM() {
        super(new String[]{"csv", "xlsx"}, null);
        this.reset();
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Command
    public void download() {
        SchemaSummaryCSVExportJob job = new SchemaSummaryCSVExportJob();
        job.setJobManager((JobManager)this.jobManager);
        job.setSurvey(this.survey);
        job.setOnlyLabels(true);
        this.jobManager.start((Job)job, this.survey.getId().toString());
        String statusPopUpTitle = Labels.getLabel((String)EXPORT_JOB_STATUS_POPUP_MESSAGE, (Object[])new String[]{this.survey.getName()});
        this.labelsExportJobStatusPopUp = JobStatusPopUpVM.openPopUp(statusPopUpTitle, job, true, new JobStatusPopUpVM.JobEndHandler<SchemaSummaryCSVExportJob>(){

            @Override
            public void onJobEnd(SchemaSummaryCSVExportJob job) {
                BaseVM.closePopUp(SchemaLabelsImportVM.this.labelsExportJobStatusPopUp);
                SchemaLabelsImportVM.this.labelsExportJobStatusPopUp = null;
                File file = job.getOutputFile();
                String surveyName = SchemaLabelsImportVM.this.survey.getName();
                String dateStr = Dates.formatLocalDateTime((Date)new Date());
                String fileName = String.format(SchemaLabelsImportVM.SCHEMA_LABELS_FILE_NAME_PATTERN, surveyName, dateStr, "xlsx");
                String contentType = URLConnection.guessContentTypeFromName(fileName);
                try {
                    FileInputStream is = new FileInputStream(file);
                    Filedownload.save((InputStream)is, (String)contentType, (String)fileName);
                }
                catch (FileNotFoundException e) {
                    MessageUtil.showError(SchemaLabelsImportVM.LABELS_EXPORT_ERROR, e.getMessage());
                }
            }
        });
    }

    @Command
    public void startImport(@ContextParam(value=ContextType.BIND_CONTEXT) BindContext ctx) {
        Map<Integer, List<NodeLabel>> labelsByNodeDefId;
        if (this.validateForm(ctx) && (labelsByNodeDefId = new LabelsExtractor(this.uploadedFile, (Survey)this.survey).extractLabelsByNodeDefId()) != null) {
            new LabelsImporter(labelsByNodeDefId, (Survey)this.survey).importLabels();
            MessageUtil.showInfo(IMPORT_COMPLETE_MESSAGE_KEY, labelsByNodeDefId.size());
            this.dispatchSchemaChangedCommand();
            this.close();
        }
    }

    @Command
    public void close() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_POP_UP_GLOBAL_COMMAND, null);
    }

    private static class LabelsExtractor {
        private File file;
        private Survey survey;

        public LabelsExtractor(File file, Survey survey) {
            this.file = file;
            this.survey = survey;
        }

        /*
         * Exception decompiling
         */
        public Map<Integer, List<NodeLabel>> extractLabelsByNodeDefId() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean validateColumnNames(List<String> columnNames) {
            ArrayList<String> requiredColumnNames = new ArrayList<String>();
            requiredColumnNames.add("id");
            requiredColumnNames.add(LabelsExtractor.getColumnPrefix(NodeLabel.Type.INSTANCE) + "_" + this.survey.getDefaultLanguage());
            for (String colName : columnNames) {
                if (this.validateColumnName(colName)) continue;
                this.handleError(SchemaLabelsImportVM.INVALID_COLUMN_NAME_MESSAGE_KEY, new String[]{colName, ((Object)requiredColumnNames).toString()});
                return false;
            }
            for (String colName : requiredColumnNames) {
                if (columnNames.contains(colName)) continue;
                this.handleError(SchemaLabelsImportVM.MISSING_COLUMN_MESSAGE_KEY, new String[]{colName, ((Object)requiredColumnNames).toString()});
                return false;
            }
            return true;
        }

        private boolean validateColumnName(String colName) {
            if ("id".equalsIgnoreCase(colName)) {
                return true;
            }
            List languages = this.survey.getLanguages();
            for (NodeLabel.Type type : LABEL_TYPES) {
                for (String lang : languages) {
                    String expectedColName = LabelsExtractor.getColumnPrefix(type) + "_" + lang;
                    if (!expectedColName.equalsIgnoreCase(colName)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean validateRow(long rowNumber, FlatRecord row, String defaultLanguage) {
            Integer nodeDefId = (Integer)row.getValue("id", Integer.class);
            if (nodeDefId == null) {
                this.handleError(SchemaLabelsImportVM.MISSING_NODE_DEF_ID_MESSAGE_KEY, new Long[]{rowNumber});
                return false;
            }
            if (!this.survey.getSchema().containsDefinitionWithId(nodeDefId.intValue())) {
                this.handleError(SchemaLabelsImportVM.MISSING_NODE_DEF_MESSAGE_KEY, new Object[]{nodeDefId, rowNumber});
                return false;
            }
            String defaultLangLabelColName = LabelsExtractor.getColumnPrefix(NodeLabel.Type.INSTANCE) + "_" + defaultLanguage;
            String defaultLangLabel = (String)row.getValue(defaultLangLabelColName, String.class);
            if (StringUtils.isBlank((CharSequence)defaultLangLabel)) {
                this.handleError(SchemaLabelsImportVM.MISSING_LABEL_DEFAULT_LANG_MESSAGE_KEY, new Object[]{rowNumber, defaultLangLabelColName});
                return false;
            }
            return true;
        }

        private static String getColumnPrefix(NodeLabel.Type type) {
            switch (type) {
                case INSTANCE: {
                    return "label";
                }
            }
            return "label_" + type.name().toLowerCase(Locale.ENGLISH);
        }

        private void handleError(String messageKey, Object[] args) {
            MessageUtil.showError(messageKey, args);
        }

        private boolean isEmpty(FlatRecord row) {
            String[] values;
            for (String val : values = row.toStringArray()) {
                if (!StringUtils.isNotBlank((CharSequence)val)) continue;
                return false;
            }
            return true;
        }
    }

    private static class LabelsImporter {
        private Map<Integer, List<NodeLabel>> labelsByNodeDefId = new HashMap<Integer, List<NodeLabel>>();
        private Survey survey;

        public LabelsImporter(Map<Integer, List<NodeLabel>> labelsByNodeDefId, Survey survey) {
            this.labelsByNodeDefId = labelsByNodeDefId;
            this.survey = survey;
        }

        public void importLabels() {
            Schema schema = this.survey.getSchema();
            for (Map.Entry<Integer, List<NodeLabel>> entry : this.labelsByNodeDefId.entrySet()) {
                int nodeDefId = entry.getKey();
                NodeDefinition nodeDef = schema.getDefinitionById(nodeDefId);
                List<NodeLabel> labels = entry.getValue();
                for (NodeLabel nodeLabel : labels) {
                    String text = StringUtils.trimToNull((String)nodeLabel.getText());
                    NodeLabel.Type type = (NodeLabel.Type)nodeLabel.getType();
                    String language = nodeLabel.getLanguage();
                    if (text == null) {
                        nodeDef.removeLabel(type, language);
                        continue;
                    }
                    nodeDef.setLabel(type, language, text);
                }
            }
        }
    }
}

