/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.form.DataCleansingChainForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataCleansingChainManager;
import org.openforis.collect.model.CollectSurvey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataCleansingChainValidator
extends SimpleValidator<DataCleansingChainForm> {
    private static final String TITLE_FIELD = "title";
    private static final String STEP_IDS_FIELD = "stepIds";
    @Autowired
    private DataCleansingChainManager dataCleansingChainManager;

    @Override
    public void validateForm(DataCleansingChainForm target, Errors errors) {
        if (this.validateRequiredField(errors, TITLE_FIELD)) {
            this.validateTitleUniqueness(target, errors);
        }
        if (this.validateRequiredField(errors, STEP_IDS_FIELD)) {
            this.validateStepsUniqueness(target, errors);
        }
    }

    private boolean validateStepsUniqueness(DataCleansingChainForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        List chains = this.dataCleansingChainManager.loadBySurvey(survey);
        for (DataCleansingChain chain : chains) {
            if (((Integer)chain.getId()).equals(target.getId())) continue;
            List<DataCleansingStep> steps = chain.getSteps();
            ArrayList<Number> stepIds = new ArrayList<Number>();
            for (DataCleansingStep step : steps) {
                stepIds.add(step.getId());
            }
            if (!stepIds.equals(target.getStepIds())) continue;
            this.rejectDuplicateValue(errors, STEP_IDS_FIELD, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateTitleUniqueness(DataCleansingChainForm target, Errors errors) {
        String title = target.getTitle();
        CollectSurvey survey = this.getActiveSurvey();
        List chains = this.dataCleansingChainManager.loadBySurvey(survey);
        for (DataCleansingChain chain : chains) {
            if (((Integer)chain.getId()).equals(target.getId()) || !chain.getTitle().equalsIgnoreCase(title)) continue;
            this.rejectDuplicateValue(errors, TITLE_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

