/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;

public class FileAttributeDefinitionFormObject<T extends FileAttributeDefinition>
extends AttributeDefinitionFormObject<T> {
    private static final int MB_IN_BYTES = 0x100000;
    private Integer maxSize;
    private String fileType;

    FileAttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setMaxSize(FileAttributeDefinitionFormObject.convertToBytes(this.maxSize));
        dest.removeAllExtensions();
        CollectAnnotations annotations = ((CollectSurvey)dest.getSurvey()).getAnnotations();
        annotations.setFileType(dest, CollectAnnotations.FileType.valueOf((String)this.fileType));
    }

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.maxSize = FileAttributeDefinitionFormObject.convertToMB(source.getMaxSize());
        CollectAnnotations annotations = ((CollectSurvey)source.getSurvey()).getAnnotations();
        this.fileType = annotations.getFileType(source).name();
    }

    private static Integer convertToMB(Integer bytes) {
        if (bytes == null) {
            return null;
        }
        double part = (double)bytes.intValue() / 1048576.0;
        double result = Math.ceil(part);
        return Double.valueOf(result).intValue();
    }

    private static Integer convertToBytes(Integer megaBytes) {
        if (megaBytes == null) {
            return null;
        }
        int result = megaBytes * 0x100000;
        return Double.valueOf(result).intValue();
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }
}

