/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.designer.viewmodel.referencedata.ReferenceDataImportErrorsPopUpVM;
import org.openforis.collect.io.metadata.codelist.CodeListImportJob;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.idm.metamodel.CodeList;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Window;

public class CodeListImportVM
extends BaseSurveyFileImportVM {
    private static final String EXAMPLE_XLSX = "code-list-import-example.xlsx";
    @WireVariable
    private CodeListManager codeListManager;
    private int codeListId;
    private Window jobStatusPopUp;

    public CodeListImportVM() {
        super(new String[]{"csv", "xlsx"}, EXAMPLE_XLSX);
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="codeListId") int codeListId) {
        super.init();
        this.codeListId = codeListId;
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        event.stopPropagation();
        BindUtils.postGlobalCommand(null, null, (String)"closeCodeListImportPopUp", null);
    }

    @Command
    public void importCodeList() {
        CollectSurvey survey = this.getSurvey();
        CodeList codeList = survey.getCodeListById(this.codeListId);
        CodeListImportJob job = new CodeListImportJob();
        job.setJobManager((JobManager)this.jobManager);
        job.setCodeListManager(this.codeListManager);
        job.setCodeList(codeList);
        job.setFile(this.uploadedFile);
        job.setOverwriteData(true);
        this.jobManager.start((Job)job);
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp("survey.code_list.import_data.title", job, true, new JobStatusPopUpVM.JobEndHandler<CodeListImportJob>(){

            @Override
            public void onJobEnd(CodeListImportJob job) {
                BaseVM.closePopUp(CodeListImportVM.this.jobStatusPopUp);
                switch (job.getStatus()) {
                    case COMPLETED: {
                        MessageUtil.showInfo("survey.code_list.import_data.completed", new Object[0]);
                        SurveyEditVM.dispatchSurveySaveCommand();
                        break;
                    }
                    case FAILED: {
                        String title = Labels.getLabel((String)"survey.code_list.import_data.error_popup.title", (Object[])new String[]{CodeListImportVM.this.getUploadedFileName()});
                        ReferenceDataImportErrorsPopUpVM.showPopUp(job.getErrors(), title);
                        break;
                    }
                }
            }
        });
    }
}

