/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency.proxy;

import org.openforis.collect.Proxy;
import org.openforis.concurrency.Job;

public class JobProxy
implements Proxy {
    protected transient Job job;

    public JobProxy(Job job) {
        this.job = job;
    }

    protected Job getJob() {
        return this.job;
    }

    public String getId() {
        return this.job.getId().toString();
    }

    public Status getStatus() {
        return Status.valueOf(this.job.getStatus().name());
    }

    public boolean isPending() {
        return this.job.isPending();
    }

    public boolean isRunning() {
        return this.job.isRunning();
    }

    public boolean isFailed() {
        return this.job.isFailed();
    }

    public boolean isAborted() {
        return this.job.isAborted();
    }

    public boolean isCompleted() {
        return this.job.isCompleted();
    }

    public int getProgressPercent() {
        return this.job.getProgressPercent();
    }

    public String getErrorMessage() {
        return this.job.getErrorMessage();
    }

    public String[] getErrorMessageArgs() {
        return this.job.getErrorMessageArgs();
    }

    public String getName() {
        return this.job.getName();
    }

    public static enum Status {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED,
        ABORTED;

    }
}

