/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.form.DataCleansingItemForm;
import org.openforis.collect.datacleansing.form.DataQueryGroupForm;
import org.openforis.collect.datacleansing.json.CollectDateSerializer;
import org.openforis.collect.model.CollectRecord;

public class DataReportForm
extends DataCleansingItemForm<DataReport> {
    private CollectRecord.Step recordStep;
    private int datasetSize;
    private Date lastRecordModifiedDate;
    private int itemCount;
    private int affectedRecordsCount;
    private String queryGroupTitle;
    private DataQueryGroupForm queryGroup;

    public DataReportForm() {
    }

    public DataReportForm(DataReport obj) {
        super(obj);
        DataQueryGroup dataQueryGroup = obj.getQueryGroup();
        this.queryGroup = new DataQueryGroupForm(dataQueryGroup);
        this.queryGroupTitle = this.queryGroup.getTitle();
    }

    public double getAffectedRecordsPercent() {
        if (this.affectedRecordsCount > 0) {
            return (double)(this.affectedRecordsCount * 100) / (double)this.datasetSize;
        }
        return 0.0;
    }

    public CollectRecord.Step getRecordStep() {
        return this.recordStep;
    }

    public void setRecordStep(CollectRecord.Step recordStep) {
        this.recordStep = recordStep;
    }

    public int getDatasetSize() {
        return this.datasetSize;
    }

    public void setDatasetSize(int datasetSize) {
        this.datasetSize = datasetSize;
    }

    @JsonSerialize(using=CollectDateSerializer.class)
    public Date getLastRecordModifiedDate() {
        return this.lastRecordModifiedDate;
    }

    public void setLastRecordModifiedDate(Date lastRecordModifiedDate) {
        this.lastRecordModifiedDate = lastRecordModifiedDate;
    }

    public String getQueryGroupTitle() {
        return this.queryGroupTitle;
    }

    public DataQueryGroupForm getQueryGroup() {
        return this.queryGroup;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public int getAffectedRecordsCount() {
        return this.affectedRecordsCount;
    }

    public void setAffectedRecordsCount(int affectedRecordsCount) {
        this.affectedRecordsCount = affectedRecordsCount;
    }
}

