/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.manager.DataCleansingStepManager;
import org.openforis.collect.datacleansing.persistence.DataCleansingChainDao;
import org.openforis.collect.datacleansing.persistence.DataCleansingReportDao;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DataCleansingChainManager
extends AbstractSurveyObjectManager<Integer, DataCleansingChain, DataCleansingChainDao> {
    @Autowired
    private DataCleansingStepManager dataCleansingStepManager;
    @Autowired
    private DataCleansingReportDao dataCleansingReportDao;

    public Set<DataCleansingChain> loadByStep(DataCleansingStep step) {
        Set<DataCleansingChain> chains = ((DataCleansingChainDao)this.dao).loadChainsByStep(step);
        this.initializeItems(chains);
        return chains;
    }

    @Transactional
    public DataCleansingChain save(DataCleansingChain chain, User activeUser) {
        ArrayList<Integer> stepIds = new ArrayList<Integer>();
        for (DataCleansingStep step : chain.getSteps()) {
            stepIds.add((Integer)step.getId());
        }
        if (chain.getId() != null) {
            ((DataCleansingChainDao)this.dao).deleteStepAssociations(chain);
        }
        super.save((PersistedSurveyObject)chain, activeUser);
        ((DataCleansingChainDao)this.dao).insertStepAssociations(chain, stepIds);
        this.initializeItem(chain);
        return chain;
    }

    public void delete(DataCleansingChain chain) {
        this.dataCleansingReportDao.deleteByCleansingChain(chain);
        ((DataCleansingChainDao)this.dao).deleteStepAssociations(chain);
        super.delete((PersistedSurveyObject)chain);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((DataCleansingChainDao)this.dao).deleteStepAssociations(survey);
        super.deleteBySurvey(survey);
    }

    protected void initializeItem(DataCleansingChain chain) {
        super.initializeItem((PersistedSurveyObject)chain);
        chain.removeAllSteps();
        List<Integer> stepIds = ((DataCleansingChainDao)this.dao).loadStepIds(chain);
        for (Integer stepId : stepIds) {
            DataCleansingStep step = (DataCleansingStep)this.dataCleansingStepManager.loadById((CollectSurvey)chain.getSurvey(), stepId);
            chain.addStep(step);
        }
    }
}

