/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.NodeDefinitionFormObject;
import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.NodeDefinitionVM;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public abstract class NodeDefinitionFormValidator
extends FormValidator {
    protected static final String NODE_NAME_ALREADY_DEFINED_MESSAGE_KEY = "survey.schema.node.validation.name_already_defined";
    private static final String BACKGROUND_COLOR_FORMAT_ERROR_MESSAGE_KEY = "survey.schema.node.validation.background_color";
    protected static final String DESCRIPTION_FIELD = "description";
    protected static final String NAME_FIELD = "name";
    protected static final String KEY_FIELD = "key";
    protected static final String MIN_COUNT_EXPRESSION_FIELD = "minCountExpression";
    protected static final String MAX_COUNT_EXPRESSION_FIELD = "maxCountExpression";
    protected static final String TAB_NAME_FIELD = "tabName";
    protected static final String REQUIRENESS_TYPE_FIELD = "requirenessType";
    protected static final String REQUIRED_EXPR_FIELD = "requiredWhenExpression";
    protected static final String RELEVANCE_TYPE_FIELD = "relevanceType";
    protected static final String RELEVANT_EXPR_FIELD = "relevantExpression";
    protected static final String COLUMN_FIELD = "column";
    protected static final String COLUMN_SPAN_FIELD = "columnSpan";
    protected static final String BACKGROUND_COLOR = "backgroundColor";
    protected static final String BACKGROUND_TRANSPARENCY = "backgroundTransparency";
    protected static final int MAX_COUNT_MIN_VALUE = 2;
    private static final String HEX_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        Boolean multiple;
        String relevanceTypeVal;
        NodeDefinitionFormObject.RelevanceType relevanceType;
        this.validateName(ctx);
        this.validateDescription(ctx);
        NodeDefinition contextNode = this.getEditedNode(ctx);
        boolean key = this.getValueWithDefault(ctx, KEY_FIELD, false);
        String requirenessTypeVal = (String)this.getValue(ctx, REQUIRENESS_TYPE_FIELD);
        NodeDefinitionFormObject.RequirenessType requirenessType = NodeDefinitionFormObject.RequirenessType.valueOf(requirenessTypeVal);
        if (!key && requirenessType == NodeDefinitionFormObject.RequirenessType.REQUIRED_WHEN && this.validateRequired(ctx, REQUIRED_EXPR_FIELD)) {
            this.validateBooleanExpressionField(ctx, contextNode, REQUIRED_EXPR_FIELD);
        }
        if ((relevanceType = NodeDefinitionFormObject.RelevanceType.valueOf(relevanceTypeVal = (String)this.getValue(ctx, RELEVANCE_TYPE_FIELD))) == NodeDefinitionFormObject.RelevanceType.RELEVANT_WHEN && this.validateRequired(ctx, RELEVANT_EXPR_FIELD)) {
            this.validateBooleanExpressionField(ctx, contextNode, RELEVANT_EXPR_FIELD);
        }
        if ((multiple = (Boolean)this.getValue(ctx, "multiple")) != null && multiple.booleanValue()) {
            this.validateValueExpressionField(ctx, contextNode, MIN_COUNT_EXPRESSION_FIELD);
            this.validateValueExpressionField(ctx, contextNode, MAX_COUNT_EXPRESSION_FIELD);
            this.validateMaxCount(ctx);
        }
        this.validateColumn(ctx);
        this.validateRegEx(ctx, HEX_PATTERN, BACKGROUND_COLOR, BACKGROUND_COLOR_FORMAT_ERROR_MESSAGE_KEY);
        if (this.validateRequired(ctx, BACKGROUND_TRANSPARENCY)) {
            this.validateGreaterThan(ctx, BACKGROUND_TRANSPARENCY, 0, false);
            this.validateLessThan(ctx, BACKGROUND_TRANSPARENCY, 100, false);
        }
    }

    protected boolean validateName(ValidationContext ctx) {
        boolean valid = this.validateRequired(ctx, NAME_FIELD);
        if (valid) {
            EntityDefinition parentEntity = this.getParentEntity(ctx);
            String name = (String)this.getValue(ctx, NAME_FIELD);
            CollectSurvey survey = (CollectSurvey)this.getEditedNode(ctx).getSurvey();
            if (survey.getTarget() == SurveyTarget.COLLECT_EARTH) {
                CollectEarthSurveyValidator collectEarthSurveyValidator = new CollectEarthSurveyValidator();
                if (parentEntity == null) {
                    valid = collectEarthSurveyValidator.validateRootEntityName(name);
                    if (!valid) {
                        this.addInvalidMessage(ctx, NAME_FIELD, Labels.getLabel((String)"survey.validation.collect_earth.invalid_root_entity_name"));
                    }
                } else {
                    valid = collectEarthSurveyValidator.validateNodeName(name);
                    if (!valid) {
                        this.addInvalidMessage(ctx, NAME_FIELD, Labels.getLabel((String)"survey.validation.collect_earth.invalid_node_name"));
                    }
                }
            } else {
                SurveyValidator surveyValidator;
                valid = super.validateInternalName(ctx, NAME_FIELD);
                if (valid && !(valid = (surveyValidator = new SurveyValidator()).validateNodeNameMaxLength(parentEntity, name))) {
                    String errorMessage = Labels.getLabel((String)"survey.validation.node.name.error.max_length_exceeded", (Object[])new Object[]{surveyValidator.generateFullInternalName(parentEntity, name).length(), 63});
                    this.addInvalidMessage(ctx, NAME_FIELD, errorMessage);
                }
            }
            if (valid) {
                valid = this.validateNameUniqueness(ctx);
            }
        }
        return valid;
    }

    protected boolean validateNameUniqueness(ValidationContext ctx) {
        String name;
        NodeDefinition editedNode = this.getEditedNode(ctx);
        if (!this.isNameUnique(ctx, editedNode, name = (String)this.getValue(ctx, NAME_FIELD))) {
            String message = Labels.getLabel((String)NODE_NAME_ALREADY_DEFINED_MESSAGE_KEY);
            this.addInvalidMessage(ctx, NAME_FIELD, message);
            return false;
        }
        return true;
    }

    protected boolean isNameUnique(ValidationContext ctx, NodeDefinition defn, String name) {
        EntityDefinition parentDefn = this.getParentEntity(ctx);
        NodeDefinition nodeInPath = null;
        try {
            if (parentDefn != null) {
                nodeInPath = parentDefn.getChildDefinition(name);
            } else {
                Schema schema = defn.getSchema();
                nodeInPath = schema.getRootEntityDefinition(name);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return nodeInPath == null || nodeInPath.getId() == defn.getId();
    }

    protected void validateDescription(ValidationContext ctx) {
    }

    protected void validateMaxCount(ValidationContext ctx) {
        Boolean multiple = (Boolean)this.getValue(ctx, "multiple");
        if (multiple != null && multiple.booleanValue()) {
            Object maxCountVal;
            NodeDefinition editedNode = this.getEditedNode(ctx);
            boolean result = true;
            if (editedNode instanceof AttributeDefinition) {
                result = this.validateRequired(ctx, MAX_COUNT_EXPRESSION_FIELD);
            }
            if (result && (maxCountVal = this.getValue(ctx, MAX_COUNT_EXPRESSION_FIELD)) != null && this.isNumber(maxCountVal)) {
                String minCountVal = (String)this.getValue(ctx, MIN_COUNT_EXPRESSION_FIELD);
                if (StringUtils.isBlank((CharSequence)minCountVal) || this.isNumber(minCountVal) && Double.parseDouble(minCountVal.toString()) < 2.0) {
                    this.validateGreaterThan(ctx, MAX_COUNT_EXPRESSION_FIELD, 2, false);
                } else if (this.isNumber(minCountVal)) {
                    String minCountLabel = Labels.getLabel((String)"survey.schema.node.min_count");
                    this.validateGreaterThan(ctx, MAX_COUNT_EXPRESSION_FIELD, MIN_COUNT_EXPRESSION_FIELD, minCountLabel, false);
                }
            }
        }
    }

    private void validateColumn(ValidationContext ctx) {
        this.validateGreaterThan(ctx, COLUMN_FIELD, 1, false);
        this.validateGreaterThan(ctx, COLUMN_SPAN_FIELD, 1, false);
    }

    protected NodeDefinition getEditedNode(ValidationContext ctx) {
        return (NodeDefinition)((NodeDefinitionVM)this.getVM(ctx)).getEditedItem();
    }

    protected EntityDefinition getParentEntity(ValidationContext ctx) {
        return (EntityDefinition)ctx.getValidatorArg("parentEntity");
    }
}

