/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.List;
import org.openforis.collect.event.EventQueue;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.model.CollectRecord;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionEventDispatcher {
    @Autowired
    private RecordSessionManager recordSessionManager;
    private EventQueue eventQueue;

    public SessionEventDispatcher(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    public void recordSaved(CollectRecord record) {
        List<RecordEvent> events = this.recordSessionManager.flushPendingEvents();
        if (!events.isEmpty()) {
            for (RecordEvent event : events) {
                event.initializeRecordId(record.getId().intValue());
            }
            String surveyName = record.getSurvey().getName();
            if (this.eventQueue.isEnabled()) {
                this.eventQueue.publish(new RecordTransaction(surveyName, record.getId().intValue(), record.getStep().toRecordStep(), events));
            }
        }
    }
}

