/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.composer;

import org.openforis.collect.designer.component.BasicTreeModel;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.viewmodel.SchemaVM;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.BindComposer;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;

public class SurveySchemaEditComposer
extends BindComposer<Component> {
    private static final long serialVersionUID = 1L;

    public void doAfterCompose(Component view) throws Exception {
        super.doAfterCompose(view);
        Selectors.wireEventListeners((Component)view, (Object)((Object)this));
        Selectors.wireComponents((Component)view, (Object)((Object)this), (boolean)false);
    }

    @Listen(value="onSelectTreeNode")
    public void onSelectTreeNode(Event event) throws InterruptedException {
        SchemaVM vm = (SchemaVM)this.getViewModel();
        if (vm.checkCanLeaveForm()) {
            Tab tab = (Tab)event.getTarget();
            Tabbox tabbox = tab.getTabbox();
            tabbox.setSelectedTab(tab);
        }
    }

    static class SchemaTreeItemRenderer
    implements TreeitemRenderer<BasicTreeModel.AbstractNode<SchemaTreeModel.SchemaNodeData>> {
        SchemaTreeItemRenderer() {
        }

        public void render(Treeitem item, BasicTreeModel.AbstractNode<SchemaTreeModel.SchemaNodeData> node, int index) throws Exception {
            SchemaTreeModel.SchemaNodeData data = (SchemaTreeModel.SchemaNodeData)node.getData();
            Treerow row = new Treerow();
            Treecell cell = new Treecell();
            SurveyObject surveyObject = data.getSurveyObject();
            if (surveyObject instanceof NodeDefinition) {
                cell.setLabel(((NodeDefinition)surveyObject).getName());
            } else {
                Textbox textbox = new Textbox();
                cell.appendChild((Component)textbox);
            }
            cell.setImage(SchemaVM.getIcon(data.getSurveyObject()));
            row.appendChild((Component)cell);
            item.appendChild((Component)row);
        }
    }
}

