/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Window;

public class SurveyValidationResultsVM {
    public static final String CONFIRM_EVENT_NAME = "onConfirm";
    private static final String DEFAULT_CONFIRM_BUTTON_LABEL_KEY = "global.confirm";
    private boolean showConfirm;
    private String confirmButtonLabel;
    private SurveyValidator.SurveyValidationResults validationResults;

    public static Window showPopUp(SurveyValidator.SurveyValidationResults validationResults, boolean showConfirm) {
        return SurveyValidationResultsVM.showPopUp(validationResults, showConfirm, null);
    }

    public static Window showPopUp(SurveyValidator.SurveyValidationResults validationResults, boolean showConfirm, String confirmButtonLabel) {
        confirmButtonLabel = (String)ObjectUtils.defaultIfNull((Object)confirmButtonLabel, (Object)Labels.getLabel((String)DEFAULT_CONFIRM_BUTTON_LABEL_KEY));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("showConfirm", showConfirm);
        args.put("validationResults", validationResults);
        args.put("confirmButtonLabel", confirmButtonLabel);
        return PopUpUtil.openPopUp(Resources.Component.SURVEY_VALIDATION_RESULTS_POPUP.getLocation(), true, args);
    }

    @Init
    public void init(@ExecutionArgParam(value="showConfirm") boolean showConfirm, @ExecutionArgParam(value="confirmButtonLabel") String confirmButtonLabel, @ExecutionArgParam(value="validationResults") SurveyValidator.SurveyValidationResults validationResults) {
        this.showConfirm = showConfirm;
        this.confirmButtonLabel = confirmButtonLabel;
        this.validationResults = validationResults;
    }

    @Command
    public void confirm(@ContextParam(value=ContextType.VIEW) Component view) {
        Events.postEvent((Event)new ConfirmEvent(view));
    }

    public List<SurveyValidator.SurveyValidationResult> getResults() {
        return new ListModelList((Collection)this.validationResults.getResults());
    }

    public boolean hasOnlyWarnings() {
        return !this.validationResults.hasErrors();
    }

    public boolean isShowConfirm() {
        return this.showConfirm;
    }

    public String getConfirmButtonLabel() {
        return this.confirmButtonLabel;
    }

    public static class ConfirmEvent
    extends Event {
        private static final long serialVersionUID = 1L;

        public ConfirmEvent(Component target) {
            super(SurveyValidationResultsVM.CONFIRM_EVENT_NAME, target);
        }
    }
}

