/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational;

import java.io.File;
import java.util.Date;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.manager.BaseStorageManager;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.utils.Dates;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class CollectLocalRDBStorageManager
extends BaseStorageManager
implements InitializingBean {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_STORAGE_SUBFOLDER = "rdb";

    public CollectLocalRDBStorageManager() {
        super(DEFAULT_STORAGE_SUBFOLDER);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        this.initStorageDirectory();
    }

    protected void initStorageDirectory() {
        super.initStorageDirectory(Configuration.ConfigurationItem.RDB_PATH);
    }

    public boolean existsRDBFile(String surveyName, RecordStep step) {
        File rdbFile = this.getRDBFile(surveyName, step);
        return rdbFile.exists() && rdbFile.length() > 0L;
    }

    public Date getRDBFileDate(String surveyName, RecordStep step) {
        File rdbFile = this.getRDBFile(surveyName, step);
        if (rdbFile.exists()) {
            return Dates.millisToDate((long)rdbFile.lastModified());
        }
        return null;
    }

    public File getRDBFile(String surveyName, RecordStep step) {
        return new File(this.storageDirectory, this.getRDBFileName(surveyName, step));
    }

    public boolean deleteRDBFile(String surveyName, RecordStep step) {
        File rdbFile = this.getRDBFile(surveyName, step);
        File rdbJournalFile = new File(this.getRDBJournalFileName(surveyName, step));
        rdbJournalFile.delete();
        return rdbFile.delete();
    }

    private String getRDBFileName(String surveyName, RecordStep step) {
        return String.format("%s_%s.db", surveyName, step.nameLowerCase());
    }

    private String getRDBJournalFileName(String surveyName, RecordStep step) {
        return String.format("%s_%s.db-journal", surveyName, step.nameLowerCase());
    }
}

