/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.service;

import java.io.InputStream;
import java.util.Locale;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.SurveyObjectsGenerator;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.manager.exception.SurveyValidationException;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.collect.web.controller.SurveyController;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.xml.IdmlParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SurveyService {
    private static final String IDM_TEMPLATE_FILE_NAME_FORMAT = "/org/openforis/collect/designer/templates/%s.idm.xml";
    public static final String DEFAULT_ROOT_ENTITY_NAME = "change_it_to_your_sampling_unit";
    public static final String DEFAULT_MAIN_TAB_LABEL = "Change it to your main tab label";
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private UserGroupManager userGroupManager;

    public CollectSurvey createNewSurvey(SurveyController.SurveyCreationParameters params) throws SurveyStoreException, IdmlParseException, SurveyValidationException {
        CollectSurvey survey = this.createEmptySurvey(params);
        UserGroup userGroup = (UserGroup)this.userGroupManager.loadById((Object)params.getUserGroupId());
        survey.setUserGroupId(userGroup.getId());
        this.surveyManager.save(survey);
        return survey;
    }

    private CollectSurvey createEmptySurvey(SurveyController.SurveyCreationParameters params) throws IdmlParseException, SurveyValidationException {
        CollectSurvey survey;
        switch (params.getTemplateType()) {
            case BLANK: {
                survey = this.createEmptySurvey(params.getName(), params.getDefaultLanguageCode());
                break;
            }
            default: {
                survey = this.createNewSurveyFromTemplate(params.getName(), params.getDefaultLanguageCode(), params.getTemplateType());
            }
        }
        return survey;
    }

    private CollectSurvey createNewSurveyFromTemplate(String name, String langCode, SurveyController.SurveyCreationParameters.TemplateType templateType) throws IdmlParseException, SurveyValidationException {
        SurveyTarget target;
        String templateFileName = String.format(IDM_TEMPLATE_FILE_NAME_FORMAT, templateType.name().toLowerCase(Locale.ENGLISH));
        InputStream surveyFileIs = this.getClass().getResourceAsStream(templateFileName);
        CollectSurvey survey = this.surveyManager.unmarshalSurvey(surveyFileIs, false, true);
        survey.setName(name);
        survey.setTemporary(true);
        survey.setUri(this.surveyManager.generateSurveyUri(name));
        survey.setDefaultLanguage(langCode);
        switch (templateType) {
            case COLLECT_EARTH: 
            case COLLECT_EARTH_IPCC: {
                target = SurveyTarget.COLLECT_EARTH;
                break;
            }
            default: {
                target = SurveyTarget.COLLECT_DESKTOP;
            }
        }
        survey.setTarget(target);
        if (survey.getSamplingDesignCodeList() == null) {
            survey.addSamplingDesignCodeList();
        }
        return survey;
    }

    private CollectSurvey createEmptySurvey(String name, String langCode) {
        CollectSurvey survey = this.surveyManager.createTemporarySurvey(name, langCode);
        Schema schema = survey.getSchema();
        EntityDefinition rootEntity = schema.createEntityDefinition();
        rootEntity.setMultiple(true);
        rootEntity.setName(DEFAULT_ROOT_ENTITY_NAME);
        schema.addRootEntityDefinition(rootEntity);
        UIOptions uiOptions = survey.getUIOptions();
        UITabSet rootTabSet = uiOptions.createRootTabSet(rootEntity);
        UITab mainTab = uiOptions.getMainTab(rootTabSet);
        mainTab.setLabel(langCode, DEFAULT_MAIN_TAB_LABEL);
        SurveyObjectsGenerator surveyObjectsGenerator = new SurveyObjectsGenerator();
        surveyObjectsGenerator.addPredefinedObjects((Survey)survey);
        return survey;
    }
}

