/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.controller;

import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingChainExecutorJob;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.form.DataCleansingStepForm;
import org.openforis.collect.datacleansing.form.validation.DataCleansingStepValidator;
import org.openforis.collect.datacleansing.manager.DataCleansingStepManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.web.controller.AbstractSurveyObjectEditFormController;
import org.openforis.collect.web.controller.CollectJobController;
import org.openforis.concurrency.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/datacleansing/datacleansingsteps"})
public class DataCleansingStepController
extends AbstractSurveyObjectEditFormController<Integer, DataCleansingStep, DataCleansingStepForm, DataCleansingStepManager> {
    @Autowired
    private DataCleansingStepManager dataCleansingStepManager;
    @Autowired
    private CollectJobManager collectJobManager;
    @Autowired
    private DataCleansingStepValidator dataCleansingStepValidator;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.dataCleansingStepValidator);
    }

    @Override
    protected DataCleansingStepForm createFormInstance(DataCleansingStep item) {
        return new DataCleansingStepForm(item);
    }

    @Override
    protected DataCleansingStep createItemInstance(CollectSurvey survey) {
        return new DataCleansingStep(survey);
    }

    @RequestMapping(value={"run.json"}, method={RequestMethod.POST})
    @ResponseBody
    public DataCleangingChainExecutorJobView run(@RequestParam int cleansingStepId, @RequestParam CollectRecord.Step recordStep) {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        DataCleansingStep cleansingStep = (DataCleansingStep)this.dataCleansingStepManager.loadById(survey, cleansingStepId);
        DataCleansingChain chain = new DataCleansingChain(survey);
        chain.addStep(cleansingStep);
        DataCleansingChainExecutorJob job = (DataCleansingChainExecutorJob)this.collectJobManager.createJob(DataCleansingChainExecutorJob.class);
        job.setSurvey(survey);
        job.setChain(chain);
        job.setRecordStep(recordStep);
        this.collectJobManager.startSurveyJob((SurveyLockingJob)job);
        return new DataCleangingChainExecutorJobView(job);
    }

    public static class DataCleangingChainExecutorJobView
    extends CollectJobController.JobView {
        private int updatedRecords;
        private int processedNodes;

        public DataCleangingChainExecutorJobView(DataCleansingChainExecutorJob job) {
            super((Job)job);
            this.updatedRecords = job.getUpdatedRecords();
            this.processedNodes = job.getProcessedNodes();
        }

        public int getUpdatedRecords() {
            return this.updatedRecords;
        }

        public int getProcessedNodes() {
            return this.processedNodes;
        }
    }
}

