/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.openforis.collect.designer.component.BasicTreeModel;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.SurveyObject;
import org.openforis.idm.metamodel.VersionableSurveyObject;

public abstract class SurveyObjectTreeModelCreator {
    protected SurveyManager surveyManager;
    protected User loggedUser;
    protected ModelVersion version;
    private Predicate<SurveyObject> disabledNodePredicate;
    protected Predicate<SurveyObject> includeNodePredicate;
    protected boolean includeEmptyNodes;
    protected boolean includeRootEntity;
    protected String labelLanguage;

    public SurveyObjectTreeModelCreator(SurveyManager surveyManager, User loggedUser, ModelVersion version, Predicate<SurveyObject> disabledNodePredicate, Predicate<SurveyObject> includeNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, String labelLanguage) {
        this.surveyManager = surveyManager;
        this.loggedUser = loggedUser;
        this.version = version;
        this.disabledNodePredicate = disabledNodePredicate;
        this.includeNodePredicate = includeNodePredicate;
        this.includeRootEntity = includeRootEntity;
        this.includeEmptyNodes = includeEmptyNodes;
        this.labelLanguage = labelLanguage;
    }

    public SchemaTreeModel createModel(boolean includeSurveys) {
        ArrayList surveys = new ArrayList(this.surveyManager.getSurveySummaries(this.labelLanguage, this.loggedUser));
        surveys.addAll(this.surveyManager.loadTemporarySummaries(this.labelLanguage, false, this.loggedUser));
        Collections.sort(surveys, new Comparator<SurveySummary>(){

            @Override
            public int compare(SurveySummary o1, SurveySummary o2) {
                return new CompareToBuilder().append((Object)o1.getName(), (Object)o2.getName()).append((Object)o1.getProjectName(), (Object)o2.getProjectName()).append(!o1.isTemporary(), !o2.isTemporary()).toComparison();
            }
        });
        ArrayList<SchemaTreeModel.SchemaTreeNode> surveyNodes = new ArrayList<SchemaTreeModel.SchemaTreeNode>(surveys.size());
        for (SurveySummary survey : surveys) {
            String label = survey.getName() + (survey.getProjectName() != null ? " - " + survey.getProjectName() : "") + (survey.isTemporary() ? " (temporary)" : "");
            surveyNodes.add(new SchemaTreeModel.SchemaTreeNode(new SchemaTreeModel.SchemaNodeData(survey, null, label, true, true), (Collection<SchemaTreeModel.SchemaTreeNode>)Collections.emptyList()));
        }
        SchemaTreeModel.SchemaTreeNode root = new SchemaTreeModel.SchemaTreeNode(null, surveyNodes);
        return new SchemaTreeModel(this, root, null, this.labelLanguage);
    }

    public SchemaTreeModel createModel(EntityDefinition rootEntity) {
        if (rootEntity != null && (this.version == null || this.version.isApplicable((VersionableSurveyObject)rootEntity))) {
            List<SchemaTreeModel.SchemaTreeNode> firstLevelTreeNodes = this.createFirstLevelNodes(rootEntity);
            SchemaTreeModel.SchemaTreeNode root = new SchemaTreeModel.SchemaTreeNode(null, firstLevelTreeNodes);
            return new SchemaTreeModel(this, root, rootEntity, this.labelLanguage);
        }
        return null;
    }

    public BasicTreeModel.AbstractNode<SchemaTreeModel.SchemaNodeData> createSurveyRootEntityNode(int surveyId) {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        EntityDefinition rootEntity = survey.getSchema().getFirstRootEntityDefinition();
        BasicTreeModel.AbstractNode<SchemaTreeModel.SchemaNodeData> rootEntityNode = this.createNode(new SchemaTreeModel.SchemaNodeData((SurveyObject)rootEntity, false, false, this.labelLanguage), false);
        return rootEntityNode;
    }

    public BasicTreeModel.AbstractNode<SchemaTreeModel.SchemaNodeData> createNode(SchemaTreeModel.SchemaNodeData data, boolean defineEmptyChildrenForLeaves) {
        SchemaTreeModel.SchemaTreeNode node = null;
        SurveyObject surveyObject = data.getSurveyObject();
        if (this.includeNodePredicate == null || this.includeNodePredicate.evaluate(surveyObject)) {
            List<SchemaTreeModel.SchemaTreeNode> childNodes = this.createChildNodes(surveyObject);
            node = childNodes == null ? new SchemaTreeModel.SchemaTreeNode(data) : (childNodes.isEmpty() ? (this.includeEmptyNodes ? (defineEmptyChildrenForLeaves ? new SchemaTreeModel.SchemaTreeNode(data, (Collection<SchemaTreeModel.SchemaTreeNode>)Collections.emptyList()) : new SchemaTreeModel.SchemaTreeNode(data)) : null) : new SchemaTreeModel.SchemaTreeNode(data, (Collection<SchemaTreeModel.SchemaTreeNode>)childNodes));
        }
        if (node != null && this.disabledNodePredicate != null && this.disabledNodePredicate.evaluate(surveyObject)) {
            node.setDisabled(true);
        }
        return node;
    }

    protected abstract List<SchemaTreeModel.SchemaTreeNode> createFirstLevelNodes(EntityDefinition var1);

    protected abstract List<SchemaTreeModel.SchemaTreeNode> createChildNodes(SurveyObject var1);
}

