/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.io.exception.ParsingException;
import org.openforis.collect.io.metadata.ReferenceDataImportTask;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.io.parsing.CSVFileOptions;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.codelistimport.CodeListCSVReader;
import org.openforis.collect.manager.codelistimport.CodeListLine;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.io.OpenForisIOUtils;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLevel;
import org.openforis.idm.metamodel.LanguageSpecificText;

public class CodeListImportTask
extends ReferenceDataImportTask<ParsingError> {
    private static final Logger LOG = LogManager.getLogger(CodeListImportTask.class);
    private static final String DIFFERENT_LABEL_MESSAGE_KEY = "survey.code_list.import_data.error.different_label";
    private CodeListManager codeListManager;
    private String entryName;
    private InputStream inputStream;
    private CodeList codeList;
    private boolean overwriteData;
    private CSVFileOptions csvFileOptions = new CSVFileOptions();
    private CodeListCSVReader reader;
    private List<String> levels;
    private Map<String, CodeListItem> codeToRootItem;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.codeToRootItem = new LinkedHashMap<String, CodeListItem>();
    }

    protected void execute() throws Throwable {
        this.parseCSVLines();
        if (this.hasErrors()) {
            this.changeStatus(Worker.Status.FAILED);
        } else if (this.isRunning()) {
            this.saveData();
        }
    }

    private void saveData() {
        if (this.overwriteData) {
            this.codeList.removeAllLevels();
        }
        this.addLevelsToCodeList();
        this.codeListManager.deleteAllItems(this.codeList);
        ArrayList<CodeListItem> rootItems = new ArrayList<CodeListItem>(this.codeToRootItem.values());
        this.codeListManager.saveItemsAndDescendants(rootItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCSVLines() {
        long currentRowNumber = 0L;
        try {
            CollectSurvey survey = (CollectSurvey)this.codeList.getSurvey();
            List languages = survey.getLanguages();
            String defaultLanguage = survey.getDefaultLanguage();
            File file = OpenForisIOUtils.copyToTempFile((InputStream)this.inputStream);
            this.reader = new CodeListCSVReader(file, this.csvFileOptions, languages, defaultLanguage);
            this.reader.init();
            this.levels = this.reader.getLevels();
            this.addProcessedRow(1L);
            currentRowNumber = 2L;
            while (this.isRunning()) {
                try {
                    CodeListLine line = (CodeListLine)this.reader.readNextLine();
                    if (line != null) {
                        CodeListItem currentParentItem = null;
                        List<String> levelCodes = line.getLevelCodes();
                        for (int levelIdx = 0; levelIdx < levelCodes.size(); ++levelIdx) {
                            CodeListItem item;
                            boolean lastLevel = levelIdx == levelCodes.size() - 1;
                            currentParentItem = item = this.processLevel(currentParentItem, line, levelIdx, lastLevel);
                        }
                        this.addProcessedRow(currentRowNumber);
                    }
                    if (this.reader.isReady()) continue;
                    break;
                }
                catch (ParsingException e) {
                    this.addParsingError(currentRowNumber, e.getError());
                }
                finally {
                    ++currentRowNumber;
                }
            }
        }
        catch (ParsingException e) {
            this.changeStatus(Worker.Status.FAILED);
            this.addParsingError(1L, e.getError());
        }
        catch (Exception e) {
            this.changeStatus(Worker.Status.FAILED);
            this.addParsingError(currentRowNumber, new ParsingError(ParsingError.ErrorType.IOERROR, e.toString()));
            LOG.error("Error importing code list CSV file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)this.reader));
        }
    }

    protected CodeListItem processLevel(CodeListItem parent, CodeListLine line, int levelIdx, boolean lastLevel) {
        List<String> codes = line.getLevelCodes();
        if (codes.isEmpty()) {
            this.addEmptyCodeColumnError(line, levelIdx);
        }
        String code = codes.get(levelIdx);
        if (lastLevel && this.isDuplicate(code, parent)) {
            this.addDuplicateCodeError(line, levelIdx);
        }
        List<LanguageSpecificText> labels = line.getLabelItems(levelIdx);
        for (LanguageSpecificText label : labels) {
            if (!this.hasDifferentLabel(code, label, parent)) continue;
            this.addDifferentLabelError(line, levelIdx, label.getLanguage());
        }
        CodeListItem result = this.getChildItem(parent, code);
        if (result == null) {
            result = this.codeList.createItem(levelIdx + 1);
            List<LanguageSpecificText> descriptions = line.getDescriptionItems(levelIdx);
            boolean qualifiable = line.isQualifiable(levelIdx);
            this.fillItem(result, code, labels, descriptions, qualifiable);
            if (parent == null) {
                this.codeToRootItem.put(code, result);
            } else {
                parent.addChildItem(result);
            }
        }
        return result;
    }

    protected boolean isDuplicate(String code, CodeListItem parentItem) {
        CodeListItem duplicateItem = this.getChildItem(parentItem, code);
        return duplicateItem != null;
    }

    protected boolean hasDifferentLabel(String code, LanguageSpecificText item, CodeListItem parentItem) {
        CodeListItem existingItem = this.getChildItem(parentItem, code);
        if (existingItem == null) {
            return false;
        }
        String lang = item.getLanguage();
        String label = item.getText();
        String existingItemLabel = existingItem.getLabel(lang);
        return !existingItemLabel.equals(label);
    }

    protected CodeListItem getChildItem(CodeListItem parentItem, String code) {
        CodeListItem duplicateItem = parentItem == null ? this.codeToRootItem.get(code) : parentItem.getChildItem(code);
        return duplicateItem;
    }

    private void addEmptyCodeColumnError(CodeListLine line, int levelIdx) {
        String level = this.levels.get(levelIdx);
        String column = level + "_code";
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.EMPTY, lineNumber, column);
        this.addParsingError(lineNumber, error);
    }

    private void addDuplicateCodeError(CodeListLine line, int levelIdx) {
        String level = this.levels.get(levelIdx);
        String column = level + "_code";
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.DUPLICATE_VALUE, lineNumber, column);
        this.addParsingError(lineNumber, error);
    }

    private void addDifferentLabelError(CodeListLine line, int levelIdx, String lang) {
        String level = this.levels.get(levelIdx);
        String column = level + "_label" + "_" + lang;
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, lineNumber, column, DIFFERENT_LABEL_MESSAGE_KEY);
        this.addParsingError(lineNumber, error);
    }

    protected CodeListItem getCodeListItemInDescendants(String code) {
        LinkedList<CodeListItem> stack = new LinkedList<CodeListItem>();
        stack.addAll(this.codeToRootItem.values());
        while (!stack.isEmpty()) {
            CodeListItem item = (CodeListItem)stack.pop();
            if (item.matchCode(code)) {
                return item;
            }
            stack.addAll(item.getChildItems());
        }
        return null;
    }

    private void fillItem(CodeListItem item, String code, List<LanguageSpecificText> labelItems, List<LanguageSpecificText> descriptionItems, boolean qualifiable) {
        item.setCode(code);
        for (LanguageSpecificText labelItem : labelItems) {
            item.setLabel(labelItem.getLanguage(), labelItem.getText());
        }
        for (LanguageSpecificText textItem : descriptionItems) {
            item.setDescription(textItem.getLanguage(), textItem.getText());
        }
        item.setQualifiable(Boolean.valueOf(qualifiable));
    }

    private void addLevelsToCodeList() {
        if (this.levels != null && this.levels.size() > 1) {
            for (String levelName : this.levels) {
                CodeListLevel level = new CodeListLevel();
                level.setName(levelName);
                this.codeList.addLevel(level);
            }
        }
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setCodeList(CodeList codeList) {
        this.codeList = codeList;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setOverwriteData(boolean overwriteData) {
        this.overwriteData = overwriteData;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }
}

