/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.form.DataCleansingStepValueForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataCleansingStepValueValidator
extends SimpleValidator<DataCleansingStepValueForm> {
    private static final int MAX_FIELD_UPDATE_EXPRESSIONS = 6;
    private static final String FIX_EXPRESSION_FIELD = "fixExpression";
    private static final String FIELD_FIX_EXPRESSIONS_FIELD_PREFIX = "fieldFixExpressions";
    private static final String CONDITION_FIELD = "condition";
    @Autowired
    private DataQueryManager dataQueryManager;

    @Override
    public void validateForm(DataCleansingStepValueForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        DataQuery query = (DataQuery)this.dataQueryManager.loadById(survey, target.getQueryId());
        AttributeDefinition attrDef = query.getAttributeDefinition();
        int index = target.getIndex();
        this.validateCondition(target, errors, attrDef);
        switch (target.getUpdateType()) {
            case ATTRIBUTE: {
                this.validateUpdateByAttribute(errors, target, attrDef, index);
                break;
            }
            case FIELD: {
                this.validateUpdateByField(errors, target, attrDef, index);
            }
        }
    }

    private void validateUpdateByField(Errors errors, DataCleansingStepValueForm updateValue, AttributeDefinition attrDef, int fixIndex) {
        List<String> fieldFixExpressions;
        if (StringUtils.isNotBlank((CharSequence)updateValue.getFixExpression())) {
            Object[] args = new Object[]{fixIndex + 1};
            String errorCode = "data_cleansing_step.validation.cannot_specify_attribute_update_expression";
            errors.rejectValue(FIX_EXPRESSION_FIELD, errorCode, args, this.messageSource.getMessage(errorCode, args, Locale.ENGLISH));
        }
        if (this.isEmpty(fieldFixExpressions = updateValue.getFieldFixExpressions())) {
            this.rejectRequiredFields(errors, this.getFieldUpdateExpressionFieldNames());
        } else {
            int fieldIndex = 0;
            for (String expr : fieldFixExpressions) {
                if (StringUtils.isNotBlank((CharSequence)expr)) {
                    this.validateValueExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, this.getFieldUpdateExpressionFieldName(fieldIndex), expr);
                }
                ++fieldIndex;
            }
        }
    }

    private void validateUpdateByAttribute(Errors errors, DataCleansingStepValueForm updateValue, AttributeDefinition attrDef, int rowIndex) {
        String fixExpression;
        String errorCode;
        List<String> fieldFixExpressions = updateValue.getFieldFixExpressions();
        if (!this.isEmpty(fieldFixExpressions)) {
            Object[] args = new Object[]{rowIndex + 1};
            errorCode = "data_cleansing_step.validation.cannot_specify_field_update_expressions";
            String defaultMessage = this.messageSource.getMessage(errorCode, args, Locale.ENGLISH);
            int fieldIndex = 0;
            for (String expr : fieldFixExpressions) {
                if (StringUtils.isNotBlank((CharSequence)expr)) {
                    errors.rejectValue(this.getFieldUpdateExpressionFieldName(fieldIndex), errorCode, args, defaultMessage);
                }
                ++fieldIndex;
            }
        }
        if (StringUtils.isBlank((CharSequence)(fixExpression = updateValue.getFixExpression()))) {
            errorCode = "data_cleansing_step.validation.required_fix_expression";
            Object[] args = new Object[]{rowIndex + 1};
            String defaultMessage = this.messageSource.getMessage(errorCode, args, Locale.ENGLISH);
            errors.rejectValue(FIX_EXPRESSION_FIELD, errorCode, args, defaultMessage);
        } else {
            this.validateValueExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, FIX_EXPRESSION_FIELD, fixExpression);
        }
    }

    private void validateCondition(DataCleansingStepValueForm target, Errors errors, AttributeDefinition attrDef) {
        String condition = target.getCondition();
        if (StringUtils.isBlank((CharSequence)condition)) {
            return;
        }
        this.validateBooleanExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, CONDITION_FIELD, condition);
    }

    private String[] getFieldUpdateExpressionFieldNames() {
        String[] result = new String[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = this.getFieldUpdateExpressionFieldName(i);
        }
        return result;
    }

    private String getFieldUpdateExpressionFieldName(int fieldIndex) {
        return "fieldFixExpressions[" + fieldIndex + "]";
    }

    private boolean isEmpty(List<String> values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return false;
        }
        return true;
    }
}

