/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.reporting;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.openforis.collect.CollectInternalInfo;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.manager.BaseStorageManager;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.relational.CollectLocalRDBStorageManager;
import org.openforis.collect.remoting.service.CollectInfoService;
import org.openforis.collect.reporting.MondrianSchemaStorageManager;
import org.openforis.collect.reporting.SaikuConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaikuDatasourceStorageManager
extends BaseStorageManager
implements InitializingBean {
    private static final long serialVersionUID = 1L;
    private static final String DATASOURCE_SUFFIX = "_ds";
    private static final String DATASOURCES_PATH = "WEB-INF" + File.separator + "classes" + File.separator + "saiku-datasources";
    private static final String DATASOURCE_CONTENT_FORMAT = "type=OLAP\r\nname=%s_%s\r\ndriver=mondrian.olap4j.MondrianOlap4jDriver\r\nlocation=jdbc:mondrian:Jdbc=%s;Catalog=%s;JdbcDrivers=org.sqlite.JDBC\r\nusername=dbuser\r\npassword=password";
    @Autowired
    private CollectInfoService infoService;
    @Autowired
    private SaikuConfiguration saikuConfiguration;
    @Autowired
    private MondrianSchemaStorageManager mondrianSchemaStorageManager;
    @Autowired
    private CollectLocalRDBStorageManager rdbStorageManager;

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        CollectInternalInfo info = this.infoService.getInternalInfo();
        this.setDefaultRootStoragePath(info.getWebappsPath());
        this.setDefaultSubFolder(this.saikuConfiguration.getContextPath());
        super.initStorageDirectory(Configuration.ConfigurationItem.SAIKU_BASE_DIR, false);
    }

    public boolean isSaikuAvailable() {
        return this.storageDirectory.exists();
    }

    public File getDatasourcesDirectory() {
        return new File(this.storageDirectory, DATASOURCES_PATH);
    }

    private File getDatasourceFile(String name, RecordStep recordStep) {
        return new File(this.getDatasourcesDirectory(), name + "_" + recordStep.name().toLowerCase(Locale.ENGLISH) + DATASOURCE_SUFFIX);
    }

    public void writeDatasourceFile(String surveyName, RecordStep recordStep) {
        try {
            File rdbFile = this.rdbStorageManager.getRDBFile(surveyName, recordStep);
            File mondrianSchemaFile = this.mondrianSchemaStorageManager.getSchemaFile(surveyName);
            String content = String.format(DATASOURCE_CONTENT_FORMAT, surveyName, recordStep.name().toLowerCase(Locale.ENGLISH), "jdbc:sqlite:" + SaikuDatasourceStorageManager.formatPath(rdbFile.getAbsolutePath()), SaikuDatasourceStorageManager.formatPath(mondrianSchemaFile.getAbsolutePath()));
            File file = this.getDatasourceFile(surveyName, recordStep);
            FileUtils.write((File)file, (CharSequence)content, (String)"UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteDatasourceFile(String surveyName, RecordStep recordStep) {
        File file = this.getDatasourceFile(surveyName, recordStep);
        return file.delete();
    }

    private static String formatPath(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

