/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.zkoss.bind.Binder;
import org.zkoss.bind.SimpleForm;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.xel.impl.ExecutionResolver;

public class ComponentUtil {
    public static final String COMPOSER_ID = "$composer";
    private static final String BINDER_ID = "$BINDER$";
    private static final String FORM_ID_ATTRIBUTE = "$FORM_ID$";

    public static Component getCurrentComponent() {
        Execution execution = Executions.getCurrent();
        ExecutionResolver variableResolver = (ExecutionResolver)execution.getVariableResolver();
        Object self = variableResolver.getSelf();
        Component component = (Component)self;
        return component;
    }

    public static <T> T getComposer(Component view) {
        return (T)view.getAttribute(COMPOSER_ID);
    }

    public static Binder getBinder(Component component) {
        Binder binder = (Binder)component.getAttribute(BINDER_ID);
        return binder;
    }

    public static SimpleForm getForm(Binder binder) {
        Component view = binder.getView();
        return ComponentUtil.getForm(view);
    }

    public static SimpleForm getForm(Component view) {
        String formId = (String)view.getAttribute(FORM_ID_ATTRIBUTE);
        return formId == null ? null : (SimpleForm)view.getAttribute(formId);
    }

    public static <T> T getViewModel(Component component) {
        Binder binder = ComponentUtil.getBinder(component);
        Object viewModel = binder.getViewModel();
        return (T)viewModel;
    }

    public static <T> T getAncestorViewModel(Class<T> viewModelClass) {
        Component component = ComponentUtil.getCurrentComponent();
        return component == null ? null : (T)ComponentUtil.getAncestorViewModel(component, viewModelClass);
    }

    public static <T> T getAncestorViewModel(Component component, Class<T> viewModelClass) {
        for (Component currentParent = component.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            Object vm;
            Binder binder = ComponentUtil.getBinder(currentParent);
            if (binder == null || (vm = binder.getViewModel()) == null || !viewModelClass.isAssignableFrom(vm.getClass())) continue;
            return (T)vm;
        }
        return null;
    }

    public static <T> T getClosest(Component from, Class<T> type) {
        for (Component currentParent = from.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (!type.isAssignableFrom(currentParent.getClass())) continue;
            return (T)currentParent;
        }
        return null;
    }

    public static void addClass(HtmlBasedComponent component, String className) {
        String oldSclass = component.getSclass();
        if (oldSclass == null) {
            oldSclass = "";
        }
        if (!oldSclass.contains(className)) {
            component.setSclass(oldSclass + " " + className);
        }
    }

    public static void removeClass(HtmlBasedComponent component, String className) {
        String oldSclass = component.getSclass();
        if (oldSclass != null) {
            component.setSclass(oldSclass.replaceAll("(?:^|\\s)" + className + "(?!\\S)", ""));
        }
    }

    public static void toggleClass(HtmlBasedComponent component, String className, boolean present) {
        if (present) {
            ComponentUtil.addClass(component, className);
        } else {
            ComponentUtil.removeClass(component, className);
        }
    }

    public static String createUrl(String base, Map<String, String> queryParams) {
        ArrayList<BasicNameValuePair> convertedParams = new ArrayList<BasicNameValuePair>();
        Set<Map.Entry<String, String>> paramsEntrySet = queryParams.entrySet();
        for (Map.Entry<String, String> param : paramsEntrySet) {
            BasicNameValuePair valuePair = new BasicNameValuePair(param.getKey(), param.getValue());
            convertedParams.add(valuePair);
        }
        String queryString = URLEncodedUtils.format(convertedParams, (String)"UTF-8");
        String result = base + "?" + queryString;
        return result;
    }
}

