/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryEvaluator;
import org.openforis.collect.datacleansing.xpath.XPathDataQueryEvaluator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.NodeProcessor;
import org.openforis.collect.model.RecordFilter;
import org.openforis.concurrency.Task;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class DataQueryExectutorTask
extends Task {
    @Autowired
    private RecordManager recordManager;
    DataQueryExecutorTaskInput input;
    private List<DataQueryExecutorError> errors;

    protected long countTotalItems() {
        RecordFilter recordsFilter = this.createRecordsFilter(false);
        int count = this.recordManager.countRecords(recordsFilter);
        return count;
    }

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        this.errors = new ArrayList<DataQueryExecutorError>();
    }

    protected void onCompleted() {
        super.onCompleted();
        if (this.input.nodeProcessor instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.input.nodeProcessor)));
        }
    }

    @Transactional
    protected void execute() throws Throwable {
        CollectSurvey survey = (CollectSurvey)this.input.query.getSurvey();
        DataQueryEvaluator queryEvaluator = this.createQueryEvaluator(this.input.query);
        RecordFilter filter = this.createRecordsFilter(true);
        List recordSummaries = this.recordManager.loadSummaries(filter);
        Iterator it = recordSummaries.iterator();
        while (it.hasNext() && this.isRunning()) {
            CollectRecordSummary recordSummary = (CollectRecordSummary)it.next();
            CollectRecord record = this.recordManager.load(survey, recordSummary.getId().intValue(), this.input.step, false);
            List<Node<?>> nodes = queryEvaluator.evaluate(record);
            for (Node<?> node : nodes) {
                this.processNode(node);
            }
            this.incrementProcessedItems();
        }
    }

    private void processNode(Node<?> node) {
        try {
            this.input.nodeProcessor.process(node);
        }
        catch (Exception e) {
            this.log().error((Object)String.format("Error executing query %s", this.input.query.getId()), (Throwable)e);
            CollectRecord record = (CollectRecord)node.getRecord();
            this.errors.add(new DataQueryExecutorError(record.getRootEntityKeyValues(), record.getId(), node.getPath(), e.getMessage()));
        }
    }

    private RecordFilter createRecordsFilter(boolean limitResults) {
        CollectSurvey survey = (CollectSurvey)this.input.query.getSurvey();
        EntityDefinition entityDef = (EntityDefinition)survey.getSchema().getDefinitionById(this.input.query.getEntityDefinitionId());
        EntityDefinition rootEntityDef = entityDef.getRootEntity();
        Integer rootEntityId = rootEntityDef.getId();
        RecordFilter filter = new RecordFilter(survey);
        filter.setStep(this.input.step);
        filter.setRootEntityId(rootEntityId);
        if (limitResults) {
            filter.setOffset(Integer.valueOf(0));
            filter.setMaxNumberOfRecords(this.input.maxRecords);
        }
        return filter;
    }

    private DataQueryEvaluator createQueryEvaluator(DataQuery query) {
        return new XPathDataQueryEvaluator(query);
    }

    public DataQueryExecutorTaskInput getInput() {
        return this.input;
    }

    public void setInput(DataQueryExecutorTaskInput input) {
        this.input = input;
    }

    public static class DataQueryExecutorTaskInput {
        private DataQuery query;
        private CollectRecord.Step step;
        private Integer maxRecords;
        private NodeProcessor nodeProcessor;

        public DataQueryExecutorTaskInput(DataQuery query, CollectRecord.Step step, NodeProcessor nodeProcessor) {
            this(query, step, nodeProcessor, null);
        }

        public DataQueryExecutorTaskInput(DataQuery query, CollectRecord.Step step, NodeProcessor nodeProcessor, Integer maxRecords) {
            this.query = query;
            this.step = step;
            this.nodeProcessor = nodeProcessor;
            this.maxRecords = maxRecords;
        }

        public DataQuery getQuery() {
            return this.query;
        }

        public void setQuery(DataQuery query) {
            this.query = query;
        }

        public CollectRecord.Step getStep() {
            return this.step;
        }

        public void setStep(CollectRecord.Step step) {
            this.step = step;
        }

        public Integer getMaxRecords() {
            return this.maxRecords;
        }

        public void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public NodeProcessor getNodeProcessor() {
            return this.nodeProcessor;
        }

        public void setNodeProcessor(NodeProcessor nodeProcessor) {
            this.nodeProcessor = nodeProcessor;
        }
    }

    public static class DataQueryExecutorError {
        private List<String> recordKeys;
        private int recordId;
        private String attributePath;
        private String errorMessage;

        public DataQueryExecutorError(List<String> recordKeys, int recordId, String attributePath, String errorMessage) {
            this.recordKeys = recordKeys;
            this.recordId = recordId;
            this.attributePath = attributePath;
            this.errorMessage = errorMessage;
        }

        public int getRecordId() {
            return this.recordId;
        }

        public List<String> getRecordKeys() {
            return this.recordKeys;
        }

        public String getAttributePath() {
            return this.attributePath;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

