/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataCleansingStepValue;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingStep;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingStepValue;
import org.openforis.collect.persistence.jooq.tables.OfcDataQuery;
import org.openforis.collect.persistence.jooq.tables.records.OfcDataCleansingStepValueRecord;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataCleansingStepDao")
@Transactional
public class DataCleansingStepDao
extends DataCleansingItemDao<DataCleansingStep, JooqDSLContext> {
    private static final TableField<?, ?>[] FIELD_FIX_EXPRESSION_FIELDS = new TableField[]{OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION1, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION2, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION3, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION4, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION5, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIELD_FIX_EXPRESSION6};

    public DataCleansingStepDao() {
        super(JooqDSLContext.class);
    }

    public static Select<Record1<Integer>> createQueryIdsSelect(DSLContext dsl, CollectSurvey survey) {
        SelectConditionStep select = dsl.select((SelectField)OfcDataQuery.OFC_DATA_QUERY.ID).from((TableLike)OfcDataQuery.OFC_DATA_QUERY).where(new Condition[]{OfcDataQuery.OFC_DATA_QUERY.SURVEY_ID.eq((Object)survey.getId())});
        return select;
    }

    public List<DataCleansingStep> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP).where(new Condition[]{OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID.in(DataCleansingStepDao.createQueryIdsSelect((DSLContext)dsl, survey))}).orderBy((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.TITLE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl();
        dsl.delete((Table)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP).where(new Condition[]{OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID.in(DataCleansingStepDao.createQueryIdsSelect((DSLContext)dsl, survey))}).execute();
    }

    public List<DataCleansingStep> loadByQuery(DataQuery query) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)query.getSurvey());
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP).where(new Condition[]{OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID.eq((Object)query.getId())});
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void insertStepValues(int stepId, List<DataCleansingStepValue> values) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.STEP_ID, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.SORT_ORDER, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.TYPE, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.CONDITION, OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIX_EXPRESSION));
        fields.addAll(Arrays.asList(FIELD_FIX_EXPRESSION_FIELDS));
        InsertValuesStepN insert = dsl.insertInto((Table)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE, fields).values(Collections.nCopies(fields.size(), "?"));
        BatchBindStep batch = dsl.batch((Query)insert);
        int stepIndex = 0;
        for (DataCleansingStepValue stepValue : values) {
            ArrayList<Object> insertValues = new ArrayList<Object>(Arrays.asList(stepId, stepIndex + 1, String.valueOf(stepValue.getUpdateType().getCode()), stepValue.getCondition(), stepValue.getFixExpression()));
            List<String> fieldFixExpressions = this.getFieldFixExpressionValues(stepValue);
            insertValues.addAll(fieldFixExpressions);
            batch.bind(insertValues.toArray(new Object[insertValues.size()]));
            ++stepIndex;
        }
        batch.execute();
    }

    private List<String> getFieldFixExpressionValues(DataCleansingStepValue stepValue) {
        ArrayList<String> fieldFixExpressions = new ArrayList<String>(FIELD_FIX_EXPRESSION_FIELDS.length);
        for (int i = 0; i < FIELD_FIX_EXPRESSION_FIELDS.length; ++i) {
            List<String> stepValueFieldFixExpressions;
            String fieldFixExpression = null;
            if (stepValue.getUpdateType() == DataCleansingStepValue.UpdateType.FIELD && i < (stepValueFieldFixExpressions = stepValue.getFieldFixExpressions()).size()) {
                fieldFixExpression = stepValueFieldFixExpressions.get(i);
            }
            fieldFixExpressions.add(fieldFixExpression);
        }
        return fieldFixExpressions;
    }

    public void deleteStepValues(int stepId) {
        ((JooqDSLContext)this.dsl()).delete((Table)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE).where(new Condition[]{OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.STEP_ID.eq((Object)stepId)}).execute();
    }

    public void deleteStepValues(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl();
        dsl.delete((Table)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE).where(new Condition[]{OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.STEP_ID.in((Select)dsl.select((SelectField)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.ID).from((TableLike)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP).where(new Condition[]{OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID.in(DataCleansingStepDao.createQueryIdsSelect((DSLContext)dsl, survey))}))}).execute();
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataCleansingStep> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.ID, Sequences.OFC_DATA_CLEANSING_STEP_ID_SEQ, DataCleansingStep.class, survey);
        }

        protected DataCleansingStep newEntity() {
            return new DataCleansingStep(this.getSurvey());
        }

        protected void fromRecord(Record r, DataCleansingStep o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCreationDate((Date)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.CREATION_DATE));
            o.setDescription((String)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.DESCRIPTION));
            o.setModifiedDate((Date)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.MODIFIED_DATE));
            o.setQueryId((Integer)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID));
            o.setTitle((String)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.TITLE));
            o.setType(DataCleansingStep.DataCleansingStepType.fromCode(((String)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.TYPE)).charAt(0)));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.UUID)));
            if (o.getType() == DataCleansingStep.DataCleansingStepType.ATTRIBUTE_UPDATE) {
                o.setUpdateValues(this.loadValues(o));
            }
        }

        protected void fromObject(DataCleansingStep o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.CREATION_DATE, (Object)DataCleansingStepDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.DESCRIPTION, (Object)o.getDescription());
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.MODIFIED_DATE, (Object)DataCleansingStepDao.toTimestamp((Date)o.getModifiedDate()));
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.QUERY_ID, (Object)o.getQueryId());
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.TITLE, (Object)o.getTitle());
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.TYPE, (Object)String.valueOf(o.getType().getCode()));
            q.addValue((Field)OfcDataCleansingStep.OFC_DATA_CLEANSING_STEP.UUID, (Object)o.getUuid().toString());
        }

        private List<DataCleansingStepValue> loadValues(DataCleansingStep step) {
            SelectSeekStep1 select = this.selectFrom((Table)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE).where(new Condition[]{OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.STEP_ID.eq((Object)step.getId())}).orderBy((Field)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.SORT_ORDER);
            Result result = select.fetch();
            return this.toStepValues((Result<OfcDataCleansingStepValueRecord>)result, step);
        }

        private List<DataCleansingStepValue> toStepValues(Result<OfcDataCleansingStepValueRecord> result, DataCleansingStep step) {
            ArrayList<DataCleansingStepValue> values = new ArrayList<DataCleansingStepValue>(result.size());
            for (OfcDataCleansingStepValueRecord record : result) {
                DataCleansingStepValue v = new DataCleansingStepValue();
                String typeVal = (String)record.getValue((Field)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.TYPE);
                v.setUpdateType(DataCleansingStepValue.UpdateType.fromCode(typeVal));
                v.setCondition((String)record.getValue((Field)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.CONDITION));
                v.setFixExpression((String)record.getValue((Field)OfcDataCleansingStepValue.OFC_DATA_CLEANSING_STEP_VALUE.FIX_EXPRESSION));
                if (v.getUpdateType() == DataCleansingStepValue.UpdateType.FIELD) {
                    ArrayList<String> fieldFixExpressions = new ArrayList<String>(FIELD_FIX_EXPRESSION_FIELDS.length);
                    for (int i = 0; i < FIELD_FIX_EXPRESSION_FIELDS.length; ++i) {
                        TableField tableField = FIELD_FIX_EXPRESSION_FIELDS[i];
                        fieldFixExpressions.add((String)record.getValue((Field)tableField));
                    }
                    v.setFieldFixExpressions(fieldFixExpressions);
                }
                values.add(v);
            }
            return values;
        }
    }
}

