/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataQueryType;
import org.openforis.collect.persistence.jooq.tables.records.OfcDataQueryTypeRecord;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataQueryTypeDao")
@Transactional
public class DataQueryTypeDao
extends DataCleansingItemDao<DataQueryType, JooqDSLContext> {
    public DataQueryTypeDao() {
        super(JooqDSLContext.class);
    }

    public List<DataQueryType> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataQueryType.OFC_DATA_QUERY_TYPE).where(new Condition[]{OfcDataQueryType.OFC_DATA_QUERY_TYPE.SURVEY_ID.eq((Object)survey.getId())}).orderBy((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.CODE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((JooqDSLContext)this.dsl()).delete((Table)OfcDataQueryType.OFC_DATA_QUERY_TYPE).where(new Condition[]{OfcDataQueryType.OFC_DATA_QUERY_TYPE.SURVEY_ID.eq((Object)survey.getId())}).execute();
    }

    public DataQueryType loadByCode(CollectSurvey survey, String code) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataQueryType.OFC_DATA_QUERY_TYPE).where(new Condition[]{OfcDataQueryType.OFC_DATA_QUERY_TYPE.SURVEY_ID.eq((Object)survey.getId()), OfcDataQueryType.OFC_DATA_QUERY_TYPE.CODE.eq((Object)code)});
        OfcDataQueryTypeRecord record = (OfcDataQueryTypeRecord)select.fetchOne();
        return record == null ? null : (DataQueryType)((Object)dsl.fromRecord((Record)record));
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataQueryType> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataQueryType.OFC_DATA_QUERY_TYPE.ID, Sequences.OFC_DATA_QUERY_TYPE_ID_SEQ, DataQueryType.class, survey);
        }

        protected DataQueryType newEntity() {
            return new DataQueryType(this.getSurvey());
        }

        protected void fromRecord(Record r, DataQueryType o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCode((String)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.CODE));
            o.setCreationDate((Date)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.CREATION_DATE));
            o.setDescription((String)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.DESCRIPTION));
            o.setLabel((String)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.LABEL));
            o.setModifiedDate((Date)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.MODIFIED_DATE));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.UUID)));
        }

        protected void fromObject(DataQueryType o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.CODE, (Object)o.getCode());
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.CREATION_DATE, (Object)DataQueryTypeDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.DESCRIPTION, (Object)o.getDescription());
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.LABEL, (Object)o.getLabel());
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.MODIFIED_DATE, (Object)DataQueryTypeDao.toTimestamp((Date)o.getModifiedDate()));
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.SURVEY_ID, (Object)o.getSurvey().getId());
            q.addValue((Field)OfcDataQueryType.OFC_DATA_QUERY_TYPE.UUID, (Object)o.getUuid().toString());
        }
    }
}

