/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.component.FieldErrorTooltip;
import org.openforis.collect.designer.util.ComponentUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Popup;
import org.zkoss.zul.impl.XulElement;

public class FieldErrorHandler
extends Hlayout {
    private static final long serialVersionUID = 1L;
    private static final String SCLASS = "fielderrorhandler";
    private static final String ERROR_SCLASS = "error";
    private FieldErrorTooltip tooltip;
    private String message;

    public FieldErrorHandler() {
        ComponentUtil.addClass((HtmlBasedComponent)this, SCLASS);
    }

    public void setSclass(String sclass) {
        super.setSclass(sclass);
        ComponentUtil.addClass((HtmlBasedComponent)this, SCLASS);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.updateErrorFeedback();
    }

    protected void updateErrorFeedback() {
        this.updateTooltip();
        List children = this.getChildren();
        for (Component child : children) {
            if (!(child instanceof XulElement)) continue;
            this.setTooltipOnField((XulElement)child);
            this.updateFieldStyle((XulElement)child);
        }
    }

    protected void updateTooltip() {
        if (StringUtils.isBlank((CharSequence)this.message)) {
            this.removeTooltip();
        } else if (this.tooltip == null) {
            this.initTooltip();
        } else {
            this.tooltip.setMessage(this.message);
        }
    }

    protected void setTooltipOnField(XulElement field) {
        field.setTooltip((Popup)this.tooltip);
    }

    protected void updateFieldStyle(XulElement field) {
        boolean hasError = StringUtils.isNotBlank((CharSequence)this.message);
        ComponentUtil.toggleClass((HtmlBasedComponent)field, ERROR_SCLASS, hasError);
    }

    protected void initTooltip() {
        this.tooltip = new FieldErrorTooltip(this.message);
        super.insertBefore((Component)this.tooltip, null);
    }

    protected void removeTooltip() {
        if (this.tooltip != null) {
            this.removeChild((Component)this.tooltip);
            this.tooltip = null;
        }
    }
}

